<?php

use Illuminate\Http\Request;
use Illuminate\Support\Facades\Route;
use Illuminate\Support\Facades\App;
use Rap2hpoutre\LaravelLogViewer\LogViewerController;
use App\Http\Controllers\ApiController;
use App\Http\Controllers\FeeApiController;
/*
|--------------------------------------------------------------------------
| API Routes
|--------------------------------------------------------------------------
|
| Here is where you can register API routes for your application. These
| routes are loaded by the RouteServiceProvider and all of them will
| be assigned to the "api" middleware group. Make something great!
|
*/


Route::middleware('api')->group(function () {
    Route::post('login', [ApiController::class, 'login']);
    Route::post('token/{userId}', [ApiController::class, 'storeDeviceToken']);
    Route::post('removeToken', [ApiController::class, 'removeDeviceToken']); // Add this route for removing the device token
    Route::get('exams', [ApiController::class, 'examData']);
    Route::get('matrizes', [ApiController::class, 'listarMatrizes']);
    Route::get('comunicados', [ApiController::class, 'listarComunicados']);
    Route::get('exams/pdf', [ApiController::class, 'generatePdfReport']); // Define the route for generating PDF report
    Route::get('pagamento', [ApiController::class, 'ListarConfirmacoesPagamento']);
    Route::get('getClass', [ApiController::class, 'getUserClassName']);
    Route::get('getUser', [ApiController::class, 'getUserInfo']);
    Route::get('books', [ApiController::class, 'listBooks']);
    Route::post('book/download', [ApiController::class, 'downloadBooks']);

    Route::get('sendNotification', [ApiController::class, 'sendPushNotification']);

    //updated status of various features
    Route::get('comunicados/{id}', [ApiController::class, 'updateCommunicadoSeen']);

    // ========================================
    // FEE MODULE API ROUTES
    // ========================================

    // Get fee summary
    Route::get('fees/summary', [FeeApiController::class, 'getSummary']);

    // Get monthly breakdown
    Route::get('fees/monthly', [FeeApiController::class, 'getMonthlyBreakdown']);

    // Get payment references
    Route::get('fees/references', [FeeApiController::class, 'getPaymentReferences']);

    // Generate payment reference
    Route::post('fees/generate-reference', [FeeApiController::class, 'generateReference']);

    // Download receipts
    Route::get('fees/download-receipt/{paymentId}', [FeeApiController::class, 'downloadReceipt']);
    Route::get('fees/download-official-receipt/{paymentId}', [FeeApiController::class, 'downloadOfficialReceipt']);

    // Payment history
    Route::get('fees/payment-history', [FeeApiController::class, 'getPaymentHistory']);

});

//Route::middleware('auth:api')->get('/user', function (Request $request) {
Route::middleware('auth:sanctum')->get('/user', function (Request $request) {
    return $request->user();
});

Route::get('logs', [LogViewerController::class, 'index']);

Route::get('/greeting/{locale}', function (string $locale) {
    if (!in_array($locale, ['pt'])) {
        abort(400);
    }

    App::setLocale($locale);
});

