<?php

namespace App\Http\Livewire\Admin\Downloadcenter;


use App\Http\Controllers\SystemController;
use App\Models\Downloadcenter;
use App\Models\Downloadsetings;
use App\Models\User;
use Illuminate\Validation\ValidationException;
use Jantinnerezo\LivewireAlert\LivewireAlert;
use LaravelMultipleGuards\Traits\FindGuard;
use Livewire\Component;
use Livewire\WithFileUploads;
use Note\Note;

class EditDownload extends Component
{
    use FindGuard, LivewireAlert;

    public $title, $photo, $category_id, $description,$pdf,$author, $user, $model;
    public $validatedData;
    public $updateMode = false;

    protected $listeners = [
        'confirmed',
        'cancelled'
    ];

    public function mount($slug)
    {
        $this->model = Downloadcenter::query()->where('slug', $slug)->first();
        echo $this->title = $this->model->title;
         $this->author = $this->model->author;
        //$this->category_id = $this->model->category_id;
        echo $this->description = $this->model->description;

    }

    protected array $rules = [
        'title' => ['required', 'string'],
          'author' => ['required', 'string'],
        'description' => ['required', 'string'],
        //'category_id' => ['required', 'string'],
        'photo' => ['nullable'], // 2MB Max
        //'pdf' => ['nullable', 'mimes:pdf'], // 2MB Max
    ];

    /**
     * D0 real time validations
     * @param $propertyName
     * @throws ValidationException
     */
    public function updated($propertyName)
    {
        $this->validateOnly($propertyName);
    }

    public function submit()
    {
        $this->validatedData = $this->validate();
        $this->confirm('Tem certeza de que deseja prosseguir?', [
            'toast' => false,
            'position' => 'center',
            'showConfirmButton' => true,
            'confirmButtonText' => 'Sim, eu tenho certeza!',
            'cancelButtonText' => 'Não, cancelar!',
            'onConfirmed' => 'confirmed',
            'onDismissed' => 'cancelled'
        ]);
    }

    public function confirmed()
    {
        $this->model->fill($this->validatedData);
        if ($this->photo) {
            $details = SystemController::store_media($this->photo);
            $this->model->update([
                'media_name' => $details[0],
                'media_url' => $details[1]
            ]);
        }
        if ($this->pdf) {
            $pdfde = SystemController::store_media($this->pdf);
            $this->model->update([
                'pdf_name' => $pdfde[0],
                'pdf_url' => $pdfde[1]
            ]);
        }
        $this->model->update([
            'title' => $this->title,
              'author' => $this->author,
           // 'category_id' => $this->category_id,
            'description' => $this->description
        ]);
        Note::createSystemNotification(Admin::class, 'Detalhes', 'Atualizado com sucesso ' . $this->title);
        $this->emit('noteAdded');
        $this->alert('success', 'Atualizado com sucesso ' . $this->title);
        $this->reset();
        return redirect()->route('admin.downloads');
    }

    public function cancelled()
    {
        $this->alert('error', 'Você cancelou.');
    }
    public function render()
    {
        return view('livewire.admin.downloadcenter.edit-download', [
            //'subjects' => Category::query()->orderBy('name')->get(),
        ]);
    }
}
