<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Support\Facades\Schema;

return new class extends Migration
{
    /**
     * Run the migrations.
     */
    public function up(): void
    {
        Schema::create('users', function (Blueprint $table) {
            $table->uuid('id')->primary();
            $table->uuid('classroom_id')->nullable();
            $table->string('sex')->nullable();
            $table->string('name')->nullable();
            $table->string('slug')->unique();
            $table->string('student_id')->nullable();
            $table->string('dob')->nullable();
  	    $table->string('phone_number');
            $table->string('password');
            $table->boolean('is_active')->default(true);
            $table->boolean('is_paid')->default(true);
            $table->string('email')->nullable();
            $table->timestamp('email_verified_at')->nullable();
            $table->rememberToken();
            $table->softDeletes();
            $table->timestamps();
        });
    }

    /**
     * Reverse the migrations.
     */
    public function down(): void
    {
        Schema::dropIfExists('users');
    }
};
