<div>
    <div class="page-content">
        <div class="main-wrapper">
            <div class="row">
                <div class="col">
                    <div class="card">
                        <div class="card-body" wire:poll.keep-alive>
                            <h5 class="card-title"> Capitulos de livro</h5>
                            <div class="row">
                                <div class="col-md-12">
                                    <input type="search" wire:model="search" placeholder="Pesquisar..."
                                           class="form-control">
                                </div>
                            </div>
                            <div class="table-responsive" wire:init="loadData">
                                @if(count($models))
                                    <table class="table table-hover">
                                        <thead>
                                        <tr>
                                            <th scope="col">#</th>
                                            <th scope="col">Titulo</th>
                                            <th scope="col">Ver</th>
                                            <th scope="col">Editar</th>
                                            <th scope="col">Deletar</th>
                                            <th scope="col">Data/Hora</th>
                                        </tr>
                                        </thead>
                                        <tbody>
                                        @php($count = 1)
                                        @foreach($models as $model)
                                            <tr>
                                                <th scope="row">{{ $count++ }}</th>
                                                <td>{{ $model->title }}</td>
                                                <td>
                                                    <a href="{{ route('admin.show.book.chapter', $model->slug) }}"
                                                       class="btn btn-outline-primary"><span
                                                            class="fa fa-eye">Visualizar </span></a>
                                                </td>
                                                <td>
                                                    <a href="{{route('admin.edit.chapter',$model->slug)}}"
                                                       class="btn btn-outline-primary"><span
                                                            class="fa fa-edit"></span>
                                                    </a>
                                                </td>
                                                <td>
                                                    <button wire:click="submit('{{ $model->id }}')"
                                                            class="btn btn-danger btn-sm">Deletar
                                                    </button>
                                                </td>
                                                <td>{{ date('F d, Y h:i a', strtotime($model->created_at)) }}</td>
                                            </tr>
                                        @endforeach
                                        </tbody>
                                    </table>
                                    <div class="row float-end">
                                        {{ $models->links() }}
                                    </div>
                                @else
                                    <br>
                                    <br>
                                    <div  class="d-flex justify-content-center">
                                        <div wire:loading class="spinner-border text-primary" role="status">
                                            <span class="sr-only">Processando...</span>
                                        </div>
                                    </div>
                                    <p class="text-center"><B>Nenhum dado foi encontrado no momento.</B></p>
                                @endif
                            </div>
                        </div>
                    </div>
                </div>
            </div>
        </div>

    </div>
</div>
