<div>
    <div class="page-content">
        <div class="main-wrapper">
            <div class="row">
                <div class="col">
                    <div class="card">
                        <div class="card-body" wire:init="loadData">
                            <h5 class="card-title">  Estudantes da {{ $class->name }}</h5>
                            <div class="row">
                                <div class="col-md-12">
                                    <input type="search" wire:model="search" placeholder="Pesquisar..."
                                        class="form-control">
                                </div>
                            </div>
                            <div class="table-responsive" wire:init="loadData">
                                @if (count($models))
                                    <table class="table table-hover">
                                        <thead>
                                            <tr>
                                                <th scope="col">#</th>
                                                <th scope="col">Nome</th>
                                                <th scope="col">Sexo</th>
                                                <th scope="col">Data nascimento</th>
                                                <th scope="col">ID do Estudante</th>
                                                <th scope="col">Turma</th>
                                                <th scope="col">Classe</th>
                                                <th scope="col">Inserir</th>
                                                <th scope="col">Lançar notas</th>
                                                <th scope="col">Visualizar</th>

                                            </tr>
                                        </thead>
                                        <tbody>
                                            @php($count = 1)
                                            @foreach ($models as $model)
                                                <tr>
                                                    <th scope="row">{{ $count++ }}</th>
                                                    <?php $key = 'modal_' . $count ?>
                                                    <td>{{ $model->name }}</td>
                                                    <td>{{ $model->sex }}</td>
                                                    <td>{{ $model->dob }}</td>
                                                    <td>{{ $model->student_id }}</td>

                                                    <td>{{ $model->class->name }}</td>
                                                    <td>{{ $model->class->class }} &nbsp;&nbsp;Classe </td>
                                                    <td>
                                                        <a href="{{route('admin.add.student.grade',$model->slug)}}"
                                                           class="btn btn-outline-primary"><span
                                                                class="fa fa-plus"></span>
                                                        </a>
                                                    </td>
                                                    <td><a class="dropdown-item text-primary" href="javascript:;"
                                                        data-bs-toggle="modal"
                                                        data-bs-target="#modal_{{ $model->id }}">Lançar
                                                        notas</a></td>
                                                        <td><a class="dropdown-item text-info"
                                                            href="{{ route('admin.list.students.marks', $model->slug) }}">Visualizar</a></td>
                                                </tr>
                                                <livewire:admin.classes.modal-exam :model="$model"
                                                    :wire:key="$model->id">

                                                    <div wire:ignore.self class="modal fade" id="modal_{{ $model->id }}"
                                                        tabindex="-1" aria-labelledby="exampleModalLabel"
                                                        aria-hidden="true">
                                                        <div class="modal-dialog  modal-lg modal-dialog-centered">
                                                            <div class="modal-content">
                                                                <div class="modal-header">
                                                                    <h5 class="modal-title"
                                                                        id="exampleModalCenterTitle">
                                                                        {{ $model->name }}
                                                                    </h5>
                                                                    <button type="button" class="btn-close"
                                                                    data-bs-dismiss="modal"
                                                                        
                                                                        aria-label="Close"></button>
                                                                </div>
                                                                <div class="modal-body">
                                                                    <div class="row">
                                                                        <form class="row g-3" wire:submit.prevent="submit">
                                                                            <div class="col-md-12">
                                                                                <label for="title" class="form-label">Disciplina </label>
                                                                                <select class="form-control @error('subject_id') is-invalid @enderror" id="name"
                                                                                    wire:model="subject_id" class="form-control input-lg dynamic">
                                                                                    <option value="" selected>Por favor selecione a disciplina</option>
                                                                                    @foreach ($subjects as $subject)
                                                                                        <option value="{{ $subject->id }}"> {{ $subject->name }} </option>
                                                                                    @endforeach
                                                                                </select>
                                                                                @error('subject_id')
                                                                                    <span class="invalid-feedback" role="alert">
                                                                                        <strong>{{ $message }}</strong>
                                                                                    </span>
                                                                                @enderror
                                                                            </div>

                                                                            <div class="col-md-12">
                                                                                <label for="title" class="form-label">Trimestre </label>
                                                                                <select class="form-control @error('trimester_id') is-invalid @enderror" id="trimester_id"
                                                                                    wire:model="trimester_id" class="form-control input-lg dynamic">
                                                                                    <option value="">Selecione o trimestre</option>
                                                                                    <option value="1">Primeiro trimestre</option>
                                                                                    <option value="2">Segundo trimestre</option>
                                                                                    <option value="3">Terceiro trimestre</option>

                                                                                </select>
                                                                                @error('trimester_id')
                                                                                    <span class="invalid-feedback" role="alert">
                                                                                        <strong>{{ $message }}</strong>
                                                                                    </span>
                                                                                @enderror
                                                                            </div>
                                                                            <div class="col-md-12">
                                                                                <label for="title" class="form-label"> Tipo de teste </label>
                                                                                <select class="form-control @error('type') is-invalid @enderror" id="type"
                                                                                    wire:model="type" class="form-control input-lg dynamic">
                                                                                    <option value="" selected>Selecione o tipo de teste</option>
                                                                                    <option value="1">ACS1</option>
                                                                                    <option value="2">ACS2</option>
                                                                                    <option value="3">NE</option>
                                                                                    <option value="4">NE</option>


                                                                                </select>
                                                                                @error('type')
                                                                                    <span class="invalid-feedback" role="alert">
                                                                                        <strong>{{ $message }}</strong>
                                                                                    </span>
                                                                                @enderror
                                                                            </div>
                                                                            <div class="col-md-12">
                                                                                <label for="MACS" class="form-label">Nota</label>
                                                                                <input type="number" class="form-control @error('MACS') is-invalid @enderror" id="MACS"
                                                                                    required placeholder="Insira a nota..." wire:model="MACS">
                                                                                @error('MACS')
                                                                                    <span class="invalid-feedback" role="alert">
                                                                                        <strong>{{ $message }}</strong>
                                                                                    </span>
                                                                                @enderror
                                                                            </div>

                                                                            <br><br>
                                                                            <div class="col-12">
                                                                                <button type="submit" class="btn btn-primary btn-lg float-end" wire:loading.class="disabled"
                                                                                    wire:offline.attr="disabled"><span wire:target="submit"
                                                                                        wire:loading.class="spinner-border spinner-border-lg"></span>
                                                                                    Guardar
                                                                                </button>
                                                                            </div>
                                                                        </form>
                                                                    </div>
                                                                    <div class="modal-footer">
                                                                        <button type="button" class="btn btn-secondary"
                                                                            data-bs-dismiss="modal">
                                                                            Fechar
                                                                        </button>
                                                                    </div>
                                                                </div>
                                                            </div>
                                                        </div>
                                            @endforeach
                                        </tbody>
                                    </table>
                                    <div class="row float-end">
                                        {{ $models->links() }}
                                    </div>
                                @else
                                    <br>
                                    <br>
                                    <div class="d-flex justify-content-center">
                                        <div wire:loading class="spinner-border text-primary" role="status">
                                            <span class="sr-only">Processando...</span>
                                        </div>
                                    </div>
                                    <p class="text-center"><B>Nenhum dado foi encontrado no momento.</B></p>
                                @endif
                            </div>
                        </div>
                    </div>
                </div>
            </div>
        </div>

    </div>
</div>
