<div>
    <div class="page-content">
        <div class="main-wrapper">
            <div class="row">
                <div class="col">
                    <div class="card">
                        <div class="card-body">
                            <h5 class="card-title">Adicionar estudante</h5>
                            <form class="row g-3" wire:submit.prevent="submit">
                                <div class="col-md-6">
                                    <label for="name" class="form-label">Nome completo</label>
                                    <input type="text" class="form-control @error('name') is-invalid @enderror"
                                           id="name" required placeholder="Insira nome completo..." wire:model="name">
                                    @error('name')
                                    <span class="invalid-feedback" role="alert">
                                        <strong>{{ $message }}</strong>
                                    </span>
                                    @enderror
                                </div>
  					<div class="col-md-6">
                                    <label for="phone_number" class="form-label">Número celular</label>
                                    <input type="text" class="form-control @error('phone_number') is-invalid @enderror"
                                           id="phone_number" required placeholder="84928XXXX..."
                                           wire:model="phone_number">
                                    @error('phone_number')
                                    <span class="invalid-feedback" role="alert">
                                        <strong>{{ $message }}</strong>
                                    </span>
                                    @enderror
                                </div>
                                <div class="col-md-6">
                                    <label for="sex" class="form-label">Sexo</label>
                                    <select class="form-control @error('sex') is-invalid @enderror"
                                            id="name" wire:model="sex"
                                            class="form-control input-lg dynamic">
                                        <option value="">Escolha o sexo</option>
                                        <option value="Masculino">Masculino</option>
                                        <option value="Feminino">Feminino</option>
                                    </select>
                                    @error('sex')
                                    <span class="invalid-feedback" role="alert">
                                        <strong>{{ $message }}</strong>
                                    </span>
                                    @enderror
                                </div>
                                    <div class="col-md-6">
                                    <label for="class" class="form-label">Classe</label>
                                    <select class="form-control @error('class') is-invalid @enderror"
                                            id="class" wire:model="class"
                                            class="form-control input-lg dynamic">
                                            <option value="">Por favor selecione a classe</option>
                                            <option value="1">1ª Classe</option>
                                            <option value="2">2ª Classe</option>
                                            <option value="3">3ª Classe</option>
                                            <option value="4">4ª Classe</option>
                                            <option value="5">5ª Classe</option>
                                            <option value="6">6ª Classe</option>
                                            <option value="7">7ª Classe</option>
                                            <option value="8">8ª Classe</option>
                                            <option value="9">9ª Classe</option>
                                            <option value="10">10ª Classe</option>
                                            <option value="11">11ª Classe</option>
                                            <option value="12">12ª Classe</option>
                                    </select>
                                    @error('class')
                                    <span class="invalid-feedback" role="alert">
                                        <strong>{{ $message }}</strong>
                                    </span>
                                    @enderror
                                </div>
                                <div class="col-md-6">
                                   <label for="title" class="form-label">Turma</label>
                                    <select class="form-control @error('classroom_id') is-invalid @enderror"
                                            id="name" wire:model="classroom_id"
                                            class="form-control input-lg dynamic">
                                        <option value="">Selecione a turma</option>
                                        @foreach($classes as $class)
                                            <option value="{{ $class->id }}"> {{ $class->name }} </option>
                                        @endforeach
                                    </select>
                                    @error('classroom_id')
                                    <span class="invalid-feedback" role="alert">
                                        <strong>{{ $message }}</strong>
                                    </span>
                                    @enderror
                                </div>
                                <div class="col-md-6">
                                    <label for="email" class="form-label">Email</label>
                                    <input type="email" class="form-control @error('email') is-invalid @enderror"
                                           id="email" required placeholder="Insira o email..." wire:model="email">
                                    @error('email')
                                    <span class="invalid-feedback" role="alert">
                                        <strong>{{ $message }}</strong>
                                    </span>
                                    @enderror
                                </div>
                                <div class="col-md-6">
                                    <label for="student_id" class="form-label">ID do Estudante</label>
                                    <input type="student_id"
                                           class="form-control @error('student_id') is-invalid @enderror"
                                           id="student_id" required placeholder="Insira o ID do Estudante..."
                                           wire:model="student_id">
                                    @error('student_id')
                                    <span class="invalid-feedback" role="alert">
                                        <strong>{{ $message }}</strong>
                                    </span>
                                    @enderror
                                </div>
                                <div class="col-md-6">
                                    <label for="dob" class="form-label">Data de nascimento</label>
                                    <input type="date"
                                           class="form-control @error('dob') is-invalid @enderror"
                                           id="dob" required placeholder="Insira data de nascimento..."
                                           wire:model="dob">
                                    @error('dob')
                                    <span class="invalid-feedback" role="alert">
                                        <strong>{{ $message }}</strong>
                                    </span>
                                    @enderror
                                </div>
                                <div class="col-12">
                                    <button type="submit" class="btn btn-primary btn-lg float-end"
                                            wire:loading.class="disabled"
                                            wire:offline.attr="disabled"><span wire:target="submit"
                                                                               wire:loading.class="spinner-border spinner-border-lg"></span>
                                        Guardar
                                    </button>
                                </div>
                            </form>
                        </div>
                    </div>
                </div>
            </div>
        </div>
    </div>
</div>
