<?php

namespace App\Http\Livewire\Admin;

use App\Charts\UserChart;
use App\Charts\UserPieChart;
use App\Models\Admin;
use App\Models\Classroom;
use App\Models\TeacherSubject;
use App\Models\Subject;
use App\Models\User;
use Carbon\Carbon;
use LaravelMultipleGuards\Traits\FindGuard;
use Livewire\Component;
use Illuminate\Support\Facades\Auth;

class AdminHome extends Component
{
    protected $lazy = false;
    use FindGuard;

    public $account;
    public $orders;
    private $seo_pie_chart;
    private $chart3;
    public $user;
    public bool $readyToLoad = false;


    public function loadData()
    {
        $this->readyToLoad = true;
    }

    public function charts()
    {


        //chart 3 pie chart
        $this->chart3 = new UserPieChart();
        $this->chart3->labels(['Classes', 'Disciplinas', 'Estudantes']);
        $this->chart3->dataset('Visão Geral', 'bar', [
            count(Classroom::query()->get()),
            count(Subject::query()->get()),
            count(User::query()->get())
        ])->backgroundColor(collect(['#7158e2', '#3ae374', '#ff3838', '#ffc107']))->color(collect(['#7d5fff', '#32ff7e', '#ff4d4d', '#0000ff']));

        //seo pie chart
        $this->seo_pie_chart = new UserPieChart();
        $this->seo_pie_chart->labels(['Classes', 'Disciplinas', 'Estudantes']);
        $this->seo_pie_chart->dataset('Classes', 'pie', [
            count(Classroom::query()->get()),
            count(Subject::query()->get()),
            count(User::query()->get())
        ])->backgroundColor(collect(['#7158e2', '#3ae374', '#ff3838', '#ffc107']))->color(collect(['#7d5fff', '#32ff7e', '#ff4d4d', '#0000ff']));
        return [
            $this->seo_pie_chart,
            $this->chart3,
        ];
    }

    public function render()
    {
       // dd(Auth::user());
         $this->user = $this->findGuardType()->user();
         $teacherId = $this->user->id;
        return view('livewire.admin.admin-home', [
            'classes' => $this->readyToLoad ? count(Classroom::query()->get()) : 0,
            'teacher_class' => $this->readyToLoad ? TeacherSubject::query()
        ->where('teacher_id', $teacherId)
        ->distinct('classroom_id')
        ->count() : 0,
            'students' => $this->readyToLoad ? count(User::query()->get()) : 0,
            'subjects' => $this->readyToLoad ? count(Subject::query()->get()) : 0,
            'admins' => $this->readyToLoad ? count(Admin::query()->get()) : 0,
            'seo_pie_chart' => $this->charts()[0],
            'chart3' => $this->charts()[1],
        ]);
    }
}
