<?php

namespace App\Http\Livewire\Admin\Books;

use App\Models\Admin;
use App\Models\Subject;
use Illuminate\Validation\ValidationException;
use Jantinnerezo\LivewireAlert\LivewireAlert;
use LaravelMultipleGuards\Traits\FindGuard;
use Livewire\Component;
use Note\Note;
use App\Http\Controllers\SystemController;
use App\Models\Book;
use App\Models\BookTitle;

class ShowChapterDetails extends Component
{
    use FindGuard, LivewireAlert;

    public $title,$photo,$book_id,$description, $user, $model;
    public $validatedData;
    public $updateMode = false;

    protected $listeners = [
        'confirmed',
        'cancelled'
    ];

    public function mount($slug)
    {
        $this->model = BookTitle::query()->where('slug',$slug)->first();
        $this->title = $this->model->title;
        $this->book_id = $this->model->book_id;
        $this->description = $this->model->description;
    }

    protected array $rules = [
        'title' => ['required', 'string', 'max:60', 'min:35'],
        'description' => ['required', 'string'],
        'book_id' => ['required', 'string', 'max:60', 'min:20'],
    ];

    /**
     * D0 real time validations
     * @param $propertyName
     * @throws ValidationException
     */
    public function updated($propertyName)
    {
        $this->validateOnly($propertyName);
    }

    public function submit()
    {
        $this->validatedData = $this->validate();
        $this->confirm('Tem certeza de que deseja prosseguir?', [
            'toast' => false,
            'position' => 'center',
            'showConfirmButton' => true,
            'confirmButtonText' => 'Sim, eu tenho certeza!',
            'cancelButtonText' => 'Não, cancelar!',
            'onConfirmed' => 'confirmed',
            'onDismissed' => 'cancelled'
        ]);
    }

    public function confirmed()
    {
        $this->model->fill($this->validatedData);
        $this->model->update([
            'title' => $this->title,
            'book_id' => $this->book_id,
            'description' => $this->description
        ]);
        Note::createSystemNotification(Admin::class, 'Detalhes', 'Atualizado com sucesso ' . $this->name);
        $this->emit('noteAdded');
        $this->alert('success', 'Atualizado com sucesso ' . $this->name);
        $this->reset();
        return redirect()->route('admin.list.classes');
    }

    public function cancelled()
    {
        $this->alert('error', 'Você cancelou.');
    }
    public function render()
    {
        return view('livewire.admin.books.show-chapter-details', [
            'books' => Book::query()->orderBy('title')->get(),
        ]);
    }
}
