<?php

namespace App\Http\Livewire\Admin\Chapters;

use App\Models\Admin;
use App\Models\Subject;
use Illuminate\Validation\ValidationException;
use Jantinnerezo\LivewireAlert\LivewireAlert;
use LaravelMultipleGuards\Traits\FindGuard;
use Livewire\Component;
use Note\Note;
use App\Http\Controllers\SystemController;
use App\Models\Book;
use App\Models\BookTitle;

class AddBookChapter extends Component
{
    use FindGuard, LivewireAlert;

    public $title,$description,$book_id,  $validatedData;
    public $updateMode = false;
    public $user;
    protected $listeners = [
        'confirmed',
        'cancelled'
    ];

    protected array $rules = [
        'title' => ['required', 'string', 'max:255'],
        'book_id' => ['required', 'string', 'max:255'],
        'description' => ['required', 'string', 'max:255'],
    ];

    /**
     * D0 real time validations
     * @param $propertyName
     * @throws ValidationException
     */
    public function updated($propertyName)
    {
        $this->validateOnly($propertyName);
    }

    public function submit()
    {
        $this->validatedData = $this->validate();
        $this->confirm('Tem certeza de que deseja prosseguir?', [
            'toast' => false,
            'position' => 'center',
            'showConfirmButton' => true,
            'confirmButtonText' => 'Sim, eu tenho certeza!',
            'cancelButtonText' => 'Não, cancelar!',
            'onConfirmed' => 'confirmed',
            'onDismissed' => 'cancelled'
        ]);
    }

    public function confirmed()
    {
        $query = new BookTitle();
        $last = $query->newQuery()->latest()->first();
        if ($last) {
            $steps = $last->read_no + 1;
        } else {
            $steps = 1;
        }
        BookTitle::query()->create([
            'title' => $this->title,
            'read_no' => $steps,
            'book_id' => $this->book_id,
            'description' => $this->description,
        ]);
        Note::createSystemNotification(Admin::class, 'Novo capitulo', ' Novo capitulo criado com sucesso ' . $this->title);
        $this->emit('noteAdded');
        $this->alert('success', 'Novo capitulo criado com sucesso ' . $this->title);
        $this->reset();
    }

    public function cancelled()
    {
        $this->alert('error', 'Você cancelou.');
    }
    public function render()
    {
        return view('livewire.admin.chapters.add-book-chapter', [
            'books' => Book::query()->orderBy('title')->get(),
        ]);
    }

}
