<?php

namespace App\Http\Livewire\Admin\Classes;

use App\Models\Classroom;
use App\Models\Project;
use App\Models\User;
use App\Models\Exam;
use Illuminate\Validation\ValidationException;
use Jantinnerezo\LivewireAlert\LivewireAlert;
use LaravelMultipleGuards\Traits\FindGuard;
use Livewire\Component;
use Livewire\WithPagination;
use Note\Note;


class ListClassStudents extends Component
{
    public bool $isAllDeactivated = false;
    protected $lazy = false;
    use FindGuard, LivewireAlert;
    use WithPagination;
    public $selectAll = false; // Select All checkbox status
    public $selected = [];

    public $search;
    public $model, $project, $name, $year;
    protected $queryString = ['search'];

    protected string $paginationTheme = 'bootstrap';

    public function updatingSearch()
    {
        $this->resetPage();
    }

    public bool $readyToLoad = false;

    public function loadData()
    {
        $this->readyToLoad = true;
    }

    public function mount($slug)
    {
        $this->model = Classroom::query()->where('slug', $slug)->first();
        $this->name = $this->model->name;
    }

    public function updatedSelectAll($value)
    {
       if ($value) {
           $this->selected = User::where('classroom_id', $this->model->id)->pluck('id')->toArray();
        } else {
            $this->selected = [];
        }
    }

    public function deactivateSelected()
    {
        if (count($this->selected) > 0) {
            User::whereIn('id', $this->selected)->update(['is_active' => 0]);
            session()->flash('message', 'Selected students have been deactivated successfully.');
            $this->reset('selected', 'selectAll'); // Reset selections
        } else {
            session()->flash('message', 'No students selected.');
        }
    }


    public function activateSelected()
    {
        if (count($this->selected) > 0) {
                User::whereIn('id', $this->selected)->update(['is_active' => 1]);
                session()->flash('message', 'Selected students have been activated successfully.');
                $this->reset('selected', 'selectAll'); // Reset selections
            } else {
                session()->flash('message', 'No students selected.');
        }
    }
    
//    public function toggleSelected()
//    {
//        if (count($this->selected) > 0) {
//            // Check if all selected users are currently inactive
//            $areAllInactive = User::whereIn('id', $this->selected)->where('is_active', false)->count() === count($this->selected);
//
//            // Toggle the state based on the current status
//            $newStatus = $areAllInactive ? true : false;
//
//            User::whereIn('id', $this->selected)->update(['is_active' => $newStatus]);
//
//            $message = $newStatus ? 'Selected students have been activated successfully.' : 'Selected students have been deactivated successfully.';
//            session()->flash('message', $message);
//
//            // Reset selections
//            $this->reset('selected', 'selectAll');
//        } else {
//            session()->flash('message', 'No students selected.');
//        }
//    }
//
//
//   
//
//    public function updatedSelected()
//    {
//        $this->isAllDeactivated = $this->checkIfAllDeactivated();
//    }
//    
//    
//
//    private function checkIfAllDeactivated()
//    {
//        return count($this->selected) > 0
//            ? User::whereIn('id', $this->selected)->where('is_active', false)->count() === count($this->selected)
//            : false;
//    }


    


    public function render()
{
    if(!empty($this->year)  ){
        $users = Exam::where("trimester_id","1")->where("year",$this->year)->where("classroom_id",$this->model->id)->distinct()->pluck('student_id');
        $userss = array();
        foreach($users as $user){
            $userss[] = $user;
        }
        //dd($this->model->id,$userss);    
        return view('livewire.admin.classes.list-class-students', [
        'models' => $this->readyToLoad
            ? User::query()
                ->where(function ($query) {
                    $query->orWhere('name', 'like', '%' . $this->search . '%')
                        ->orWhere('sex', 'like', '%' . $this->search . '%')
                        ->orWhere('phone_number', 'like', '%' . $this->search . '%')
                        ->orWhere('year_edu', $this->search )
                        ->orWhere('slug', 'like', '%' . $this->search . '%');
                })
                ->whereIn('id', $userss)
                ->orderBy('name') // Order by the 'name' column alphabetically
                ->paginate(10)
                
            : []
        ]);
    }else{
        return view('livewire.admin.classes.list-class-students', [
        'models' => $this->readyToLoad
            ? User::query()
                ->where(function ($query) {
                    $query->orWhere('name', 'like', '%' . $this->search . '%')
                        ->orWhere('sex', 'like', '%' . $this->search . '%')
                        ->orWhere('phone_number', 'like', '%' . $this->search . '%')
                        ->orWhere('year_edu', $this->search )
                        ->orWhere('slug', 'like', '%' . $this->search . '%');
                })
                ->where('classroom_id', $this->model->id)
                ->orderBy('name') // Order by the 'name' column alphabetically
                ->paginate(10)
                
            : []
        ]);

    }
    
}

}
