<?php

namespace App\Http\Livewire\Admin\Downloadcenter;

use App\Models\Admin;
use App\Models\Downloadcenter;
use App\Models\Classroom;
use App\Models\User;
use App\Models\Downloadfile;
use App\Models\Downloadsetings;
use Illuminate\Validation\ValidationException;
use Jantinnerezo\LivewireAlert\LivewireAlert;
use LaravelMultipleGuards\Traits\FindGuard;
use Livewire\Component;
use Note\Note;
use App\Http\Controllers\SystemController;
use App\Models\Category;
use Livewire\WithFileUploads;
use Kreait\Firebase\Factory;
use Kreait\Firebase\Messaging\CloudMessage;
use Kreait\Firebase\Messaging\Notification;
use Illuminate\Support\Facades\Log;


class AddDownload extends Component
{
    use FindGuard, LivewireAlert, WithFileUploads;

    
    public $media_details; 
    public $title, $description, $category_id, $photo,  $pdf, $author,  $validatedData, $type, $class_id, $student_id;
    public $photos = [];
    public $updateMode = false;
    public $user;
    protected $listeners = [
        'confirmed',
        'cancelled'
    ];

    protected array $rules = [
        'title' => ['required', 'string', 'max:255'],
        'author' => ['required', 'string', 'max:255'],
        'description' => ['nullable', 'string', 'max:255'],
        'photos.*' => ['required', 'mimes:pdf,doc,docx,xls,xlsx,png,jpeg,jpg,gif', 'max:51200'],
    ];

    /**
     * D0 real time validations
     * @param $propertyName
     * @throws ValidationException
     */
    public function updated($propertyName)
    {
        $this->validateOnly($propertyName);

    }


public function submit()
{
    $this->validate(); // Validate all fields including multiple files
    // Define a mensagem padrão
    $this->message = 'Nova matriz: "' . $this->title . ' autor: ' . $this->author . '" foi lançada.';

    $downloadcenter = Downloadcenter::create([
        'title' => $this->title,
        'author' => $this->author,
        'description' => $this->description,
    ]);

    Downloadsetings::create([
            'type' => $this->type,
            'class_id' => $this->class_id,
            'student_id' => $this->student_id,
            "download_id" => $downloadcenter->slug,
            "active" => "active",
        ]);
    foreach ($this->photos as $photo) {
        $details = SystemController::store_media($photo);
        
        

        Downloadfile::create([
            'download_id' => $downloadcenter->slug,
            'media_name' => $details[0],
            'media_url' => $details[1],
        ]);

        if (empty($this->type)) {
            $this->type = "all";
        }
    }

    Note::createSystemNotification(Admin::class, 'Nova matriz', 'Nova matriz adicionada com sucesso ' . $this->title);
        $this->emit('noteAdded');
        $this->alert('success', 'Nova matriz adicionada com sucesso ' . $this->title);
        //$this->reset();

         // Check the type of notification
         if ($this->type == 'all') {
            // Send notification to all users
            $users = User::whereHas('deviceTokens')->get();
            $this->sendNotifications($users);

            
        } elseif ($this->type == 'class') {
            // Send notification to all students in the specified class
            $users = User::where('classroom_id', $this->class_id)->get();
            $this->sendNotifications($users);
            
        } elseif ($this->type == 'student') {
            // Send notification to a specific student
            $user = User::find($this->student_id);
            if ($user) {
                $this->sendNotifications([$user]);
            }
        }

    // Reset fields and flash success message
     $this->reset(['title', 'author', 'description', 'photos', 'type', 'class_id', 'student_id']);
     session()->flash('success', 'Push notification sent successfully.');
   
}

 
    public function cancelled()
    {
        $this->alert('error', 'Você cancelou.');
    }


    private function sendNotifications($users)
{
    // Your Firebase credentials (make sure to securely store your private key)
    $firebaseCredentials = [
        "type" => env("FIREBASE_TYPE"),
        "project_id" => env("FIREBASE_PROJECT_ID"),
        "private_key_id" => env("FIREBASE_PRIVATE_KEY_ID"),
        "private_key" => str_replace("\\n", "\n", env("FIREBASE_PRIVATE_KEY")),
        "client_email" => env("FIREBASE_CLIENT_EMAIL"),
        "client_id" => env("FIREBASE_CLIENT_ID"),
        "auth_uri" => "https://accounts.google.com/o/oauth2/auth",
        "token_uri" => "https://oauth2.googleapis.com/token",
        "auth_provider_x509_cert_url" => "https://www.googleapis.com/oauth2/v1/certs",
        "client_x509_cert_url" => env('FIREBASE_CLIENT_X509_CERT_URL'),
        "universe_domain" => "googleapis.com"
    ];
    
    $factory = (new Factory)->withServiceAccount($firebaseCredentials);
    $messaging = $factory->createMessaging();

    foreach ($users as $user) {
        $tokens = $user->deviceTokens()->pluck('token');
        
        foreach ($tokens as $token) {
            try {
                if (strlen($token) >= 152) {
                    $notification = Notification::fromArray([
                        'token' => $token,
                        'title' => $this->title,
                        'body' => $this->message,
                        'image' => null,
                    ]);

                    $message = CloudMessage::withTarget('token', $token)
                        ->withNotification($notification)
                        ->withHighestPossiblePriority()
                        ->withDefaultSounds();
                    $messaging->send($message);
                } else {
                    Log::channel('log_notifications')->error("Invalid token for user: {$user->name} - Token: $token. Notification not sent.");
                }
            } catch (NotFound $e) {
                Log::channel('log_notifications')->error("{$user->name} - Token not found: {$e->getMessage()}");
            } catch (\Exception $e) {
                Log::channel('log_notifications')->error("An error occurred: {$e->getMessage()}");
            }
        }
    }
}

    public function render()
    {
        if(!empty($this->type)){
            return view('livewire.admin.downloadcenter.add-download', [
                'Classroom' => Classroom::query()->orderBy('class')->get(),
                'students' => User::Where("classroom_id",$this->class_id)->get(),
            ]);
        }else{
            return view('livewire.admin.downloadcenter.add-download', [
                'Classroom' => Classroom::query()->orderBy('class')->get(),
            ]);
        }
    }
}
