<?php

namespace App\Http\Livewire\Admin\Fee;

use App\Models\FeeMaster1;
use App\Models\User;
use App\Models\Classroom;
use Livewire\Component;
use App\Models\Fee_assign;

class FeeAssign extends Component
{
    public $feeMaster;
    public $feeGroupName;
    public $feeTypeName;
    public $matchedFees;
    public $selectedClass = null;
    public $students = []; // To store students data
    public $selectedFeeGroup = null;
    public $selectedStudents = [];


    public function mount($id)
    {
        $this->feeMaster = FeeMaster1::with(['feeGroup', 'feeType'])->findOrFail($id);

        $this->feeGroupName = $this->feeMaster->feeGroup->name ?? 'N/A';
        $this->feeTypeName = $this->feeMaster->feeType->name ?? 'N/A';
        $this->matchedFees = FeeMaster1::with(['feeGroup', 'feeType'])
            ->where('fee_group_id', $this->feeMaster->fee_group_id)
            ->get();
    }

    public function updatedSelectedClass($classId)
    {
        // Fetch students whose class matches the selected class ID
        $this->students = User::where('classroom_id', $classId)->get();
    }
    public function assignFeeGroup()
    {
        $this->validate([
            'selectedFeeGroup' => 'required|exists:fee_master1s,id',
            'selectedStudents' => 'required|array|min:1',
            'selectedStudents.*' => 'exists:users,id',
        ]);

        foreach ($this->selectedStudents as $studentId) {
            Fee_assign::create([
                'student_id' => $studentId,
                'fee_group_id' => $this->selectedFeeGroup,
                'status' => 'unpaid', // Add other fields as needed
            ]);
        }

        session()->flash('message', 'Grupo de taxas atribuído com sucesso aos alunos selecionados.');
    }
    public function render()
    {
        return view('livewire.admin.fee.fee-assign', [
            'Classroom' => Classroom::all(),
            'feeGroupName' => $this->feeGroupName,
            'feeTypeName' => $this->feeTypeName,
            'matchedFees' => $this->matchedFees,
            'students' => $this->students,
        ]);
    }
}