<?php

namespace App\Http\Livewire\Admin\Reports;

use App\Exports\AllSubject;
use App\Exports\AllpautaSubject;
use App\Models\Admin;
use App\Models\Classroom;
use App\Models\User;
use App\Models\Payment;
use App\Models\Project;
use App\Models\Subject;
use Illuminate\Support\Str;
use Illuminate\Validation\ValidationException;
use Jantinnerezo\LivewireAlert\LivewireAlert;
use Note\Note;
use LaravelMultipleGuards\Traits\FindGuard;
use Livewire\Component;
use Maatwebsite\Excel\Facades\Excel;
use App\Exports\ExportExams;

class GenerateCombine extends Component
{
    use FindGuard, LivewireAlert;

    public $trimester_id;
    public $class_id;
    public $user_id, $class, $year;
    public $subject_id;
    public $report = [];
    public $reports;
    public bool $readyToLoad = false;

    protected $listeners = [
        'confirmed',
        'cancelled'
    ];

    public function loadReport()
    {
        $this->readyToLoad = true;
    }

    protected array $rules = [
        'user_id' => ['string', 'nullable'],
        'class_id' => ['string', 'required'],
        'class' => ['string', 'required'],
        'year' => ['string', 'required'],
        'trimester_id' => ['string', 'required'],
    ];

    /**
     * D0 real time validations
     * @param $propertyName
     * @throws ValidationException
     */
    public function updated($propertyName)
    {
        $this->validateOnly($propertyName);
    }
    /**
     * generate report
     * @throws Exception
     */
    public function generateReport()
    {
      $this->validate();
        $this->confirm('Tem certeza de que deseja prosseguir?', [
            'toast' => false,
            'position' => 'center',
            'showConfirmButton' => true,
            'confirmButtonText' => 'Sim, eu tenho certeza!',
            'cancelButtonText' => 'Não, cancelar!',
            'onConfirmed' => 'confirmed',
            'onDismissed' => 'cancelled'
        ]);
    }

    public function confirmed1()
    {
        Note::createSystemNotification(Admin::class, 'Relatório Relatório trimestral de cada turma', 'Relatório gerado com sucesso');
        $this->emit('noteAdded');
        $this->alert('success', 'Relatório gerado com sucesso ');
        $condition = ['class_id' => $this->class_id, 'trimester_id'=> $this->trimester_id, 'year'=>$this->year,'class'=>$this->class];
        if($this->trimester_id == "pauta"){
            return Excel::download(new AllpautaSubject($condition), Classroom::query()->where('id',  $this->class_id)->first()->name.'.xlsx');             
        }else{
           return Excel::download(new AllSubject($condition), Classroom::query()->where('id',  $this->class_id)->first()->name.'.xlsx'); 
        }
    }
    
    public function confirmed()
    {
        // Criar uma notificação
        Note::createSystemNotification(Admin::class, 'Relatório Relatório trimestral de cada turma', 'Relatório gerado com sucesso');
        $this->emit('noteAdded');
        $this->alert('success', 'Relatório gerado com sucesso');

        // Obter informações da turma e ano
        $classroom = Classroom::query()->where('id', $this->class_id)->first();
        $class_name = $classroom ? $classroom->name : 'Turma'; // Nome da classe (ex: "6ª Classe")
        $classe = $this->class ?? 'Classe'; // Nome da turma (ex: "Turma B")
        $ano = $this->year ?? date('Y'); // Ano (ex: "2024")

        // Capturar o trimestre selecionado
        $trimester = '';
        if ($this->trimester_id == 1) {
            $trimester = '1 Trimestre';
        } elseif ($this->trimester_id == 2) {
            $trimester = '2 Trimestre';
        } elseif ($this->trimester_id == 3) {
            $trimester = '3 Trimestre';
        } elseif ($this->trimester_id == 'pauta') {
            $trimester = 'Pauta Final';
        }

        // Condição para exportar o relatório correto
        $condition = [
            'class_id' => $this->class_id,
            'trimester_id' => $this->trimester_id,
            'year' => $this->year,
            'class' => $this->class,
        ];

        // Nome formatado do arquivo com base no que foi selecionado
        if ($this->trimester_id == 'pauta') {
            $fileName = "{$classe} Classe - {$class_name} ({$ano}).xlsx";
        } else {
            $fileName = "{$classe} Classe - {$class_name} - {$trimester} ({$ano}).xlsx";
        }

        // Verificar qual relatório gerar com base no trimestre
        if ($this->trimester_id == "pauta") {
            return Excel::download(new AllpautaSubject($condition), $fileName);
        } else {
            return Excel::download(new AllSubject($condition), $fileName);
        }
    }



    public function cancelled()
    {
        $this->alert('error', 'Você cancelou.');
    }

    public function render()
    {

        return view('livewire.admin.reports.generate-combine', [
            'subjects' => Subject::query()->orderBy('name')->get(),
               'classes' => Classroom::query()->where(function ($query) {
                $query->orWhere('class', $this->class);
            })->get(),
        ]);
    }

}
