<?php

namespace App\Http\Livewire\Admin\Teachers;

use App\Models\Admin;
use App\Models\Classroom;
use App\Models\Subject;
use App\Models\TeacherSubject;
use Livewire\Component;
use Livewire\WithPagination;

class ViewTeacherAssignments extends Component
{
    use WithPagination;
    protected $paginationTheme = 'bootstrap';

    public $searchProfessor = '';
    public $searchSubject = '';
    public $searchClass = '';

    public function updating($property)
    {
        if (in_array($property, ['searchProfessor', 'searchSubject', 'searchClass'])) {
            $this->resetPage();
        }
    }

    public function removeAssignment($teacher_id, $classroom_id, $subject_id, $class)
    {
        $deleted = TeacherSubject::where('teacher_id', $teacher_id)
            ->where('classroom_id', $classroom_id)
            ->where('subject_id', $subject_id)
            ->where('class', $class)
            ->delete();

        if ($deleted) {
            session()->flash('success', 'Atribuição removida com sucesso.');
        } else {
            session()->flash('error', 'Erro ao remover atribuição.');
        }
    }

    public function render()
    {
        $assignedSubjects = TeacherSubject::with(['teacher', 'subject', 'classroom'])
            ->when($this->searchProfessor, fn($q) =>
                $q->whereHas('teacher', fn($q2) =>
                    $q2->where('name', 'like', '%' . $this->searchProfessor . '%')
                )
            )
            ->when($this->searchSubject, fn($q) =>
                $q->whereHas('subject', fn($q2) =>
                    $q2->where('name', 'like', '%' . $this->searchSubject . '%')
                )
            )
            ->when($this->searchClass, fn($q) =>
                $q->where('class', $this->searchClass)
            )
            ->orderBy('class')
            ->paginate(10);

        return view('livewire.admin.teachers.view-teacher-assignments', [
            'assignedSubjects' => $assignedSubjects,
        ]);
    }
}
