<?php
$class_id = '';
$mfd_count = 0;
$get_class = '';
$subjects_get = [];


// Inicializa variáveis para Português e Matemática
$portugues_final = null;
$matematica_final = null;

// Otimização da consulta para evitar duplicidade
foreach ($models as $model) {
    $classroom = \App\Models\Classroom::find($model->classroom_id);
    if ($classroom) {
        $get_class = $classroom->class ?? 0;
        $query_subjects = \App\Models\TeacherSubject::where('classroom_id', $model->classroom_id)->get();

        foreach ($query_subjects as $subject_relation) {
            $subject = \App\Models\Subject::find($subject_relation->subject_id);
            if ($subject) {
                $subjects_get[$subject->name] = $subject->id;
            }
        }
    }
    $class_id = $get_class;
    if ($get_class != 0) {
        break;
    }
}

$ne_subjects3 = ['Português', 'Matemática'];
$ne_subjects6 = ['Português', 'Matemática', 'História', 'Geografia', 'Física', 'Química', 'Biologia', 'Ciências naturais', 'Ciências sociais', 'Filosofia'];
$ne_subjects = ['Português', 'Matemática', 'Inglês', 'História', 'Geografia', 'Física', 'Química', 'Biologia', 'Ciências naturais', 'Ciências sociais', 'Filosofia'];
$subjects = $subjects_get;
$divide = count($subjects);


// Determina o conjunto de disciplinas baseado na classe
$current_ne_subjects = [];
if ($class_id == 3) {
    $current_ne_subjects = $ne_subjects3;
} elseif ($class_id == 6) {
    $current_ne_subjects = $ne_subjects6;
} elseif (in_array($class_id, [10, 12])) {
    $current_ne_subjects = $ne_subjects;
}

/**
 * Função para calcular a média final (MFD)
 */
function calculateMFD($nf1, $nf2, $nf3)
{
    return round(($nf1 + $nf2 + $nf3) / 3, 2);
}

/**
 * Função para calcular o MF para disciplinas com NE
 */
function calculateMFWithNE($mfd, $ne)
{
    return round(($mfd * 2 + $ne) / 3, 2);
}

/**
 * Função para calcular médias por trimestre
 */
function calculateAverage($trimesterData)
{
    $validData = array_filter($trimesterData, fn($value) => $value !== null);
    $sum = array_sum($validData);
    $count = count($validData);
    return $count > 0 ? round($sum / $count, 2) : 0;
}

/**
 * Função para obter os valores de um trimestre
 */
function getTrimesterValues($student_id, $classroom_id, $subject_id, $trimester_id)
{
    $exam = \App\Models\Exam::where([
        ['trimester_id', $trimester_id],
        ['classroom_id', $classroom_id],
        ['subject_id', $subject_id],
        ['student_id', $student_id],
    ])->first();

    return [
        (float) ($exam->ACS1a ?? 0),
        (float) ($exam->ACS2a ?? 0),
        (float) ($exam->AT ?? 0),
        (float) ($exam->NE ?? 0),
    ];
}
?>
<div>
    <div class="page-content">
        <div class="main-wrapper">
            <div class="row">
                <div class="col">
                    <div class="card">
                        <div class="card-body" wire:poll.keep-alive>
                            <h5 class="card-title">Notas do estudante</h5>
                            <div class="row">
                                <div class="col-md-12"></div>
                            </div>
                            <div class="row">
                                <div class="col-md-12">
                                    <div class="table-responsive" wire:init="loadData">
                                        <table class="table table-hover">
                                            <thead>
                                                <tr>
                                                    <th colspan="4"></th>
                                                    <?php foreach ($subjects as $key => $value): ?>
                                                        <?php if ($class_id == 3): ?>
                                                            <!-- 3ª classe: Adiciona AF -->
                                                            <th colspan="<?= in_array($key, $current_ne_subjects) ? 6 : 4 ?>" style="border: 1px solid #000; text-align: center;                width: 50px; padding: 10px;">
                                                                <?= $key ?>
                                                            </th>
                                                        <?php elseif ($class_id == 6): ?>
                                                            <!-- 6ª classe: Adiciona NE -->
                                                            <th colspan="<?= in_array($key, $current_ne_subjects) ? 6 : 4 ?>" style="border: 1px solid #000; text-align: center;                width: 50px; padding: 10px;">
                                                                <?= $key ?>
                                                            </th>
                                                        <?php elseif (in_array($class_id, [10, 12])): ?>
                                                            <!-- 10ª e 12ª classe: Adiciona NE -->
                                                            <th colspan="<?= in_array($key, $current_ne_subjects) ? 6 : 4 ?>" style="border: 1px solid #000; text-align: center;                width: 50px; padding: 10px;">
                                                                <?= $key ?>
                                                            </th>
                                                        <?php else: ?>
                                                            <!-- Outras classes -->
                                                            <th colspan="4" style="border: 1px solid #000; text-align: center; width: 50px; padding: 10px;">
                                                                <?= $key ?>
                                                            </th>
                                                        <?php endif; ?>
                                                    <?php endforeach; ?>
                                                </tr>
                                                <tr>
                                                    <th style="background-color: #2596be; color: white; padding: 10px;">#</th>
                                                    <th style="background-color: #2596be; color: white; padding: 10px;">Nome Completo</th>
                                                    <th style="background-color: #2596be; color: white; padding: 10px;">ID do Estudante</th>
                                                    <th style="background-color: #2596be; color: white; padding: 10px;">Sexo</th>
                                                    <?php foreach ($subjects as $key => $value): ?>
                                                        <th style="background-color: #2596be; color: white; text-align: center; padding: 10px;">1°</th>
                                                        <th style="background-color: #2596be; color: white; text-align: center; padding: 10px;">2°</th>
                                                        <th style="background-color: #2596be; color: white; text-align: center; padding: 10px;">3°</th>
                                                        <th style="background-color: #2596be; color: white; text-align: center; padding: 10px;">NF</th>
                                                        <?php if ($class_id == 3 && in_array($key, $current_ne_subjects)): ?>
                                                            <!-- 3ª classe: Adiciona AF -->
                                                            <th style="background-color: #2596be; color: white; text-align: center; padding: 10px;">AF</th>
                                                            <th style="background-color: #2596be; color: white; text-align: center; padding: 10px;">MFD</th>
                                                        <?php elseif (($class_id == 6 || in_array($class_id, [10, 12])) && in_array($key, $current_ne_subjects)): ?>
                                                            <!-- 6ª, 10ª, 12ª classe: Adiciona NE -->
                                                            <th style="background-color: #2596be; color: white; text-align: center; padding: 10px;">NE</th>
                                                            <th style="background-color: #2596be; color: white; text-align: center; padding: 10px;">MFD</th>
                                                        <?php endif; ?>
                                                    <?php endforeach; ?>
                                                    <th style="background-color: #2596be; color: white; text-align: center; padding: 10px;">MF</th>
                                                    <th style="background-color: #2596be; color: white; text-align: center; padding: 10px;">RESULTADO</th>
                                                </tr>
                                            </thead>
                                        <tbody>
                                            @php($count = 1)
                                            @foreach ($models as $model)
                                                <tr>
                                                    <th scope="row">{{ $count++ }}</th>
                                                    <td>{{ $model->student->name }}</td>
                                                    <td>{{ $model->student->student_id }}</td>
                                                    <td>{{ $model->student->sex }}</td>
        
                                                    <?php
                                                    $mfd_count = 0;
        
                                                    foreach ($subjects as $key => $value) {
                                                        $trim1 = getTrimesterValues($model->student_id, $model->classroom_id, $value, 1);
                                                        $trim2 = getTrimesterValues($model->student_id, $model->classroom_id, $value, 2);
                                                        $trim3 = getTrimesterValues($model->student_id, $model->classroom_id, $value, 3);

                                                        $nf1 = round(array_sum(array_slice($trim1, 0, 3)) / 3); // Média do 1º trimestre
                                                        $nf2 = round(array_sum(array_slice($trim2, 0, 3)) / 3); // Média do 2º trimestre
                                                        $nf3 = round(array_sum(array_slice($trim3, 0, 3)) / 3); // Média do 3º trimestre
                                                        $mfd = round(($nf1 + $nf2 + $nf3) / 3); // MFD padrão
                                                        $ne = $trim3[3]; // Nota de exame (NE ou AF)

                                                        // Ajusta MF com base nas disciplinas e classes
                                                        if (($class_id == 3 && in_array($key, $ne_subjects3)) ||
                                                            ($class_id == 6 && in_array($key, $ne_subjects6)) ||
                                                            (in_array($class_id, [10, 12]) && in_array($key, $ne_subjects))) {
                                                            $final = round(($mfd * 2 + $ne) / 3);
                                                        } else {
                                                            $final = $mfd;
                                                        }

                                                        // Aqui você verifica se a disciplina é Português ou Matemática e armazena a nota final
                                                        if ($key === "Português") {
                                                            $portugues_final = $final;
                                                        }
                                                        if ($key === "Matemática") {
                                                            $matematica_final = $final;
                                                        }

                                                        $mfd_count += $final;
                                                        ?>
                                                        <td style="text-align: center; padding: 10px;"><?= $nf1 ?></td>
                                                        <td style="text-align: center; padding: 10px;"><?= $nf2 ?></td>
                                                        <td style="text-align: center; padding: 10px;"><?= $nf3 ?></td>
                                                        <td style="text-align: center; padding: 10px;"><?= $mfd ?></td>
                                                        <?php if ($class_id == 3 && in_array($key, $ne_subjects3)): ?>
                                                            <td style="text-align: center; padding: 10px;"><?= $ne ?></td>
                                                            <td style="text-align: center; padding: 10px;"><?= $final ?></td>
                                                            <?php elseif (($class_id == 6 || in_array($class_id, [10, 12])) && in_array($key, $current_ne_subjects)): ?>
                                                            <td style="text-align: center; padding: 10px;"><?= $ne ?></td>
                                                            <td style="text-align: center; padding: 10px;"><?= $final ?></td>
                                                            <?php endif; ?>
                                                        <?php } // fim do foreach subjects ?>

                                                    <!-- Depois que o loop acaba, as variáveis $portugues_final e $matematica_final já devem ter sido definidas -->
                                                    <td style="text-align: center; padding: 10px;">
                                                        {{ round($mfd_count / $divide) }}
                                                    </td>
                                                    <td style="text-align: center; padding: 10px;">
                                                        <?php
                                                        $media_final = round($mfd_count / $divide);
                                                        // Agora $portugues_final e $matematica_final não são mais null
                                                        $portugues_negativa = $portugues_final !== null && $portugues_final < 10;
                                                        $matematica_negativa = $matematica_final !== null && $matematica_final < 10;
                                                        
                                                        if ($portugues_negativa && $matematica_negativa) {
                                                            echo $get_class == 3
                                                                ? 'REPROVADO'
                                                                : ($get_class == 6 || $get_class == 10 || $get_class == 12 ? 'REPROVADO' : 'NÃO TRANSITA');
                                                        } else {
                                                            echo $media_final > 9
                                                                ? ($get_class == 3
                                                                    ? 'APROVADO'
                                                                    : ($get_class == 6 || $get_class == 10 || $get_class == 12 ? 'APROVADO' : 'TRANSITA'))
                                                                : ($get_class == 3
                                                                    ? 'REPROVADO'
                                                                    : ($get_class == 6 || $get_class == 10 || $get_class == 12 ? 'REPROVADO' : 'NÃO TRANSITA'));
                                                            }
                                                            ?>
                                                            </td>


                                                </tr>
                                            @endforeach
                                        </tbody>
                                        </table>
                                    </div>
                                </div>
                            </div>
                        </div>
                    </div>
                </div>
            </div>
        </div>
    </div>
</div>

