<?php
$class_id = "";
$mfd_count = 0;
$get_class = "";
$subjects_get = array();
$has_ne_column = false; // Flag para controlar a exibição da coluna NE

// Determinando a classe do estudante e as disciplinas
foreach ($models as $model) {
    $get_class = \App\Models\Classroom::query()->where("id", $model->classroom_id)->first()->class ?? 0;

    $query_subjects = \App\Models\TeacherSubject::query()->where("classroom_id", $model->classroom_id)->get();
    foreach ($query_subjects as $subjectss) {
        $get_subject = \App\Models\Subject::query()->where("id", $subjectss->subject_id)->get();
        foreach ($get_subject as $subjectss) {
            $subjects_get += [$subjectss->name => $subjectss->id];
        }
    }
    $class_id = $get_class;
    if ($get_class != 0) {
        break;
    }
}

// Definindo os arrays de disciplinas para cada classe
$ne_subjects3 = ["Português", "Matemática"];
$ne_subjects6 = ["Português", "Matemática", "História", "Geografia", "Física", "Química", "Biologia", "Ciências naturais", "Ciências sociais", "Filosofia"];
$ne_subjects = ["Português", "Matemática", "Inglês", "História", "Geografia", "Física", "Química", "Biologia", "Ciências naturais", "Ciências sociais", "Filosofia"];

$subjects = $subjects_get;
$divide = count($subjects);

// Determinar se a coluna NE será exibida
foreach ($models as $model) {
    $subject_name = $model->subject->name ?? '';
    if (
        ($class_id == 3 && in_array($subject_name, $ne_subjects3)) ||
        ($class_id == 6 && in_array($subject_name, $ne_subjects6)) ||
        (($class_id == 10 || $class_id == 12) && in_array($subject_name, $ne_subjects))
    ) {
        $has_ne_column = true;
        break; // Encontrou pelo menos uma disciplina com NE, não precisa continuar
    }
}
?>

<div>
    <div class="page-content">
        <div class="main-wrapper">
            <div class="row">
                <div class="col">
                    <div class="card">
                        <div class="card-body" wire:poll.keep-alive>
                            <h5 class="card-title"> Notas do estudante</h5>
                            <div class="row">
                                <div class="col-md-12">
                                    {{-- <img src="{{ asset('assets/images/logo.png') }}" alt="" style="width:80px; height:50px;"> --}}
                                </div>
                            </div>
                            <div class="row">
                                <div class="col-md-12">
                                    <div class="table-responsive" wire:init="loadData">
                                        <table class="table table-hover" style="border-collapse: collapse; width: 100%;">
                                            <thead>
                                                <tr>
                                                    <th style="border: 1px solid #000; font-weight: bold; font-size:10px; background-color: #2596be; color: #FFFFFF;">#</th>
                                                    <th style="border: 1px solid #000; font-weight: bold; font-size:10px; background-color: #2596be; color: #FFFFFF;">Disciplina</th>
                                                    <th style="border: 1px solid #000; font-weight: bold; font-size:10px; background-color: #2596be; color: #FFFFFF;">Nome</th>
                                                    <th style="border: 1px solid #000; font-weight: bold; font-size:10px; background-color: #2596be; color: #FFFFFF;">ID do Estudante</th>
                                                    <th style="border: 1px solid #000; font-weight: bold; font-size:10px; background-color: #2596be; color: #FFFFFF;">Sexo</th>
                                                    <th style="border: 1px solid #000; font-weight: bold; font-size:10px; background-color: #2596be; color: #FFFFFF;">ACS1</th>
                                                    <th style="border: 1px solid #000; font-weight: bold; font-size:10px; background-color: #2596be; color: #FFFFFF;">ASC2</th>
                                                    <th style="border: 1px solid #000; font-weight: bold; font-size:10px; background-color: #2596be; color: #FFFFFF;">MACS</th>
                                                    <th style="border: 1px solid #000; font-weight: bold; font-size:10px; background-color: #2596be; color: #FFFFFF;">AT</th>
                                                    <th style="border: 1px solid #000; font-weight: bold; font-size:10px; background-color: #2596be; color: #FFFFFF;">MT</th>
                                                    @if($has_ne_column)
                                                        <th style="border: 1px solid #000; font-weight: bold; font-size:10px; background-color: #2596be; color: #FFFFFF;">
                                                            @if($class_id == 3) AF @else NE @endif
                                                        </th>
                                                    @endif
                                                </tr>
                                            </thead>
                                            <tbody>
                                                @php($count = 1)
                                                @foreach ($models as $model)
                                                    <tr>
                                                        <th style="border: 1px solid #000;" scope="row">{{ $count++ }}</th>
                                                        <td style="border: 1px solid #000;">{{ $model->subject->name }}</td>
                                                        <td style="border: 1px solid #000;">{{ $model->student->name }}</td>
                                                        <td style="border: 1px solid #000;">{{ $model->student->student_id }}</td>
                                                        <td style="border: 1px solid #000;">{{ $model->student->sex }}</td>
                                                        <td style="border: 1px solid #000;">{{ number_format($model->ACS1a, 2) }}</td>
                                                        <td style="border: 1px solid #000;">{{ number_format($model->ACS2a, 2) }}</td>
                                                        <td style="border: 1px solid #000;">{{ number_format(($model->ACS2a + $model->ACS1a) * 0.5, 2) }}</td>
                                                        <td style="border: 1px solid #000;">{{ number_format($model->AT, 2) }}</td>
                                                        <td style="border: 1px solid #000;">{{ round((($model->ACS2a + $model->ACS1a) + $model->AT) / 3) }}</td>
                                                        @if($has_ne_column)
                                                            @if(
                                                                ($class_id == 3 && in_array($model->subject->name, $ne_subjects3)) ||
                                                                ($class_id == 6 && in_array($model->subject->name, $ne_subjects6)) ||
                                                                (($class_id == 10 || $class_id == 12) && in_array($model->subject->name, $ne_subjects))
                                                            )
                                                                <td style="border: 1px solid #000;">{{ $model->trimester_id == 3 ? number_format($model->NE, 2) : '' }}</td>
                                                            @else
                                                                <td style="border: 1px solid #000; background-color: #000; color: #fff;">N/A</td> <!-- Preto para inválido -->
                                                            @endif
                                                        @endif
                                                    </tr>
                                                @endforeach
                                            </tbody>
                                        </table>
                                    </div>
                                </div>
                            </div>
                        </div>
                    </div>
                </div>
            </div>
        </div>
    </div>
</div>

