<div>
    <div class="page-content">
        <div class="main-wrapper">
            <div class="row">
                <div class="col">
                    <div class="card">
                        <div class="card-body" wire:init="loadData">
                            <h5 class="card-title">Lista de Staff</h5>
                            <div class="row">
                                <div class="col-md-12">
                                    <input type="search" wire:model="search" placeholder="Pesquisar..."
                                           class="form-control">
                                </div>
                            </div>
                            <div class="table-responsive" wire:init="loadData">
                                @if(count($users))
                                    <table class="table table-hover">
                                        <thead>
                                        <tr>
                                            <th scope="col">#</th>
                                            <th scope="col">Nome completo</th>
                                            <th scope="col">Email</th>
                                            <th scope="col">Número celular</th>
                                              <th scope="col">Editar</th>
                                            <th scope="col">Função</th>
                                            <th scope="col">Estado</th>
                                        </tr>
                                        </thead>
                                        <tbody>
                                        @php($count = 1)
                                        @foreach($users as $user)
                                            <tr>
                                                <th scope="row">{{ $count++ }}</th>
                                                <td>{{ $user->name }}</td>
                                                <td>{{ $user->email }}</td>
                                                <td>{{ $user->phone_number }}</td>
                                                <td><a href="{{route('admin.edit.admin',$user->slug)}}"
                                                       class="btn btn-outline-primary"><span
                                                            class="fa fa-edit"></span></a>
                                                </td>
                                                    <td>
                                                    @if ($user->role==2)
                                                            <span class="badge bg-info">Professor</span>
                                                     @elseif ($user->role==3)
                                                            <span class="badge bg-info">Reg. Academico</span>
                                                    @elseif ($user->role==1)
                                                            <span class="badge bg-info">Contabilidade</span>
                                                     @elseif ($user->role==0)
                                                            <span class="badge bg-info">Admin</span>
                                                    @endif
                                                    </td>
                                                <td>
                                                    @if($user->is_active)
                                                        <span class="badge bg-success">Activo</span>
                                                    @else
                                                        <span class="badge bg-danger">Suspendido</span>
                                                    @endif
                                                </td>
                                            </tr>
                                              
                                        @endforeach
                                        </tbody>
                                    </table>
                                    <div class="row float-end">
                                        {{ $users->links() }}
                                    </div>
                                @else
                                    <br>
                                    <br>
                                    <div  class="d-flex justify-content-center">
                                        <div wire:loading class="spinner-border text-primary" role="status">
                                            <span class="sr-only">Processando...</span>
                                        </div>
                                    </div>
                                    <p class="text-center"><B>Nenhum dado foi encontrado no momento.</B></p>
                                @endif
                            </div>
                        </div>
                    </div>
                </div>
            </div>
        </div>

    </div>
</div>
