<div>
    <div class="page-content">
        <div class="main-wrapper">
            <div class="row">
                <div class="col">
                    <div class="card">
                        <div class="card-body">
                            <h5 class="card-title">
                                Editar nota do estudante: {{ $model->student->name }}
                                Trimestre: {{ $this->model->trimester_id }}
                            </h5>
                            <form class="row g-3" wire:submit.prevent="submit">
                                <div class="col-md-6">
                                    <label for="class" class="form-label">
                                        <b>Classe</b>: {{ $model->class->name }}
                                    </label>
                                </div>
                                <div class="col-md-6">
                                    <label for="subject" class="form-label">
                                        <b>Disciplina</b>: {{ $model->subject->name }}
                                    </label>
                                </div>
                                <div class="col-md-6">
                                    <label for="ACS1a" class="form-label">ACS1</label>
                                    <input type="text"
                                           class="form-control @error('ACS1a') is-invalid @enderror"
                                           id="ACS1a" required placeholder="Insira ACS1..."
                                           wire:model="ACS1a">
                                    @error('ACS1a')
                                    <span class="invalid-feedback" role="alert">
                                        <strong>{{ $message }}</strong>
                                    </span>
                                    @enderror
                                </div>
                                <div class="col-md-6">
                                    <label for="ACS2a" class="form-label">ACS2</label>
                                    <input type="text"
                                           class="form-control @error('ACS2a') is-invalid @enderror"
                                           id="ACS2a" required placeholder="Insira ACS2..."
                                           wire:model="ACS2a">
                                    @error('ACS2a')
                                    <span class="invalid-feedback" role="alert">
                                        <strong>{{ $message }}</strong>
                                    </span>
                                    @enderror
                                </div>
                                <div class="col-md-6">
                                    <label for="AT" class="form-label">AT</label>
                                    <input type="text"
                                           class="form-control @error('AT') is-invalid @enderror"
                                           id="AT" required placeholder="Insira AT..."
                                           wire:model="AT">
                                    @error('AT')
                                    <span class="invalid-feedback" role="alert">
                                        <strong>{{ $message }}</strong>
                                    </span>
                                    @enderror
                                </div>

                                @if ($model->trimester_id == 3) <!-- Verifica se é o terceiro trimestre -->
                                    @if (in_array($model->class->id, [6, 10, 12])) <!-- Verifica se a classe é 6, 10 ou 12 -->
                                        <div class="col-md-6">
                                            <label for="NE" class="form-label">Nota de Exame (NE)</label>
                                            <input type="text"
                                                class="form-control @error('NE') is-invalid @enderror"
                                                id="NE" required placeholder="Insira NE..."
                                                wire:model="NE">
                                            @error('NE')
                                            <span class="invalid-feedback" role="alert">
                                                <strong>{{ $message }}</strong>
                                            </span>
                                            @enderror
                                        </div>
                                    @elseif ($model->class->id == 3) <!-- Verifica se a classe é 3 -->
                                        <div class="col-md-6">
                                            <label for="AF" class="form-label">Avaliação Final (AF)</label>
                                            <input type="text"
                                                class="form-control @error('AF') is-invalid @enderror"
                                                id="AF" required placeholder="Insira AF..."
                                                wire:model="AF">
                                            @error('AF')
                                            <span class="invalid-feedback" role="alert">
                                                <strong>{{ $message }}</strong>
                                            </span>
                                            @enderror
                                        </div>
                                    @endif
                                @endif



                                <div class="col-12">
                                    <button type="submit" class="btn btn-primary btn-lg float-end"
                                            wire:loading.class="disabled"
                                            wire:offline.attr="disabled">
                                        <span wire:target="submit"
                                              wire:loading.class="spinner-border spinner-border-lg"></span>
                                        Guardar
                                    </button>
                                </div>
                            </form>
                        </div>
                    </div>
                </div>
            </div>
        </div>
    </div>
</div>
