<div>
    <div class="page-content">
        <div class="main-wrapper">
            <div class="row">
                <div class="col">
                    <div class="card">
                        <div class="card-body" wire:init="loadData">
                            <h5 class="card-title"> Lista de Classes</h5>
                            <div class="row">
                                <div class="col-md-12">
                                    <input type="search" wire:model="search" placeholder="Pesquisar..."
                                           class="form-control">
                                </div>
                            </div>
                            <div class="table-responsive" wire:init="loadData">
                                @if(count($models))
                                    <table class="table table-hover">
                                        <thead>
                                        <tr>
                                            <th scope="col">#</th>
                                            <th scope="col">Turma</th>
                                            <th scope="col">Classe</th>
                                            <th scope="col">Descrição</th>
                                            <th scope="col">Mostrar estudantes</th>
                                            <th scope="col">Data/Hora</th>
                                        </tr>
                                        </thead>
                                        <tbody>
                                        @php($count = 1)
                                        @foreach($models as $model)
                                            <tr>
                                                <th scope="row">{{ $count++ }}</th>
                                                <td>{{ $model->name }}</td>
                                                <td>{{ $model->class }} Classe</td>
                                                <td>{!! $model->description!!}</td>
                                                <td>
                                                    @if ($user->role==3)
                                                    <a href="{{ route('admin.list.class.students.academic', $model->slug) }}"
                                                        class="btn btn-outline-primary"><span
                                                             class="fa fa-eye"> Mostrar estudantes - {{ $model->students->count() }}</span></a>
                                                        @else
                                                    <a href="{{ route('admin.list.class.students.teacher', $model->slug) }}"
                                                       class="btn btn-outline-primary"><span
                                                            class="fa fa-eye"> Mostrar estudantes - {{ $model->students->count() }}</span></a>
                                                    @endif
                                                </td>
                                                <td>{{ date('F d, Y h:i a', strtotime($model->created_at)) }}</td>
                                            </tr>
                                        @endforeach
                                        </tbody>
                                    </table>
                                    <div class="row float-end">
                                        {{ $models->links() }}
                                    </div>
                                @else
                                    <br>
                                    <br>
                                    <div  class="d-flex justify-content-center">
                                        <div wire:loading class="spinner-border text-primary" role="status">
                                            <span class="sr-only">Processando...</span>
                                        </div>
                                    </div>
                                    <p class="text-center"><B>Nenhum dado foi encontrado no momento.</B></p>
                                @endif
                            </div>
                        </div>
                    </div>
                </div>
            </div>
        </div>

    </div>
</div>
