<div>
    <div class="page-content">
        <div class="main-wrapper">
            <div class="card border-0 shadow">
                <div class="card-header bg-primary text-white py-3">
                    <h2 class="h5 mb-0">
                        <i class="fas fa-percentage me-2"></i>
                        Gestão de Descontos nas Taxas
                    </h2>
                </div>

                <div class="card-body">
                    <div class="row g-4">
                        <!-- Coluna Esquerda: Formulário -->
                        <div class="col-md-6">
                            <div class="card border-0 shadow-sm h-100">
                                <div class="card-header bg-light">
                                    <h3 class="h6 mb-0">
                                        <i class="fas fa-plus-circle me-2"></i>
                                        Adicionar Desconto nas Taxas
                                    </h3>
                                </div>

                                <div class="card-body">
                                    <form wire:submit.prevent="save" class="needs-validation" novalidate>
                                        <!-- Nome -->
                                        <div class="form-group mb-3">
                                            <label for="name" class="form-label fw-semibold">Nome <span class="text-danger">*</span></label>
                                            <div class="input-group">
                                                <span class="input-group-text bg-light"><i class="fas fa-tag"></i></span>
                                                <input type="text" id="name" wire:model="name" class="form-control" placeholder="Ex: Desconto Para Filhos de Funcionários ou Por Mérito Escolar">
                                            </div>
                                            @error('name') <span class="text-danger small">{{ $message }}</span> @enderror
                                        </div>

                                        <!-- Código -->
                                        <div class="form-group mb-3">
                                            <label for="discount_code" class="form-label fw-semibold">Código de Desconto <span class="text-danger">*</span></label>
                                            <div class="input-group">
                                                <span class="input-group-text bg-light"><i class="fas fa-barcode"></i></span>
                                                <input type="text" id="discount_code" wire:model="discount_code" class="form-control" placeholder="Ex.: FILHO10 ou MERITO10">
                                            </div>
                                            @error('discount_code') <span class="text-danger small">{{ $message }}</span> @enderror
                                        </div>

                                        <!-- Tipo -->
                                        <div class="form-group mb-3">
                                            <label class="form-label fw-semibold d-block">Tipo de Desconto <span class="text-danger">*</span></label>
                                            <div class="d-flex gap-3 align-items-center">
                                                <label class="form-check me-3">
                                                    <input type="radio" class="form-check-input me-2" wire:model="discount_type" value="percentage">
                                                    <span class="form-check-label"><i class="fas fa-percent me-1"></i> Percentagem</span>
                                                </label>
                                                <label class="form-check">
                                                    <input type="radio" class="form-check-input me-2" wire:model="discount_type" value="fix_amount">
                                                    <span class="form-check-label"><i class="fas fa-money-bill-wave me-1"></i> Valor Fixo</span>
                                                </label>
                                            </div>
                                            @error('discount_type') <span class="text-danger small">{{ $message }}</span> @enderror
                                        </div>

                                        <!-- Percentagem -->
                                        <div class="form-group mb-3" wire:ignore.self>
                                            <label for="percentage" class="form-label fw-semibold">Percentagem (%) <span class="text-danger">*</span></label>
                                            <div class="input-group">
                                                <span class="input-group-text bg-light">%</span>
                                                <input type="number" id="percentage" wire:model="percentage" class="form-control" step="0.01" min="0" max="100" placeholder="Ex: 10">
                                            </div>
                                            @error('percentage') <span class="text-danger small">{{ $message }}</span> @enderror
                                        </div>

                                        <!-- Valor -->
                                        <div class="form-group mb-3" wire:ignore.self>
                                            <label for="amount" class="form-label fw-semibold">Valor (MT) <span class="text-danger">*</span></label>
                                            <div class="input-group">
                                                <span class="input-group-text bg-light"><i class="fas fa-dollar-sign"></i></span>
                                                <input type="number" id="amount" wire:model="amount" class="form-control" step="0.01" min="0" placeholder="Ex: 500">
                                            </div>
                                            @error('amount') <span class="text-danger small">{{ $message }}</span> @enderror
                                        </div>

                                        <!-- Descrição -->
                                        <div class="form-group mb-3">
                                            <label for="description" class="form-label fw-semibold">Descrição</label>
                                            <div class="input-group">
                                                <span class="input-group-text bg-light"><i class="fas fa-align-left"></i></span>
                                                <textarea id="description" wire:model="description" class="form-control" rows="2" placeholder="Observações do desconto (opcional)"></textarea>
                                            </div>
                                            @error('description') <span class="text-danger small">{{ $message }}</span> @enderror
                                        </div>

                                        <!-- Enviar para -->
                                        <div class="row g-3">
                                            <div class="col-md-12">
                                                <label class="form-label fw-semibold">Enviar para</label>
                                                <select class="form-control" wire:model="type">
                                                    <option value="student">Estudante</option>
                                                </select>
                                            </div>

                                            @if($type == "class" || $type == "student")
                                                <div class="col-md-12">
                                                    <label class="form-label fw-semibold">Turma</label>
                                                    <select class="form-control" wire:model="class_id">
                                                        <option value="">Selecione a Turma</option>
                                                        @foreach($classrooms as $class)
                                                            <option value="{{ $class->id }}">{{ $class->class }} - {{ $class->name }}</option>
                                                        @endforeach
                                                    </select>
                                                    @error('class_id')
                                                        <span class="text-danger small">{{ $message }}</span>
                                                    @enderror
                                                </div>
                                            @endif

                                            @if($type == "student")
                                                <div class="col-md-12">
                                                    <label class="form-label fw-semibold">Estudante</label>
                                                    <select class="form-control" wire:model="student_id">
                                                        <option value="">Selecione o Estudante</option>
                                                        @foreach($students as $student)
                                                            <option value="{{ $student->id }}">{{ $student->name }}</option>
                                                        @endforeach
                                                    </select>
                                                    @error('student_id')
                                                        <span class="text-danger small">{{ $message }}</span>
                                                    @enderror
                                                </div>
                                            @endif
                                        </div>

                                        <!-- Meses -->
                                        <div class="mt-3">
                                            <label class="form-label fw-semibold">Selecione os meses do desconto</label>
                                            <div class="card border-0 shadow-sm">
                                                <div class="card-body">
                                                    <div class="row">
                                                        @foreach([
                                                            'January' => 'Janeiro',
                                                            'February' => 'Fevereiro',
                                                            'March' => 'Março',
                                                            'April' => 'Abril',
                                                            'May' => 'Maio',
                                                            'June' => 'Junho',
                                                            'July' => 'Julho',
                                                            'August' => 'Agosto',
                                                            'September' => 'Setembro',
                                                            'October' => 'Outubro',
                                                            'November' => 'Novembro',
                                                            'December' => 'Dezembro'
                                                        ] as $engMonth => $ptMonth)
                                                            <div class="col-6 col-sm-4 mb-2">
                                                                <div class="form-check">
                                                                    <input class="form-check-input" type="checkbox" wire:model="months" value="{{ $engMonth }}" id="month_{{ $engMonth }}">
                                                                    <label class="form-check-label" for="month_{{ $engMonth }}">{{ $ptMonth }}</label>
                                                                </div>
                                                            </div>
                                                        @endforeach
                                                    </div>
                                                </div>
                                            </div>
                                        </div>

                                        <!-- Submit -->
                                        <div class="d-flex justify-content-end mt-3">
                                            <button type="submit" class="btn btn-primary px-4">
                                                <i class="fas fa-save me-2"></i> Guardar
                                            </button>
                                        </div>
                                    </form>
                                </div>
                            </div>
                        </div>

                        <!-- Coluna Direita: Lista -->
                        <div class="col-md-6">
                            <div class="card border-0 shadow-sm h-100">
                                <div class="card-header bg-light">
                                    <h3 class="h6 mb-0">
                                        <i class="fas fa-list me-2"></i>
                                        Lista de Descontos nas Taxas
                                    </h3>
                                </div>

                                <div class="card-body">
                                    <div class="input-group mb-3">
                                        <span class="input-group-text bg-light"><i class="fas fa-search"></i></span>
                                        <input type="text" wire:model="search" class="form-control" placeholder="Pesquisar...">
                                    </div>

                                    <div class="table-responsive">
                                        <table class="table table-hover align-middle">
                                            <thead class="table-light">
                                                <tr>
                                                    <th>Nome</th>
                                                    <th>Código</th>
                                                    <th class="text-center">Percentagem</th>
                                                    <th class="text-center">Valor</th>
                                                    <th class="text-end">Ação</th>
                                                </tr>
                                            </thead>
                                            <tbody>
                                                @forelse($feesDiscounts as $feesDiscount)
                                                    <tr>
                    <td class="fw-semibold">{{ $feesDiscount->name }}</td>
                    <td><span class="badge bg-info text-dark">{{ $feesDiscount->discount_code }}</span></td>
                    <td class="text-center">
                        @if(!is_null($feesDiscount->percentage) && $feesDiscount->percentage !== '')
                            <span class="badge bg-secondary">{{ rtrim(rtrim(number_format($feesDiscount->percentage, 2, ',', ''), '0'), ',') }}%</span>
                        @else
                            <span class="text-muted">—</span>
                        @endif
                    </td>
                    <td class="text-center">
                        @if(!is_null($feesDiscount->amount) && $feesDiscount->amount !== '')
                            <span class="badge bg-secondary">{{ number_format($feesDiscount->amount, 2, ',', ' ') }}</span>
                        @else
                            <span class="text-muted">—</span>
                        @endif
                    </td>
                    <td class="text-end">
                        <div class="btn-group">
                            <button wire:click="edit({{ $feesDiscount->id }})" class="btn btn-sm btn-outline-primary">
                                <i class="fas fa-edit"></i>
                            </button>
                            <button wire:click="delete({{ $feesDiscount->id }})" class="btn btn-sm btn-outline-danger">
                                <i class="fas fa-trash-alt"></i>
                            </button>
                        </div>
                    </td>
                </tr>
                                                @empty
                                                    <tr>
                                                        <td colspan="5" class="text-center text-muted py-4">
                                                            <i class="fas fa-info-circle me-1"></i>
                                                            Não existem dados disponíveis na tabela
                                                        </td>
                                                    </tr>
                                                @endforelse
                                            </tbody>
                                        </table>
                                    </div>

                                    @if(method_exists($feesDiscounts, 'links'))
                                        <div class="mt-2">
                                            {{ $feesDiscounts->links() }}
                                        </div>
                                    @endif
                                </div>
                            </div>
                        </div>
                        <!-- /Coluna Direita -->
                    </div>
                </div>
            </div>
        </div>
    </div>
</div>

