<div>
    <div class="page-content">
        <div class="main-wrapper">
            <div class="row">
                <div class="col">
                    <div class="card">
                        <div class="card-body">
                            <!-- Student Details -->
                            <div class="student-details">
                                <!--img src="{{ asset('path_to_image') }}" alt="Student Image"-->
                                <div class="details">
                                    <p>Nome: {{ $student->name }}</p>                                   
                                    <p>ID do Estudante: {{ $student->student_id }}</p>
                                   
                                     <!-- <button wire:click="$emit('openModal', {{ $fee }}, {{ $fee }})"  class="btn btn-primary">+</button> -->

                                    @php
                                        $currentMonth = now()->format('Y-m'); // Get the current month in 'YYYY-MM' format
                                        $existingFee = \App\Models\Fee_assign::where('student_id', $student->id)
                                            ->where('created_at', 'like', "{$currentMonth}%")
                                            ->first(); // Check if a fee entry exists for this month

                                        $auctualfee = $fee;    
                                    @endphp

                                    <!-- If there is no fee entry for this month, show the "+" button -->
                                   <!--  @if(!$existingFee)
                                        <p>Fee this month : {{ $fee }}</p>
                                        <button wire:click="$emit('openModal', {{ $fee }}, {{ $fee }})" class="btn btn-primary">Pay Fee</button>
                                   
                                    @endif -->
                                    

                                </div>
                            </div>

                            <!-- Fee Details -->
                            <div class="fee-details">
                                <table class="table table-hover">
                                    <thead>
                                        <tr>
                                            <th>Grupo de Taxas</th>
                                            <th>Codigo da Taxa</th>
                                            <th>Data de Vencimento</th>
                                            <th>Estado</th>
                                            <th>Montante</th>
                                            <th>Desconto</th>
                                            <th>Multa</th>
                                            <th>Pago</th>
                                            <th>Saldo</th>
                                            <th>Date</th>
                                            <th>Action</th>
                                        </tr>
                                    </thead>
                                    <tbody>

                                        <!-- 
                                        
                                        @foreach($fees as $fee)
                                        <tr>
                                            <td>{{ $fee->fee_name }}</td>
                                            <td>{{ $fee->fees_code }}</td>
                                            <td>{{ $fee->due_date }}</td>
                                            <td>{{ $fee->status }}</td>
                                            <td>{{ $fee->amount }}</td>
                                            <td>{{ $fee->discount }}</td>
                                            <td>{{ $fee->fine }}</td>
                                            <td>{{ $fee->status }}</td>
                                            <td>{{ $fee->amount }}</td>
                                            <td>
                                               {{ $fee->created_at }}
                                            </td>
                                        </tr>
                                        @endforeach -->






                                       @php
                                            // Get the current year
                                            $currentYear = now()->year;

                                            // Get the 12 months of the current year
                                            $months = [
                                                'January', 'February', 'March', 'April', 'May', 'June',
                                                'July', 'August', 'September', 'October', 'November', 'December'
                                            ];
                                        @endphp

                                        @foreach ($months as $index => $month)
                                            @php
                                                // Get the first day and last day of the current month
                                                $startOfMonth = Carbon\Carbon::createFromDate($currentYear, $index + 1, 1)->startOfMonth();
                                                $endOfMonth = Carbon\Carbon::createFromDate($currentYear, $index + 1, 1)->endOfMonth();

                                                // Default values
                                                $status = 'Unpaid';
                                                $amount = 0;
                                                $discount = 0;
                                                $fine = 0;
                                                $penalty = 0;
                                                $feeNames = [];

                                                // Filter the FeeStructure array to find the ones for the selected month
                                                foreach ($feestructures as $feeStructure) {
                                                    // Explode the comma-separated months from the FeeStructure's 'months' field
                                                    $monthsInFeeStructure = explode(',', $feeStructure->months);  // Assuming 'months' is a comma-separated string

                                                    // Check if the current month matches any of the months in the 'months' field
                                                    if (in_array($month, $monthsInFeeStructure)) {
                                                        // Add the monthly fee and fee name for the matched fee structure
                                                        $amount += $feeStructure->monthly_fee;
                                                        $feeNames[] = $feeStructure->fee_name; // Store the name of the applied fees


                                                         $paymentStartDate = Carbon\Carbon::createFromDate($currentYear, $index, $feeStructure->payment_start_day);
                                                            $paymentDueDate = Carbon\Carbon::createFromDate($currentYear, $index + 1, $feeStructure->payment_due_day);



                                                        // Apply late penalty if the payment is overdue
                                                         if (Carbon\Carbon::now()->gt($paymentDueDate)) {
                                                            if ($feeStructure->palenty_type == 'fixed') {
                                                                $penalty = $feeStructure->late_penalty_percentage; // Fixed penalty amount
                                                           
                                                            } elseif ($feeStructure->palenty_type == 'percentage') {
                                                                $penalty = ($amount * $feeStructure->late_penalty_percentage) / 100; // Percentage penalty
                                                            }

                                                            // Add penalty to the total amount
                                                            $amount += $penalty;
                                                        }
                                                    }
                                                }


                                                foreach($fees as $ffee){
                                                    if($month  == $ffee->month){
                                                        $status = 'Paid';
                                                        $amount = $ffee->amount;
                                                    }
                                                }

                                                // If there are matching fee structures, set status as Paid
                                                
                                            @endphp

                                            <tr>
                                                <td>{{ $month }} {{ $currentYear }}</td>
                                                <td>{{ implode(', ', $feeNames) ?? 'N/A' }}</td> <!-- Show the names of the applied fees -->
                                                <td>{{ $status }}</td>
                                                <td>{{ $amount }}</td> <!-- Total amount after penalties -->
                                                <td>{{ $discount }}</td>
                                                <td>{{ $fine + $penalty ?? 0 }}</td> <!-- Display fine and penalty together -->
                                                <td>{{ $status }}</td>
                                                <td>{{ $amount }}</td> <!-- Display final amount after penalties -->
                                                <td>{{ $status == 'Paid' ? now() : 'N/A' }}</td> <!-- If paid, show the current date -->
                                                <td>
                                                    @if ($status == 'Unpaid') <!-- If no fee entry exists for this month -->
                                                        <button wire:click="$emit('openModal', {{ $amount }},{{ $amount }}, '{{ $month }}' , {{ $currentYear }})" class="btn btn-primary">Pay Fee</button>
                                                    @else
                                                        <span>Paid</span>
                                                    @endif
                                                </td>
                                            </tr>
                                        @endforeach



                                    </tbody>
                                </table>
                            </div>


                        </div>
                    </div>
                </div>
            </div>
        </div>
</div>

    <!-- Modal -->
    <div class="modal fade" id="collectFeeModal" tabindex="-1" role="dialog" aria-labelledby="collectFeeModalLabel" aria-hidden="true" wire:ignore.self>
        <div class="modal-dialog" role="document">
            <div class="modal-content">
                <form wire:submit.prevent="collectFee">
                    <div class="modal-header">
                        <h5 class="modal-title" id="collectFeeModalLabel">Cobrar Taxa</h5>
                        <button type="button"  data-dismiss="modal" >
                            <span aria-hidden="true">&times;</span>
                        </button>
                    </div>
                    <div class="modal-body">
                        <input type="hidden" wire:model="selectedFeeAssignId">
                         <!-- Hidden Month and Year Fields -->
                        <input type="hidden" wire:model="month" id="month">
                        <input type="hidden" wire:model="year" id="year">
                        <div class="form-group">
                            <label for="amount">Montante</label>
                            <input type="number" class="form-control" id="amount" wire:model="amount" required>
                        </div>
                        <div class="form-group">
                            <label for="discount">Desconto</label>
                            <input type="number" class="form-control" id="discount" wire:model="discount">
                        </div>
                        <div class="form-group">
                            <label for="fine">Multa</label>
                            <input type="number" class="form-control" id="fine" wire:model="fine">
                        </div>
                        <div class="form-group">
                            <label for="paymentMode">Modo de Pagamento</label>
                            <select class="form-control" id="paymentMode" wire:model="paymentMode">
                                <option value="Cash">Cash</option>
                                
                            </select>
                        </div>
                        <div class="form-group">
                            <label for="note">Nota</label>
                            <textarea class="form-control" id="note" wire:model="note"></textarea>
                        </div>
                    </div>
                    <div class="modal-footer">
                        <button type="button" class="btn btn-secondary" data-dismiss="modal">Fechar</button>
                        <button type="submit" class="btn btn-primary">Efectuar Pagamento</button>
                    </div>
                </form>
            </div>
        </div>
    </div>
    
</div>
<script>
    document.addEventListener('livewire:load', function () {
        @this.on('openModal', (feeId, feeAmount, month, year) => {
            // Set the selected fee ID and amount in the Livewire component
            @this.set('selectedFeeAssignId', feeId);
            @this.set('amount', feeAmount);
              @this.set('month', month);  // Ensure the month is passed correctly as a string
        @this.set('year', year);
            // Show the modal
            $('#collectFeeModal').modal('show');
        });

        // Close modal on "Close" button click
        $('#collectFeeModal .btn-secondary').on('click', function () {
            $('#collectFeeModal').modal('hide');
        });
    });
</script>
