{{-- ---------------------- Group Channel Modal ---------------------- --}}
<div class="app-modal group-modal" data-name="addGroup">
    <div class="app-modal-container">
        <div class="app-modal-card" data-name="addGroup" data-modal='0'>
            <form id="addGroupForm"
            @if (Auth::guard('admin')->check())
           
            action="{{ url('').'/admin/chat/group-chat/create'}}"
            @else
            action="{{ url('').'/chat/group-chat/create'}}"
            @endif
             enctype="multipart/form-data" method="POST">
                @csrf
                <div class="app-modal-header">
                    Criar chat em grupo
                </div>
                <div class="app-modal-body">
                    {{-- channel avatar --}}
                    <div class="avatar av-l upload-avatar-preview chatify-d-flex"
                         style="background-image: url('{{ Chatify::getUserWithAvatar(Auth::user())->avatar }}');"
                    ></div>
                    <p class="upload-avatar-details"></p>
                    <label class="app-btn a-btn-primary update" style="background-color:{{$messengerColor}}">
                        Carregar imagem
                        <input class="upload-avatar chatify-d-none" accept="image/*" name="avatar" type="file" />
                    </label>
                    {{-- End channel avatar --}}

                    <div class="form-control">
                        <label class="form-label" for="group_name">Nome do grupo</label>
                        <input class="form-input" type="text" name="group_name" id="group_name"
                               placeholder="Escreva o nome"
                               required="required"
                        />
                    </div>
                    <div class="form-control">
                        <select class="form-input class-search" id="class" wire:model="class" type="text">
                            <option value="">Selecione a classe</option>
                            <option value="">Qualquer</option>
                                <option value="1">1ª Classe</option>
                                <option value="2">2ª Classe</option>
                                <option value="3">3ª Classe</option>
                                <option value="4">4ª Classe</option>
                                <option value="5">5ª Classe</option>
                                <option value="6">6ª Classe</option>
                                <option value="7">7ª Classe</option>
                                <option value="8">8ª Classe</option>
                                <option value="9">9ª Classe</option>
                                <option value="10">10ª Classe</option>
                                <option value="11">11ª Classe</option>
                                <option value="12">12ª Classe</option>
                            </select>
    
                    </div>

                    <div class="form-control">
                        <select class="form-input turmas-search" id="turma"  type="text">
                            <option value="">Selecione a Turma </option>
                            
                            </select>
    
                    </div>
                   
                    <div class="form-control">
                        <label class="form-label" for="search">Selecione o(s) usuário(s) para o grupo</label>
                        <input class="form-input user-search" type="text" name="search" placeholder="Pesquisar"/>
                    </div>
                    <div class="search-records app-scroll users-list"></div>
                    <div style="margin-top: 1rem; margin-bottom: 2rem">
                        <label class="form-label">Usuários adicionados</label>
                        <div class="added-users app-scroll users-list"></div>
                    </div>
                </div>
                <div class="app-modal-footer">
                    <a href="javascript:void(0)" class="app-btn cancel">Cancelar</a>
                    <input type="submit" class="app-btn a-btn-success update" value="Criar grupo" />
                </div>
            </form>
        </div>
    </div>
</div>

{{-- ---------------------- Delete Group Chat Modal ---------------------- --}}
<div class="app-modal" data-name="delete-group">
    <div class="app-modal-container">
          <div class="app-modal-card" data-name="delete-group" data-modal='0'>
            <div class="app-modal-header">Tem certeza de que deseja excluir esse grupo?</div>
            <div class="app-modal-body">Não é possível desfazer essa ação</div>
            <div class="app-modal-footer">
                <a href="javascript:void(0)" class="app-btn cancel">Cancelar</a>
                <a href="javascript:void(0)" class="app-btn a-btn-danger delete">Deletar</a>
            </div>
        </div>
    </div>
</div>

{{-- ---------------------- Leave Group Chat Modal ---------------------- --}}
<div class="app-modal" data-name="leave-group">
    <div class="app-modal-container">
          <div class="app-modal-card" data-name="leave-group" data-modal='0'>
            <div class="app-modal-header">Tem certeza de que deseja deixar este grupo?</div>
            <div class="app-modal-body">Não é possível desfazer essa ação</div>
            <div class="app-modal-footer">
                <a href="javascript:void(0)" class="app-btn cancel">Cancelar</a>
                <a href="javascript:void(0)" class="app-btn a-btn-danger delete">Sair</a>
            </div>
        </div>
    </div>
</div>

{{-- ---------------------- Image modal box ---------------------- --}}
<div id="imageModalBox" class="imageModal">
    <span class="imageModal-close">&times;</span>
    <img class="imageModal-content" id="imageModalBoxSrc">
  </div>

  {{-- ---------------------- Delete Modal ---------------------- --}}
  <div class="app-modal" data-name="delete">
      <div class="app-modal-container">
          <div class="app-modal-card" data-name="delete" data-modal='0'>
              <div class="app-modal-header">Tem certeza de que deseja apagar?</div>
              <div class="app-modal-body">Você não pode desfazer esta acção</div>
              <div class="app-modal-footer">
                  <a href="javascript:void(0)" class="app-btn cancel">Cancelar</a>
                  <a href="javascript:void(0)" class="app-btn a-btn-danger delete">Deletar</a>
              </div>
          </div>
      </div>
  </div>
  {{-- ---------------------- Alert Modal ---------------------- --}}
  <div class="app-modal" data-name="alert">
      <div class="app-modal-container">
          <div class="app-modal-card" data-name="alert" data-modal='0'>
              <div class="app-modal-header"></div>
              <div class="app-modal-body"></div>
              <div class="app-modal-footer">
                  <a href="javascript:void(0)" class="app-btn cancel">Cancelar</a>
              </div>
          </div>
      </div>
  </div>
  {{-- ---------------------- Settings Modal ---------------------- --}}
  <div class="app-modal" data-name="settings">
      <div class="app-modal-container">
          <div class="app-modal-card" data-name="settings" data-modal='0'>
              <form id="update-settings" action="updateSettings" enctype="multipart/form-data" method="POST">
                  @csrf
                  {{-- <div class="app-modal-header">Atualizar as configurações do seu perfil</div> --}}
                  <div class="app-modal-body">
                      {{-- Udate profile avatar --}}
                      <div class="avatar av-l upload-avatar-preview chatify-d-flex"
                      style="background-image: url('{{ Chatify::getUserWithAvatar(Auth::user())->avatar }}');"
                      ></div>
                      <p class="upload-avatar-details"></p>
                      <label class="app-btn a-btn-primary update" style="background-color:{{$messengerColor}}">
                          Carregar nova foto
                          <input class="upload-avatar chatify-d-none" accept="image/*" name="avatar" type="file" />
                      </label>
                      {{-- Dark/Light Mode  --}}
                      <p class="divider"></p>
                      <p class="app-modal-header">Modo Escuro <span class="
                        {{ Auth::user()->dark_mode > 0 ? 'fas' : 'far' }} fa-moon dark-mode-switch"
                         data-mode="{{ Auth::user()->dark_mode > 0 ? 1 : 0 }}"></span></p>
                      {{-- change messenger color  --}}
                      <p class="divider"></p>
                      {{-- <p class="app-modal-header">Mudar {{ config('chatify.name') }} cor</p> --}}
                      <div class="update-messengerColor">
                      @foreach (config('chatify.colors') as $color)
                        <span style="background-color: {{ $color}}" data-color="{{$color}}" class="color-btn"></span>
                        @if (($loop->index + 1) % 5 == 0)
                            <br/>
                        @endif
                      @endforeach
                      </div>
                  </div>
                  <div class="app-modal-footer">
                      <a href="javascript:void(0)" class="app-btn cancel">Cancelar</a>
                      <input type="submit" class="app-btn a-btn-success update" value="Guardar" />
                  </div>
              </form>
          </div>
      </div>
  </div>
