<div class="page-content">
    <div class="container-fluid">
        <div class="row mb-4 mt-3">
            <div class="col-12">
                <div class="d-flex justify-content-between align-items-center">
                    <div class="pt-3">
                        <h1 class="h3 mb-1 text-primary">
                            <i class="fas fa-cash-register me-2"></i>Cobrança de Taxas
                        </h1>
                        <p class="text-muted mb-0">
                            Selecione os estudantes para cobrança de taxas
                        </p>
                    </div>
                </div>
            </div>
        </div>

        <!-- Filters Card -->
        <div class="card border-0 shadow-sm mb-4">
            <div class="card-body">
                <h5 class="card-title mb-4 text-primary">
                    <i class="fas fa-filter me-2"></i>Filtros de Seleção
                </h5>
                
                <div class="row g-3">
                    <!-- Ano Acadêmico -->
                    <div class="col-md-3">
                        <label for="year" class="form-label">Ano Acadêmico</label>
                        <select class="form-select" wire:model="selectedYear">
                            <?php $__currentLoopData = $availableYears; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $year): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                                <option value="<?php echo e($year); ?>"><?php echo e($year); ?></option>
                            <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                        </select>
                    </div>
                    
                    <!-- Classe -->
                    <div class="col-md-3">
                        <label for="class" class="form-label">Classe</label>
                        <select class="form-select" wire:model="selectedClass">
                            <option value="">Todas Classes</option>
                            <?php $__currentLoopData = $classes; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $class): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                                <option value="<?php echo e($class->class); ?>"><?php echo e($class->class); ?></option>
                            <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                        </select>
                    </div>
                    
                    <!-- Turma -->
                    <?php if($selectedClass): ?>
                    <div class="col-md-3">
                        <label for="turma" class="form-label">Turma</label>
                        <select class="form-select" wire:model="selectedTurma">
                            <option value="">Todas Turmas</option>
                            <?php $__currentLoopData = $turmas; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $turma): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                                <option value="<?php echo e($turma->id); ?>"><?php echo e($turma->name); ?></option>
                            <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                        </select>
                    </div>
                    <?php endif; ?>
                    
                    <!-- Search -->
                    <div class="col-md-3">
                        <label for="search" class="form-label">Pesquisar</label>
                        <div class="input-group">
                            <input type="text" class="form-control"
                                   wire:model.debounce.300ms="searchTerm"
                                   placeholder="Nome, email ou código">
                            <span class="input-group-text">
                                <i class="fas fa-search"></i>
                            </span>
                        </div>
                    </div>
                </div>
            </div>
        </div>

        <!-- Students Card -->
        <div class="card border-0 shadow-sm">
            <div class="card-body p-0">
                <div class="d-flex justify-content-between align-items-center p-4 border-bottom">
                    <h5 class="card-title mb-0 text-primary">
                        <i class="fas fa-user-graduate me-2"></i>Lista de Estudantes
                        <span class="badge bg-primary ms-2"><?php echo e(count($students)); ?></span>
                    </h5>
                </div>

                <?php if($isLoading): ?>
                <div class="text-center py-5">
                    <div class="spinner-border text-primary" style="width: 3rem; height: 3rem;" role="status">
                        <span class="visually-hidden">Carregando...</span>
                    </div>
                    <p class="mt-3 mb-0">Carregando estudantes...</p>
                </div>
                <?php else: ?>
                <div class="table-responsive">
                    <table class="table table-hover align-middle mb-0">
                        <thead class="bg-light">
                            <tr>
                                <th width="50px" class="ps-4">
                                    <div class="form-check">
                                        <input class="form-check-input" type="checkbox" id="select-all">
                                    </div>
                                </th>
                                <th>Nome</th>
                                <th>Gênero</th>
                                <th>Email</th>
                                <th>Código</th>
                                <th>Ano</th>
                                <th class="text-end pe-4">Ações</th>
                            </tr>
                        </thead>
                        <tbody>
                            <?php $__empty_1 = true; $__currentLoopData = $students; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $student): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); $__empty_1 = false; ?>
                            <tr>
                                <td class="ps-4">
                                    <div class="form-check">
                                        <input class="form-check-input student-checkbox"
                                               type="checkbox"
                                               wire:model="selectedStudents"
                                               value="<?php echo e($student['id']); ?>">
                                    </div>
                                </td>
                                <td><?php echo e($student['name']); ?></td>
                                <td><?php echo e(ucfirst($student['sex'])); ?></td>
                                <td><?php echo e($student['email']); ?></td>
                                <td><?php echo e($student['student_id'] ?? 'N/A'); ?></td>
                                <td><?php echo e($student['year_edu'] ?? 'N/A'); ?></td>
                                <td class="pe-4">
                                    <div class="d-flex justify-content-end">
                                        <a href="<?php echo e(route('admin.fee.collect', $student['id'])); ?>"
                                           class="btn btn-sm btn-primary">
                                            <i class="fas fa-money-bill-wave me-1"></i>Cobrar
                                        </a>
                                    </div>
                                </td>
                            </tr>
                            <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); if ($__empty_1): ?>
                            <tr>
                                <td colspan="7" class="text-center py-4">
                                    <div class="py-5">
                                        <i class="fas fa-user-slash text-muted" style="font-size: 3rem;"></i>
                                        <h5 class="mt-3">Nenhum estudante encontrado</h5>
                                        <p class="text-muted">Ajuste os filtros para encontrar estudantes</p>
                                    </div>
                                </td>
                            </tr>
                            <?php endif; ?>
                        </tbody>
                    </table>
                </div>
                <?php endif; ?>

                <?php if(count($students) > 0 && count($selectedStudents) > 0): ?>
                <div class="d-flex justify-content-between align-items-center p-4 border-top">
                    <div>
                        <span class="text-muted">
                            <?php echo e(count($selectedStudents)); ?> de <?php echo e(count($students)); ?> selecionados
                        </span>
                    </div>
                    <div class="d-flex">
                        <button class="btn btn-primary" wire:click="assignFeeGroup" wire:loading.attr="disabled">
                            <span wire:loading.remove>
                                <i class="fas fa-money-bill-wave me-1"></i>Cobrar Selecionados
                            </span>
                            <span wire:loading>
                                <span class="spinner-border spinner-border-sm me-1" role="status" aria-hidden="true"></span>
                                Processando...
                            </span>
                        </button>
                    </div>
                </div>
                <?php endif; ?>
            </div>
        </div>
    </div>
</div>

<?php $__env->startPush('scripts'); ?>
<script>
    document.addEventListener('livewire:load', function() {
        document.getElementById('select-all').addEventListener('change', function(e) {
            let checkboxes = document.querySelectorAll('.student-checkbox');
            checkboxes.forEach(checkbox => {
                checkbox.checked = e.target.checked;
                checkbox.dispatchEvent(new Event('change'));
            });
        });
    });
</script>
<?php $__env->stopPush(); ?>
<?php /**PATH /home/salum3x/public_html/siga.copmoz.ac.mz/resources/views/livewire/admin/fee/fee-collect.blade.php ENDPATH**/ ?>