<div>
    <div class="page-content">
        <div class="main-wrapper">
            <div class="row">
                <div class="col">
                    <div class="card">
                        <div class="card-body" wire:init="loadData">
                            <h5 class="card-title"> Notas do Estudante: <?php echo e($model->name); ?> </h5>
                            <div class="row">
                                <div class="col-md-12">
                                    <input type="search" wire:model="search" placeholder="Pesquisar..."
                                        class="form-control">
                                </div>
                                <div class="mt-3">
                                    <label for="selectedYear" class="block font-medium text-sm text-gray-700">Selecionar
                                        ano lectivo</label>
                                    <select wire:model="selectedYear" id="selectedYear" name="selectedYear"
                                        class="mt-1 block w-full py-2 px-3 border border-gray-300 bg-white rounded-md shadow-sm focus:outline-none focus:ring-indigo-500 focus:border-indigo-500 sm:text-sm">
                                        <?php for($year = date('Y'); $year >= 2023; $year--): ?>
                                            <option value="<?php echo e($year); ?>"><?php echo e($year); ?></option>
                                        <?php endfor; ?>
                                    </select>
                                </div>

                            </div>
                            <div class="row">
                                <div class="col-md-4">
                                    <div class="table-responsive" wire:init="loadData">
                                        <?php if(count($models)): ?>
                                            <table class="table table-hover">
                                                <thead>
                                                    <th colspan="2"><b>Primeiro Trimestre</b></th>
                                                    <tr>
                                                        <th scope="col">Disciplina</th>
                                                        <th scope="col">ASC1</th>
                                                        <th scope="col">ASC2</th>
                                                        <th scope="col">MACS</th>
                                                        <th scope="col">AT</th>
                                                        <th scope="col">MT</th>
                                                        <?php if(empty($selectedYear) || $selectedYear == $currentYear): ?>
                                                            <th scope="col">Editar</th>
                                                        <?php endif; ?>

                                                    </tr>
                                                </thead>
                                                <tbody>
                                                    <?php ($count = 1); ?>
                                                    <?php $__currentLoopData = $models->where('trimester_id', 1)->sortBy('subject.name'); $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $model): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                                                        <tr>
                                                            <td><?php echo e($model->subject->name); ?></td>
                                                            <td><?php echo e(number_format($model->ACS1a, 2)); ?></td>
                                                            <td><?php echo e(number_format($model->ACS2a, 2)); ?></td>
                                                            <td><?php echo e(number_format((floatval($model->ACS2a) + floatval($model->ACS1a)) * 0.5, 2)); ?></td>
                                                            <td><?php echo e(number_format($model->AT, 2)); ?></td>
                                                            <td><?php echo e(round((2 * ((floatval($model->ACS1a) + floatval($model->ACS2a)) / 2) + floatval($model->AT)) / 3, 0)); ?></td>
                                                            <?php if(empty($selectedYear) || $selectedYear == $currentYear): ?>
                                                                <td>
                                                                    <?php if($confirmingEditMarks == 'yes'): ?>
                                                                        <a href="<?php echo e(route('admin.edit.student.exam', $model->id)); ?>"
                                                                            class="btn btn-outline-primary">
                                                                            <span class="fa fa-edit"></span>
                                                                        </a>
                                                                    <?php endif; ?>
                                                                </td>
                                                            <?php endif; ?>

                                                        </tr>
                                                    <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                                                </tbody>
                                            </table>
                                            <div class="row float-end">
                                                <?php echo e($models->links()); ?>

                                            </div>
                                        <?php else: ?>
                                            <br>
                                            <br>
                                            <div class="d-flex justify-content-center">
                                                <div wire:loading class="spinner-border text-primary" role="status">
                                                    <span class="sr-only">Processando...</span>
                                                </div>
                                            </div>
                                            <p class="text-center"><B>Nenhum dado foi encontrado no momento.</B></p>
                                        <?php endif; ?>
                                    </div>
                                </div>
                                <div class="col-md-4">
                                    <div class="table-responsive" wire:init="loadData">
                                        <?php if(count($models)): ?>
                                            <table class="table table-hover">
                                                <thead>
                                                    <th colspan="2"><b>Segundo Trimestre</b></th>
                                                    <tr>
                                                        <th scope="col">Disciplina</th>
                                                        <th scope="col">ASC1</th>
                                                        <th scope="col">ASC2</th>
                                                        <th scope="col">MACS</th>
                                                        <th scope="col">AT</th>
                                                        <th scope="col">MT</th>
                                                        <?php if(empty($selectedYear) || $selectedYear == $currentYear): ?>
                                                            <th scope="col">Editar</th>
                                                        <?php endif; ?>
                                                    </tr>
                                                </thead>
                                                <tbody>
                                                    <?php ($count = 1); ?>
                                                    <?php $__currentLoopData = $models->where('trimester_id', 2)->sortBy('subject.name'); $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $model2): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                                                        <tr>
                                                            <td><?php echo e($model2->subject->name); ?></td>
                                                            <td><?php echo e(number_format($model2->ACS1a, 2)); ?></td>
                                                            <td><?php echo e(number_format($model2->ACS2a, 2)); ?></td>
                                                            <td><?php echo e(number_format((floatval($model2->ACS2a) + floatval($model2->ACS1a)) * 0.5, 2)); ?></td>
                                                            <td><?php echo e(number_format($model2->AT, 2)); ?></td>
                                                            <td><?php echo e(round((2 * ((floatval($model2->ACS1a) + floatval($model2->ACS2a)) / 2) + floatval($model2->AT)) / 3, 0)); ?></td>
                                                            <?php if(empty($selectedYear) || $selectedYear == $currentYear): ?>
                                                                <td>
                                                                    <?php if($confirmingEditMarks == 'yes'): ?>
                                                                        <a href="<?php echo e(route('admin.edit.student.exam', $model2->id)); ?>"
                                                                            class="btn btn-outline-primary">
                                                                            <span class="fa fa-edit"></span>
                                                                        </a>
                                                                    <?php endif; ?>
                                                                </td>
                                                            <?php endif; ?>


                                                        </tr>
                                                    <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                                                </tbody>
                                            </table>
                                            <div class="row float-end">
                                                <?php echo e($models->links()); ?>

                                            </div>
                                        <?php else: ?>
                                            <br>
                                            <br>
                                            <div class="d-flex justify-content-center">
                                                <div wire:loading class="spinner-border text-primary" role="status">
                                                    <span class="sr-only">Processando...</span>
                                                </div>
                                            </div>
                                            <p class="text-center"><B>Nenhum dado foi encontrado no momento.</B></p>
                                        <?php endif; ?>
                                    </div>
                                </div>
                                <div class="col-md-4">
                                    <div class="table-responsive" wire:init="loadData">
                                        <?php if(count($models)): ?>
                                            <table class="table table-hover">
                                                <thead>
                                                    <th colspan="2"><b>Terceiro Trimestre</b></th>
                                                    <tr>
                                                        <th scope="col">Disciplina</th>
                                                        <th scope="col">ASC1</th>
                                                        <th scope="col">ASC2</th>
                                                        <th scope="col">MACS</th>
                                                        <th scope="col">AT</th>
                                                        <th scope="col">MT</th>
                                                        <?php if(empty($selectedYear) || $selectedYear == $currentYear): ?>
                                                            <th scope="col">Editar</th>
                                                        <?php endif; ?>

                                                    </tr>
                                                </thead>
                                                <tbody>
                                                    <?php ($count = 1); ?>
                                                    <?php $__currentLoopData = $models->where('trimester_id', 3)->sortBy('subject.name'); $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $model3): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                                                        <tr>
                                                            <td><?php echo e($model3->subject->name); ?></td>
                                                            <td><?php echo e(number_format($model3->ACS1a, 2)); ?></td>
                                                            <td><?php echo e(number_format($model3->ACS2a, 2)); ?></td>
                                                            <td><?php echo e(number_format((floatval($model3->ACS2a) + floatval($model3->ACS1a)) * 0.5, 2)); ?></td>
                                                            <td><?php echo e(number_format($model3->AT, 2)); ?></td>
                                                            <td><?php echo e(round((2 * ((floatval($model3->ACS1a) + floatval($model3->ACS2a)) / 2) + floatval($model3->AT)) / 3, 0)); ?></td>
                                                            <?php if(empty($selectedYear) || $selectedYear == $currentYear): ?>
                                                                <td>
                                                                    <?php if($confirmingEditMarks == 'yes'): ?>
                                                                        <a href="<?php echo e(route('admin.edit.student.exam', $model3->id)); ?>"
                                                                            class="btn btn-outline-primary">
                                                                            <span class="fa fa-edit"></span>
                                                                        </a>
                                                                    <?php endif; ?>
                                                                </td>
                                                            <?php endif; ?>


                                                        </tr>
                                                    <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                                                </tbody>
                                            </table>
                                            <div class="row float-end">
                                                <?php echo e($models->links()); ?>

                                            </div>
                                        <?php else: ?>
                                            <br>
                                            <br>
                                            <div class="d-flex justify-content-center">
                                                <div wire:loading class="spinner-border text-primary" role="status">
                                                    <span class="sr-only">Processando...</span>
                                                </div>
                                            </div>
                                            <p class="text-center"><B>Nenhum dado foi encontrado no momento.</B></p>
                                        <?php endif; ?>
                                    </div>
                                </div>
                            </div>
                        </div>
                    </div>
                </div>
            </div>
        </div>
    </div>
</div>
<?php /**PATH /home/salum3x/public_html/siga.copmoz.ac.mz/resources/views/livewire/admin/classes/academic-edit-results.blade.php ENDPATH**/ ?>