<div>
    <div class="page-content">
        <div class="main-wrapper">
            <div class="row">
                <div class="col">
                    <div class="card">
                        <div class="card-body" wire:init="loadData">
                            <h5 class="card-title"> Lista de matrizes</h5>
                            <div class="row">
                                <div class="col-md-6 mb-3">
                                    <input type="text" wire:model.debounce.300ms="search" placeholder="Pesquisar por..."
                                           class="form-control">
                                </div>

                                <!-- Add Filter Dropdown -->
                                <div class="col-md-6 mb-3">
                                    <select class="form-control" wire:model="filter">
                                        <option value="">Todos os campos</option>
                                        <option value="title">Título</option>
                                        <option value="description">Descrição</option>
                                        <option value="class">Classe/Turma</option>
                                        <option value="student">Estudante</option>
                                        <option value="type">Tipo (Todos/Classe/Estudante)</option>
                                        <option value="year">Ano (digite o ano na pesquisa)</option>      
                                    </select>
                                </div>
                            </div>

                            <div class="table-responsive" wire:init="loadData">
                                <?php if(count($models)): ?>
                                    <form wire:submit.prevent="bulkDelete">
                                    <table class="table table-hover">
                                        <thead>
                                        <tr>
                                             <th scope="col">
                                                <input type="checkbox" wire:model="selectAll">
                                             </th>
                                            <th scope="col">#</th>

                                            <?php if(!isset($student)){  ?>
                                            <th scope="col">Para</th>
                                            <?php } ?>
                                            <th scope="col">Classe</th>
                                            <th scope="col">Estudante</th>
                                            <th scope="col">Titulo</th>
                                            <th scope="col">Descrição</th>
                                            <th scope="col">Ficheiro</th>
                                            <th scope="col">Data de lançamento</th>
                                            <?php if(!isset($student)){  ?>
                                            <th scope="col">Acção</th>
                                            <?php } ?>
                                            
                                        </tr>
                                        </thead>
                                        <tbody>
                                        <?php ($count = 1); ?>
                                        <?php $__currentLoopData = $models; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $model): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                                        <?php 
                                        if(!empty($model->class_id)){
                                            $get_class = \App\Models\Classroom::query()->where("id",$model->class_id)->first() ?? 0;
                                        }
                                        if(!empty($model->student_id)){
                                            $get_student = \App\Models\User::query()->where("id",$model->student_id)->first() ?? 0;
                                        }
                                        $get_download = \App\Models\Downloadcenter::query()->where("slug",$model->download_id)->first() ?? 0;
                                        $get_files = \App\Models\Downloadfile::query()->where("download_id",$model->download_id)->get() ?? 0;
                                        
                                        if(isset($student)){ 
                                            $user = Auth::user();
                                            if(empty($model->student_id) || $model->student_id == $user->id  ){
                                                if($model->type == "all"){
                                                    $title = "Todos";
                                                }elseif($model->type == "student"){
                                                    $title = "Estudante";
                                                }elseif($model->type == "class"){
                                                    $title = "Classe";
                                                }
                                            ?>
                                            <tr>
                                                <td>
                                                    <input type="checkbox" wire:model="selectedIds" value="<?php echo e($model->id); ?>">
                                                </td>
                                                <th scope="row"><?php echo e($count++); ?></th>
                                                <td>
                                                    <?php if(!empty($model->class_id)): ?>
                                                    <?php echo e($get_class->class); ?> Classe - <?php echo e($get_class->name); ?>

                                                    <?php endif; ?>
                                                </td>
                                                <td>
                                                    <?php if(!empty($model->student_id)): ?>
                                                    <?php echo $get_student->name; ?>

                                                    <?php endif; ?>
                                                </td>
                                                <td><?php echo $get_download->title; ?></td>
                                                <td><?php echo $get_download->description; ?></td>
                                                
                                                <td>
                                                    <?php if($get_files->count() > 0): ?>
                                                        <?php $__currentLoopData = $get_files; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $file): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                                                            <a href="<?php echo e($file->media_url); ?>" target="_blank"><?php echo e($file->media_name); ?></a><br>
                                                        <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                                                    <?php else: ?>
                                                        Nenhum arquivo disponível.
                                                    <?php endif; ?>
                                                </td>
                                                
                                                <td><?php echo e(\Carbon\Carbon::parse($model->created_at)->format('d/m/Y H:i:s')); ?></td>

                                                
                                            </tr>
                                            <?php
                                            }
                                        }else{
                                             if($model->type == "all"){
                                                    $title = "Todos";
                                                }elseif($model->type == "student"){
                                                    $title = "Estudante";
                                                }elseif($model->type == "class"){
                                                    $title = "Classe";
                                                }
                                        ?>
                                            <tr>
                                                <td>
                                                    <input type="checkbox" wire:model="selectedIds" value="<?php echo e($model->id); ?>">
                                                </td>
                                                <th scope="row"><?php echo e($count++); ?></th>
                                                <td><?php echo e($title); ?></td>
                                                <td>
                                                    <?php if(!empty($model->class_id)): ?>
                                                    <?php echo e($get_class->class); ?> Classe - <?php echo e($get_class->name); ?>

                                                    <?php endif; ?>
                                                </td>
                                                <td>
                                                    <?php if(!empty($model->student_id)): ?>
                                                    <?php echo $get_student->name; ?>

                                                    <?php endif; ?>
                                                </td>
                                                <td><?php echo $get_download->title; ?></td>
                                                <td><?php echo $get_download->description; ?></td>
                                                <td>
                                                    <?php if($get_files->count() > 0): ?>
                                                        <?php $__currentLoopData = $get_files; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $file): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                                                            <a href="<?php echo e($file->media_url); ?>" target="_blank"><?php echo e($file->media_name); ?></a><br>
                                                        <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                                                    <?php else: ?>
                                                        Nenhum arquivo disponível.
                                                    <?php endif; ?>
                                                </td>
                                                <td><?php echo e(\Carbon\Carbon::parse($model->created_at)->format('d/m/Y H:i:s')); ?></td>

                                                
                                                <td>
                                                    <a href="<?php echo e(route('admin.edit.Download', $model->download_id)); ?>"
                                                        class="btn btn-block btn-outline-primary btn-sm"><span
                                                            class="fa fa-edit"></span>
                                                    </a>
                                                    <a type="button" wire:click="submit('<?php echo e($model->download_id); ?>')"
                                                        class="btn btn-outline-danger"><span class="fa fa-trash"></span></a>
                                                    
                                                </td>
                                                
                                            </tr>

                                           <?php } ?> 
                                        <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                                        </tbody>
                                    </table>
                                    <button type="submit" class="btn btn-danger mt-3" <?php echo e(count($selectedIds) === 0 ? 'disabled' : ''); ?>>
                                        Apagar
                                    </button>
                                    </form>
                                    <div class="d-flex justify-content-center">
            <?php echo e($models->links()); ?>

        </div>    
                                <?php else: ?>
                                    <br>
                                    <br>
                                    <div  class="d-flex justify-content-center">
                                        <div wire:loading class="spinner-border text-primary" role="status">
                                            <span class="sr-only">Processando...</span>
                                        </div>
                                    </div>
                                    <p class="text-center"><B>Nenhum dado foi encontrado no momento.</B></p>
                                <?php endif; ?>
                            </div>
                        </div>
                    </div>
                </div>
            </div>
        </div>
    </div>
</div><?php /**PATH /home/salum3x/public_html/siga.copmoz.ac.mz/resources/views/livewire/admin/downloadcenter/downloads.blade.php ENDPATH**/ ?>