<?php

namespace App\Console;

use Illuminate\Console\Scheduling\Schedule;
use Illuminate\Foundation\Console\Kernel as ConsoleKernel;

class Kernel extends ConsoleKernel
{
    /**
     * Define the application's command schedule.
     */
    
    protected function schedule(Schedule $schedule): void
    {
        
        
        $schedule->command('send:birthday-messages')
            ->dailyAt('08:00')
            ->timezone('Africa/Maputo')   // garante 08:00 no teu fuso
            ->withoutOverlapping()        // evita rodar duas vezes se demorar
            ->appendOutputTo(storage_path('logs/scheduler.log')); // log opcional
    }

    /**
     * Register the commands for the application.
     */
    protected function commands(): void
    {
        $this->load(__DIR__.'/Commands');
        require base_path('routes/console.php');
    }
}

