<?php

namespace App\Http\Controllers;

use Illuminate\Http\Request;
use Illuminate\Support\Facades\Cache;
use Illuminate\Support\Facades\Log;

class TypingController extends Controller
{
    /**
     * Enviar evento de digitação
     */
    public function sendTypingEvent(Request $request)
    {
        $channelId = $request->channel_id;
        $isTyping = $request->typing == 1;
        $userId = auth()->id();

        $cacheKey = "typing_{$channelId}_{$userId}";

        if ($isTyping) {
            Cache::put($cacheKey, true, 3); // 3 segundos
            Log::info("✍️ Typing: User {$userId} in channel {$channelId}");
        } else {
            Cache::forget($cacheKey);
            Log::info("⏹️ Stopped typing: User {$userId} in channel {$channelId}");
        }

        return response()->json(['status' => 'success']);
    }

    /**
     * Verificar se outro usuário está digitando
     */
    public function getTypingStatus(Request $request)
    {
        $channelId = $request->channel_id;
        $currentUserId = auth()->id();

        // Pegar participantes do canal
        $participants = \DB::table('message_channel_user')
            ->where('channel_id', $channelId)
            ->pluck('user_id');

        $isTyping = false;

        foreach ($participants as $userId) {
            if ($userId != $currentUserId) {
                $key = "typing_{$channelId}_{$userId}";
                if (Cache::has($key)) {
                    $isTyping = true;
                    Log::info("⌨️ User {$userId} is typing in channel {$channelId}");
                    break;
                }
            }
        }

        return response()->json([
            'is_typing' => $isTyping,
            'channel_id' => $channelId
        ]);
    }
}
