<?php

namespace App\Http\Controllers;

use Illuminate\Http\Request;
use Illuminate\Support\Facades\Cache;
use Illuminate\Support\Facades\Log;
use Illuminate\Support\Facades\DB;

class TypingStatusController extends Controller
{
    /**
     * Verificar se outro usuário está digitando
     * GET /chatify/api/typing-status?channel_id=xxx
     */
    public function getTypingStatus(Request $request)
    {
        try {
            $channelId = $request->channel_id;
            $currentUserId = auth()->id();

            if (!$channelId) {
                return response()->json([
                    'is_typing' => false,
                    'error' => 'channel_id required'
                ], 400);
            }

            // Buscar todos os participantes do canal
            $participants = DB::table('message_channel_user')
                ->where('channel_id', $channelId)
                ->pluck('user_id')
                ->toArray();

            $isTyping = false;
            $typingUserId = null;

            // Verificar se algum participante (exceto o usuário atual) está digitando
            foreach ($participants as $userId) {
                if ($userId != $currentUserId) {
                    // Verifica a chave de cache que o sistema já usa
                    $cacheKey = "typing:{$channelId}:{$userId}";

                    if (Cache::has($cacheKey)) {
                        $isTyping = true;
                        $typingUserId = $userId;
                        Log::info("⌨️ [API] User {$userId} is typing in channel {$channelId}");
                        break;
                    }
                }
            }

            return response()->json([
                'is_typing' => $isTyping,
                'channel_id' => $channelId,
                'typing_user_id' => $typingUserId
            ]);

        } catch (\Exception $e) {
            Log::error("❌ [Typing Status API] Error: " . $e->getMessage());
            return response()->json([
                'is_typing' => false,
                'error' => $e->getMessage()
            ], 500);
        }
    }
}
