<?php

namespace App\Http\Livewire\Admin\Classes;

use App\Models\Classroom;
use App\Models\Exam;
use App\Models\Project;
use App\Models\User;
use Illuminate\Validation\ValidationException;
use Jantinnerezo\LivewireAlert\LivewireAlert;
use LaravelMultipleGuards\Traits\FindGuard;
use Livewire\Component;
use Livewire\WithPagination;
use App\Models\TeacherSubject;
use Note\Note;
use Carbon\Carbon;


class TeacherViewMarksStudent extends Component
{
    protected $lazy = false;
    use FindGuard, LivewireAlert;
    use WithPagination;

    public $search, $user, $filterTrimester = '';
    public $model, $name;

    protected $queryString = ['search', 'filterTrimester'];

    protected string $paginationTheme = 'bootstrap';

    public function updatingSearch()
    {
        $this->resetPage();
    }

    public function updatingFilterTrimester()
    {
        $this->resetPage();
    }

    public bool $readyToLoad = false;

    public function loadData()
    {
        $this->readyToLoad = true;
    }

    public function mount($slug)
    {
        $this->model = User::query()->where('slug', $slug)->first();
    }

    public function render()
    {
     $this->user = $this->findGuardType()->user();
     $currentYear = Carbon::now()->year;
        return view('livewire.admin.classes.teacher-view-marks-student', [
            'models' => $this->readyToLoad
                ? Exam::query()
                    ->latest('updated_at')
  			        ->whereRelation('class.subjects','teacher_id', $this->user->id)
                    ->where('updated_at', 'like', '%' . $currentYear . '%')
                    ->when($this->search, function($query) {
                        $query->whereHas('subject', function($q) {
                            $q->where('name', 'like', '%' . $this->search . '%');
                        });
                    })
                    ->when($this->filterTrimester !== '', function($query) {
                        $query->where('trimester_id', $this->filterTrimester);
                    })
                    ->where('student_id', $this->model->id)
                    ->paginate(60)
                : [],
            'teacher' => TeacherSubject::where("teacher_id",$this->user->id)->get(),
        ]);
    }
}
