<?php

//namespace App\Http\Livewire\Admin\Fee;
//
//use App\Models\Fee_assign;
//use App\Models\User;
//use App\Services\FeeCalculationService;
//use Livewire\Component;
//use App\Models\FeeStructure;
//use Carbon\Carbon;
//use App\Models\FeesDiscount as discount;
//
//class FeeCollection extends Component
//{
//    public $studentId;
//    public $feeGroup;
//    public $date;
//    public $amount;
//    public $discountGroup;
//    public $discount = 0;
//    public $fine = 0;
//    public $paymentMode = 'Cash';
//    public $note;
//    public $students = [];
//    public $selectedStudent;
//    public $selectedFee;
//    public $selectedFeeAssignId;
//    public $month;
//    public $year;
//
//    // Propriedades calculadas
//    public $calculatedBaseFee = 0;
//    public $calculatedFine = 0;
//    public $calculatedTotal = 0;
//    public $isLatePayment = false;
//    public $dueDate = null;
//
//    protected $feeCalculationService;
//
//    public function boot(FeeCalculationService $feeCalculationService)
//    {
//        $this->feeCalculationService = $feeCalculationService;
//    }
//
//    public function mount($studentId)
//    {
//        $this->studentId = $studentId ? $studentId : "cpmc-1218";
//        $this->selectedStudent = User::findOrFail($studentId);
//        $this->date = now()->format('d/m/Y');
//        
//        // Calcula taxa automaticamente na inicialização
//        $this->calculateCurrentFee();
//    }
//
//    public function updated($propertyName)
//    {
//        // Recalcula quando month, year, discount ou fine mudarem
//        if (in_array($propertyName, ['month', 'year', 'discount', 'fine'])) {
//            $this->calculateCurrentFee();
//        }
//    }
//
//    public function calculateCurrentFee()
//    {
//        if (!$this->selectedStudent) {
//            return;
//        }
//
//        try {
//            $calculation = $this->feeCalculationService->calculateFeeForStudent(
//                $this->selectedStudent,
//                $this->month,
//                $this->year ? (int)$this->year : null
//            );
//
//            $this->calculatedBaseFee = $calculation['base_amount'];
//            $this->calculatedFine = $calculation['fine_amount'] + (float)$this->fine; // Multa calculada + manual
//            $this->calculatedTotal = $calculation['base_amount'] + $this->calculatedFine - (float)$this->discount;
//            $this->isLatePayment = $calculation['is_late_payment'];
//            $this->dueDate = $calculation['due_date'];
//
//            // Atualiza o campo amount com o total calculado
//            $this->amount = max(0, $this->calculatedTotal);
//
//            $this->emit('feeCalculated', [
//                'baseFee' => $this->calculatedBaseFee,
//                'autoFine' => $calculation['fine_amount'],
//                'manualFine' => (float)$this->fine,
//                'totalFine' => $this->calculatedFine,
//                'total' => $this->calculatedTotal,
//                'isLate' => $this->isLatePayment,
//                'dueDate' => $this->dueDate?->format('d/m/Y')
//            ]);
//
//        } catch (\Exception $e) {
//            \Log::error('Error calculating fee', [
//                'student_id' => $this->studentId,
//                'month' => $this->month,
//                'year' => $this->year,
//                'error' => $e->getMessage()
//            ]);
//
//            // Fallback para cálculo manual básico
//            $this->fallbackCalculation();
//        }
//    }
//
//    private function fallbackCalculation()
//    {
//        // Busca estruturas de taxa como fallback
//        $studentClassroom = $this->selectedStudent->class->class ?? $this->selectedStudent->classroom->class ?? null;
//        
//        if (!$studentClassroom) {
//            $this->calculatedBaseFee = 0;
//            $this->calculatedFine = (float)$this->fine;
//            $this->calculatedTotal = (float)$this->fine - (float)$this->discount;
//            return;
//        }
//
//        $feeStructures = FeeStructure::where('active', 1)->get();
//        $filteredFeeStructures = [];
//
//        foreach ($feeStructures as $feeStructure) {
//            $gradesArray = explode(',', $feeStructure->grades);
//            if (in_array($studentClassroom, $gradesArray)) {
//                $filteredFeeStructures[] = $feeStructure;
//            }
//        }
//
//        $baseFee = 0;
//        foreach ($filteredFeeStructures as $feeStructure) {
//            $baseFee += $feeStructure->monthly_fee;
//        }
//
//        $this->calculatedBaseFee = $baseFee;
//        $this->calculatedFine = (float)$this->fine;
//        $this->calculatedTotal = $baseFee + (float)$this->fine - (float)$this->discount;
//        $this->amount = max(0, $this->calculatedTotal);
//    }
//
//    public function collectFee()
//    {
//        $this->validate([
//            'amount' => 'required|numeric|min:0',
//            'discount' => 'numeric|min:0',
//            'fine' => 'numeric|min:0',
//            'paymentMode' => 'required',
//        ]);
//
//        try {
//            // Usa o service unificado para criar o pagamento
//            $paymentData = [
//                'month' => $this->month ?: date('F'),
//                'year' => $this->year ?: date('Y'),
//                'amount' => (float)$this->amount,
//                'fine' => (float)$this->fine,
//                'discount' => (float)$this->discount,
//                'payment_mode' => $this->paymentMode,
//                'paymentMode' => $this->paymentMode, // Compatibilidade
//                'pay_type' => 'cash',
//                'note' => $this->note,
//                'payment_date' => now()
//            ];
//
//            $feeAssign = $this->feeCalculationService->createFeePayment(
//                $this->selectedStudent,
//                $paymentData
//            );
//
//            session()->flash('message', 'Pagamento de taxa/propina efetuado com sucesso. Multa preservada no histórico.');
//
//            // Log detalhado do pagamento
//            \Log::info('Admin fee payment collected', [
//                'student_id' => $this->studentId,
//                'fee_assign_id' => $feeAssign->id,
//                'payment_mode' => $this->paymentMode,
//                'total_paid' => $this->amount,
//                'base_calculated' => $this->calculatedBaseFee,
//                'fine_preserved' => $feeAssign->fine,
//                'discount_applied' => $this->discount,
//                'is_late_payment' => $this->isLatePayment,
//                'month' => $this->month,
//                'year' => $this->year
//            ]);
//
//            // Close modal after update
//            $this->dispatchBrowserEvent('closeModal');
//
//            // Reset form fields
//            $this->reset(['amount', 'discount', 'fine', 'paymentMode', 'note']);
//            
//            // Recalcula para o próximo uso
//            $this->calculateCurrentFee();
//
//        } catch (\Exception $e) {
//            \Log::error('Error collecting fee', [
//                'student_id' => $this->studentId,
//                'error' => $e->getMessage(),
//                'trace' => $e->getTraceAsString()
//            ]);
//
//            session()->flash('error', 'Erro ao processar pagamento: ' . $e->getMessage());
//        }
//    }
//
//    public function render()
//    {
//        // Busca estruturas de taxa aplicáveis para exibição
//        $studentClassroom = $this->selectedStudent->class->class ?? $this->selectedStudent->classroom->class ?? null;
//        $filteredFeeStructures = [];
//
//        if ($studentClassroom) {
//            $feeStructures = FeeStructure::where('active', 1)->get();
//            
//            foreach ($feeStructures as $feeStructure) {
//                $gradesArray = explode(',', $feeStructure->grades);
//                if (in_array($studentClassroom, $gradesArray)) {
//                    $filteredFeeStructures[] = $feeStructure;
//                }
//            }
//        }
//
//        // GERA DADOS PARA A TABELA - Todos os meses do ano atual
//        $currentYear = date('Y');
//        $months = [
//            'January', 'February', 'March', 'April', 'May', 'June',
//            'July', 'August', 'September', 'October', 'November', 'December'
//        ];
//
//        $monthlyData = [];
//        $totalExpected = 0;
//        $totalPaid = 0;
//        $totalPending = 0;
//        $totalOverdue = 0;
//
//        foreach ($months as $monthName) {
//            try {
//                // Calcula usando o service unificado
//                $calculation = $this->feeCalculationService->calculateFeeForStudent(
//                    $this->selectedStudent,
//                    $monthName,
//                    $currentYear
//                );
//
//                // Verifica se já foi pago
//                $existingPayment = $this->feeCalculationService->getPaymentForPeriod(
//                    $this->selectedStudent,
//                    $monthName,
//                    $currentYear
//                );
//
//                $isPaid = !is_null($existingPayment);
//                $paidAmount = $isPaid ? ($existingPayment->amount + $existingPayment->fine - $existingPayment->discount) : 0;
//                $balanceAmount = $isPaid ? 0 : $calculation['total_amount'];
//
//                // Determina status
//                $status = 'Não Pago';
//                if ($isPaid) {
//                    $status = 'Pago';
//                } elseif ($calculation['is_late_payment']) {
//                    $status = 'Em Atraso';
//                }
//
//                $monthlyData[] = [
//                    'month' => $monthName,
//                    'year' => $currentYear,
//                    'fee_names' => $this->getFeeNamesForMonth($filteredFeeStructures, $monthName),
//                    'due_date' => $calculation['due_date'] ? $calculation['due_date']->format('d/m/Y') : 'N/A',
//                    'status' => $status,
//                    'base_amount' => $calculation['base_amount'],
//                    'fine_amount' => $calculation['fine_amount'],
//                    'total_expected' => $calculation['total_amount'],
//                    'discount_applied' => $isPaid ? $existingPayment->discount : 0,
//                    'paid_amount' => $paidAmount,
//                    'balance_amount' => $balanceAmount,
//                    'payment_date' => $isPaid ? $existingPayment->created_at->format('d/m/Y') : 'N/A',
//                    'is_paid' => $isPaid,
//                    'is_overdue' => $calculation['is_late_payment'],
//                    'existing_payment' => $existingPayment,
//                    'data_status' => $isPaid ? 'paid' : ($calculation['is_late_payment'] ? 'overdue' : 'pending')
//                ];
//
//                // Atualiza totais
//                $totalExpected += $calculation['total_amount'];
//                if ($isPaid) {
//                    $totalPaid += $paidAmount;
//                } else {
//                    if ($calculation['is_late_payment']) {
//                        $totalOverdue += $calculation['total_amount'];
//                    } else {
//                        $totalPending += $calculation['total_amount'];
//                    }
//                }
//
//            } catch (\Exception $e) {
//                \Log::error('Error calculating month data', [
//                    'month' => $monthName,
//                    'year' => $currentYear,
//                    'student_id' => $this->studentId,
//                    'error' => $e->getMessage()
//                ]);
//
//                // Dados de fallback para meses com erro
//                $monthlyData[] = [
//                    'month' => $monthName,
//                    'year' => $currentYear,
//                    'fee_names' => 'Taxa Escolar',
//                    'due_date' => 'N/A',
//                    'status' => 'Erro',
//                    'base_amount' => 0,
//                    'fine_amount' => 0,
//                    'total_expected' => 0,
//                    'discount_applied' => 0,
//                    'paid_amount' => 0,
//                    'balance_amount' => 0,
//                    'payment_date' => 'N/A',
//                    'is_paid' => false,
//                    'is_overdue' => false,
//                    'existing_payment' => null,
//                    'data_status' => 'error'
//                ];
//            }
//        }
//
//        // Busca pagamentos existentes (para compatibilidade)
//        $fees = Fee_assign::where('student_id', $this->studentId)
//                         ->orderBy('created_at', 'desc')
//                         ->get()
//                         ->map(function ($fee) {
//                             $fee->total_expected = $fee->amount + $fee->fine - $fee->discount;
//                             $fee->has_fine = $fee->fine > 0;
//                             $fee->fine_percentage = $fee->amount > 0 ? round(($fee->fine / $fee->amount) * 100, 1) : 0;
//                             $fee->payment_status = 'complete';
//                             return $fee;
//                         });
//
//        $discounts = discount::where('student_id', $this->studentId)->get();
//
//        return view('livewire.admin.fee.fee-collection', [
//            'student' => $this->selectedStudent,
//            'fees' => $fees,
//            'fee' => $this->calculatedTotal,
//            'feestructures' => $filteredFeeStructures,
//            'discounts' => $discounts,
//            'calculatedBaseFee' => $this->calculatedBaseFee,
//            'calculatedFine' => $this->calculatedFine,
//            'calculatedTotal' => $this->calculatedTotal,
//            'isLatePayment' => $this->isLatePayment,
//            'dueDate' => $this->dueDate,
//            
//            // NOVOS DADOS PARA A TABELA
//            'monthlyData' => $monthlyData,
//            'yearSummary' => [
//                'total_expected' => $totalExpected,
//                'total_paid' => $totalPaid,
//                'total_pending' => $totalPending,
//                'total_overdue' => $totalOverdue,
//                'current_year' => $currentYear
//            ]
//        ]);
//    }
//
//    private function getFeeNamesForMonth($feeStructures, $month)
//    {
//        $names = [];
//        foreach ($feeStructures as $structure) {
//            if (empty($structure->months) || in_array($month, explode(',', $structure->months))) {
//                $names[] = $structure->fee_name ?? 'Taxa Escolar';
//            }
//        }
//        return empty($names) ? 'Taxa Escolar' : implode(', ', array_unique($names));
//    }
//
//    public function openModal($feeAssignId, $amount, $month, $year)
//    {
//        $this->selectedFeeAssignId = $feeAssignId;
//        $this->month = (string) $month;
//        $this->year = (int) $year;
//        
//        // Recalcula com os novos parâmetros
//        $this->calculateCurrentFee();
//        
//        $this->dispatchBrowserEvent('openModal');
//        $this->emit('openModal', $feeAssignId, $amount, $month, $year);
//    }
//
//    // Métodos auxiliares para a interface
//    public function setMonth($month)
//    {
//        $this->month = $month;
//        $this->calculateCurrentFee();
//    }
//
//    public function setYear($year)
//    {
//        $this->year = $year;
//        $this->calculateCurrentFee();
//    }
//
//    public function addFine($amount)
//    {
//        $this->fine += $amount;
//        $this->calculateCurrentFee();
//    }
//
//    public function addDiscount($amount)
//    {
//        $this->discount += $amount;
//        $this->calculateCurrentFee();
//    }
//
//    public function resetCalculation()
//    {
//        $this->fine = 0;
//        $this->discount = 0;
//        $this->month = null;
//        $this->year = null;
//        $this->calculateCurrentFee();
//    }
//
//    // Método para verificar se pagamento já existe
//    public function checkExistingPayment($month, $year)
//    {
//        return $this->feeCalculationService->hasPaymentForPeriod(
//            $this->selectedStudent,
//            $month,
//            $year
//        );
//    }
//
//    // Propriedade computada para exibir detalhes do cálculo
//    public function getCalculationDetailsProperty()
//    {
//        return [
//            'base_fee' => $this->calculatedBaseFee,
//            'calculated_auto_fine' => max(0, $this->calculatedFine - (float)$this->fine),
//            'manual_fine' => (float)$this->fine,
//            'total_fine' => $this->calculatedFine,
//            'discount' => (float)$this->discount,
//            'total' => $this->calculatedTotal,
//            'is_late' => $this->isLatePayment,
//            'due_date' => $this->dueDate?->format('d/m/Y'),
//            'month' => $this->month ?: 'Current',
//            'year' => $this->year ?: date('Y'),
//            'preservation_note' => 'As multas são preservadas no histórico para auditoria completa'
//        ];
//    }
//}



//V2 funcional
//namespace App\Http\Livewire\Admin\Fee;
//
//use App\Models\Fee_assign;
//use App\Models\User;
//use App\Services\FeeCalculationService;
//use Livewire\Component;
//use App\Models\FeeStructure;
//use Carbon\Carbon;
//use App\Models\FeesDiscount as discount;
//
//// ✅ ADICIONAR IMPORTS PARA EXPORTAÇÃO
//use Maatwebsite\Excel\Facades\Excel;
//use Barryvdh\DomPDF\Facade\Pdf;
//use Illuminate\Support\Facades\Response;
//
//class FeeCollection extends Component
//{
//    public $studentId;
//    public $feeGroup;
//    public $date;
//    public $amount;
//    public $discountGroup;
//    public $discount = 0;
//    public $fine = 0;
//    public $paymentMode = 'Cash';
//    public $note;
//    public $students = [];
//    public $selectedStudent;
//    public $selectedFee;
//    public $selectedFeeAssignId;
//    public $month;
//    public $year;
//
//    // Propriedades calculadas
//    public $calculatedBaseFee = 0;
//    public $calculatedFine = 0;
//    public $calculatedTotal = 0;
//    public $isLatePayment = false;
//    public $dueDate = null;
//
//    // ✅ NOVA PROPRIEDADE PARA CONTROLAR ANO DA EXPORTAÇÃO
//    public $selectedYear;
//
//    protected $feeCalculationService;
//
//    public function boot(FeeCalculationService $feeCalculationService)
//    {
//        $this->feeCalculationService = $feeCalculationService;
//    }
//
//    public function mount($studentId)
//    {
//        $this->studentId = $studentId ? $studentId : "cpmc-1218";
//        $this->selectedStudent = User::findOrFail($studentId);
//        $this->date = now()->format('d/m/Y');
//        $this->selectedYear = now()->year; // ✅ INICIALIZAR ANO ATUAL
//
//        // Calcula taxa automaticamente na inicialização
//        $this->calculateCurrentFee();
//    }
//
//    public function updated($propertyName)
//    {
//        // Recalcula quando month, year, discount ou fine mudarem
//        if (in_array($propertyName, ['month', 'year', 'discount', 'fine'])) {
//            $this->calculateCurrentFee();
//        }
//    }
//
//    public function calculateCurrentFee()
//    {
//        if (!$this->selectedStudent) {
//            return;
//        }
//
//        try {
//            $calculation = $this->feeCalculationService->calculateFeeForStudent(
//                $this->selectedStudent,
//                $this->month,
//                $this->year ? (int)$this->year : null
//            );
//
//            $this->calculatedBaseFee = $calculation['base_amount'];
//            $this->calculatedFine = $calculation['fine_amount'] + (float)$this->fine; // Multa calculada + manual
//            $this->calculatedTotal = $calculation['base_amount'] + $this->calculatedFine - (float)$this->discount;
//            $this->isLatePayment = $calculation['is_late_payment'];
//            $this->dueDate = $calculation['due_date'];
//
//            // Atualiza o campo amount com o total calculado
//            $this->amount = max(0, $this->calculatedTotal);
//
//            $this->emit('feeCalculated', [
//                'baseFee' => $this->calculatedBaseFee,
//                'autoFine' => $calculation['fine_amount'],
//                'manualFine' => (float)$this->fine,
//                'totalFine' => $this->calculatedFine,
//                'total' => $this->calculatedTotal,
//                'isLate' => $this->isLatePayment,
//                'dueDate' => $this->dueDate?->format('d/m/Y')
//            ]);
//
//        } catch (\Exception $e) {
//            \Log::error('Error calculating fee', [
//                'student_id' => $this->studentId,
//                'month' => $this->month,
//                'year' => $this->year,
//                'error' => $e->getMessage()
//            ]);
//
//            // Fallback para cálculo manual básico
//            $this->fallbackCalculation();
//        }
//    }
//
//    private function fallbackCalculation()
//    {
//        // Busca estruturas de taxa como fallback
//        $studentClassroom = $this->selectedStudent->class->class ?? $this->selectedStudent->classroom->class ?? null;
//
//        if (!$studentClassroom) {
//            $this->calculatedBaseFee = 0;
//            $this->calculatedFine = (float)$this->fine;
//            $this->calculatedTotal = (float)$this->fine - (float)$this->discount;
//            return;
//        }
//
//        $feeStructures = FeeStructure::where('active', 1)->get();
//        $filteredFeeStructures = [];
//
//        foreach ($feeStructures as $feeStructure) {
//            $gradesArray = explode(',', $feeStructure->grades);
//            if (in_array($studentClassroom, $gradesArray)) {
//                $filteredFeeStructures[] = $feeStructure;
//            }
//        }
//
//        $baseFee = 0;
//        foreach ($filteredFeeStructures as $feeStructure) {
//            $baseFee += $feeStructure->monthly_fee;
//        }
//
//        $this->calculatedBaseFee = $baseFee;
//        $this->calculatedFine = (float)$this->fine;
//        $this->calculatedTotal = $baseFee + (float)$this->fine - (float)$this->discount;
//        $this->amount = max(0, $this->calculatedTotal);
//    }
//
//    public function collectFee()
//    {
//        $this->validate([
//            'amount' => 'required|numeric|min:0',
//            'discount' => 'numeric|min:0',
//            'fine' => 'numeric|min:0',
//            'paymentMode' => 'required',
//        ]);
//
//        try {
//            // Usa o service unificado para criar o pagamento
//            $paymentData = [
//                'month' => $this->month ?: date('F'),
//                'year' => $this->year ?: date('Y'),
//                'amount' => (float)$this->amount,
//                'fine' => (float)$this->fine,
//                'discount' => (float)$this->discount,
//                'payment_mode' => $this->paymentMode,
//                'paymentMode' => $this->paymentMode, // Compatibilidade
//                'pay_type' => 'cash',
//                'note' => $this->note,
//                'payment_date' => now()
//            ];
//
//            $feeAssign = $this->feeCalculationService->createFeePayment(
//                $this->selectedStudent,
//                $paymentData
//            );
//
//            session()->flash('message', 'Pagamento de taxa/propina efetuado com sucesso. Multa preservada no histórico.');
//
//            // Log detalhado do pagamento
//            \Log::info('Admin fee payment collected', [
//                'student_id' => $this->studentId,
//                'fee_assign_id' => $feeAssign->id,
//                'payment_mode' => $this->paymentMode,
//                'total_paid' => $this->amount,
//                'base_calculated' => $this->calculatedBaseFee,
//                'fine_preserved' => $feeAssign->fine,
//                'discount_applied' => $this->discount,
//                'is_late_payment' => $this->isLatePayment,
//                'month' => $this->month,
//                'year' => $this->year
//            ]);
//
//            // Close modal after update
//            $this->dispatchBrowserEvent('closeModal');
//
//            // Reset form fields
//            $this->reset(['amount', 'discount', 'fine', 'paymentMode', 'note']);
//
//            // Recalcula para o próximo uso
//            $this->calculateCurrentFee();
//
//        } catch (\Exception $e) {
//            \Log::error('Error collecting fee', [
//                'student_id' => $this->studentId,
//                'error' => $e->getMessage(),
//                'trace' => $e->getTraceAsString()
//            ]);
//
//            session()->flash('error', 'Erro ao processar pagamento: ' . $e->getMessage());
//        }
//    }
//
//    // ✅ NOVO MÉTODO: EXPORTAR PARA EXCEL
//    public function exportExcel()
//    {
//        try {
//            $data = $this->getExportData();
//
//            return Excel::download(new class($data) implements \Maatwebsite\Excel\Concerns\FromArray, \Maatwebsite\Excel\Concerns\WithHeadings, \Maatwebsite\Excel\Concerns\WithStyles {
//                private $data;
//
//                public function __construct($data) {
//                    $this->data = $data;
//                }
//
//                public function array(): array {
//                    return $this->data['rows'];
//                }
//
//                public function headings(): array {
//                    return [
//                        'Período', 'Taxas', 'Vencimento', 'Estado',
//                        'Valor Base (MT)', 'Multa (MT)', 'Desconto (MT)',
//                        'Valor Pago (MT)', 'Data de Pagamento'
//                    ];
//                }
//
//                public function styles(\PhpOffice\PhpSpreadsheet\Worksheet\Worksheet $sheet) {
//                    return [
//                        1 => ['font' => ['bold' => true, 'size' => 12]],
//                        'A:I' => ['alignment' => ['horizontal' => 'center']],
//                    ];
//                }
//            }, "extrato_financeiro_{$this->selectedStudent->name}_{$this->selectedYear}.xlsx");
//
//        } catch (\Exception $e) {
//            \Log::error('Excel export failed', ['error' => $e->getMessage()]);
//            session()->flash('error', 'Erro ao exportar Excel: ' . $e->getMessage());
//        }
//    }
//
//    // ✅ NOVO MÉTODO: EXPORTAR PARA PDF
//    public function exportPdf()
//    {
//        try {
//            $data = $this->getExportData();
//
//            $pdf = Pdf::loadView('exports.student-finance-pdf', [
//                'student' => $this->selectedStudent,
//                'year' => $this->selectedYear,
//                'data' => $data,
//                'generated_at' => now()->format('d/m/Y H:i'),
//            ]);
//
//            return $pdf->download("extrato_financeiro_{$this->selectedStudent->name}_{$this->selectedYear}.pdf");
//
//        } catch (\Exception $e) {
//            \Log::error('PDF export failed', ['error' => $e->getMessage()]);
//            session()->flash('error', 'Erro ao exportar PDF: ' . $e->getMessage());
//        }
//    }
//
//    // ✅ NOVO MÉTODO: PREPARAR DADOS PARA EXPORTAÇÃO
//    private function getExportData()
//    {
//        $currentYear = $this->selectedYear ?? now()->year;
//        $months = [
//            'January', 'February', 'March', 'April', 'May', 'June',
//            'July', 'August', 'September', 'October', 'November', 'December'
//        ];
//
//        // Busca estruturas de taxa aplicáveis
//        $studentClassroom = $this->selectedStudent->class->class ?? $this->selectedStudent->classroom->class ?? null;
//        $filteredFeeStructures = [];
//
//        if ($studentClassroom) {
//            $feeStructures = FeeStructure::where('active', 1)->get();
//
//            foreach ($feeStructures as $feeStructure) {
//                $gradesArray = explode(',', $feeStructure->grades);
//                if (in_array($studentClassroom, $gradesArray)) {
//                    $filteredFeeStructures[] = $feeStructure;
//                }
//            }
//        }
//
//        $exportData = [];
//        $summary = [
//            'total_annual_value' => 0,
//            'total_paid' => 0,
//            'total_due' => 0,
//            'total_overdue' => 0,
//            'total_fines_paid' => 0,
//            'total_discounts_given' => 0,
//            'total_net_received' => 0,
//            'months_with_fees' => 0,
//            'months_paid_count' => 0
//        ];
//
//        foreach ($months as $monthName) {
//            try {
//                $calculation = $this->feeCalculationService->calculateFeeForStudent(
//                    $this->selectedStudent,
//                    $monthName,
//                    $currentYear
//                );
//
//                if ($calculation['base_amount'] <= 0) continue;
//
//                $existingPayment = $this->feeCalculationService->getPaymentForPeriod(
//                    $this->selectedStudent,
//                    $monthName,
//                    $currentYear
//                );
//
//                $isPaid = !is_null($existingPayment);
//                $paidAmount = $isPaid ? ($existingPayment->amount + $existingPayment->fine - $existingPayment->discount) : 0;
//                $fineAmount = $isPaid ? ($existingPayment->fine ?? 0) : $calculation['fine_amount'];
//                $discountAmount = $isPaid ? ($existingPayment->discount ?? 0) : 0;
//
//                // Determina status
//                $status = 'Não Pago';
//                if ($isPaid) {
//                    $status = 'Pago';
//                } elseif ($calculation['is_late_payment']) {
//                    $status = 'Em Atraso';
//                }
//
//                $feeNames = $this->getFeeNamesForMonth($filteredFeeStructures, $monthName);
//                $dueDate = $calculation['due_date'] ? $calculation['due_date']->format('d/m/Y') : 'N/A';
//                $paymentDate = $isPaid ? $existingPayment->created_at->format('d/m/Y') : '--';
//
//                $exportData[] = [
//                    $monthName . ' ' . $currentYear,
//                    $feeNames,
//                    $dueDate,
//                    $status,
//                    number_format($calculation['base_amount'], 2, ',', '.'),
//                    number_format($fineAmount, 2, ',', '.'),
//                    number_format($discountAmount, 2, ',', '.'),
//                    number_format($paidAmount, 2, ',', '.'),
//                    $paymentDate
//                ];
//
//                // Atualiza resumo
//                $summary['total_annual_value'] += $calculation['base_amount'];
//                $summary['months_with_fees']++;
//
//                if ($isPaid) {
//                    $summary['total_paid'] += $existingPayment->amount;
//                    $summary['total_fines_paid'] += $existingPayment->fine ?? 0;
//                    $summary['total_discounts_given'] += $existingPayment->discount ?? 0;
//                    $summary['total_net_received'] += $paidAmount;
//                    $summary['months_paid_count']++;
//                } else {
//                    if ($calculation['is_late_payment']) {
//                        $summary['total_overdue'] += $calculation['base_amount'];
//                    } else {
//                        $summary['total_due'] += $calculation['base_amount'];
//                    }
//                }
//
//            } catch (\Exception $e) {
//                \Log::error('Error preparing export data for month', [
//                    'month' => $monthName,
//                    'year' => $currentYear,
//                    'error' => $e->getMessage()
//                ]);
//                continue;
//            }
//        }
//
//        $summary['payment_rate'] = $summary['months_with_fees'] > 0
//            ? round(($summary['months_paid_count'] / $summary['months_with_fees']) * 100, 1)
//            : 0;
//
//        return [
//            'rows' => $exportData,
//            'summary' => $summary,
//            'student' => $this->selectedStudent,
//            'year' => $currentYear
//        ];
//    }
//
//    public function render()
//    {
//        // [CÓDIGO RENDER EXISTENTE MANTIDO INALTERADO]
//
//        // Busca estruturas de taxa aplicáveis para exibição
//        $studentClassroom = $this->selectedStudent->class->class ?? $this->selectedStudent->classroom->class ?? null;
//        $filteredFeeStructures = [];
//
//        if ($studentClassroom) {
//            $feeStructures = FeeStructure::where('active', 1)->get();
//
//            foreach ($feeStructures as $feeStructure) {
//                $gradesArray = explode(',', $feeStructure->grades);
//                if (in_array($studentClassroom, $gradesArray)) {
//                    $filteredFeeStructures[] = $feeStructure;
//                }
//            }
//        }
//
//        // GERA DADOS PARA A TABELA - Todos os meses do ano atual
//        $currentYear = $this->selectedYear ?? date('Y'); // ✅ USA ANO SELECIONADO
//        $months = [
//            'January', 'February', 'March', 'April', 'May', 'June',
//            'July', 'August', 'September', 'October', 'November', 'December'
//        ];
//
//        $monthlyData = [];
//        $totalExpected = 0;
//        $totalPaid = 0;
//        $totalPending = 0;
//        $totalOverdue = 0;
//
//        foreach ($months as $monthName) {
//            try {
//                // Calcula usando o service unificado
//                $calculation = $this->feeCalculationService->calculateFeeForStudent(
//                    $this->selectedStudent,
//                    $monthName,
//                    $currentYear
//                );
//
//                // Verifica se já foi pago
//                $existingPayment = $this->feeCalculationService->getPaymentForPeriod(
//                    $this->selectedStudent,
//                    $monthName,
//                    $currentYear
//                );
//
//                $isPaid = !is_null($existingPayment);
//                $paidAmount = $isPaid ? ($existingPayment->amount + $existingPayment->fine - $existingPayment->discount) : 0;
//                $balanceAmount = $isPaid ? 0 : $calculation['total_amount'];
//
//                // Determina status
//                $status = 'Não Pago';
//                if ($isPaid) {
//                    $status = 'Pago';
//                } elseif ($calculation['is_late_payment']) {
//                    $status = 'Em Atraso';
//                }
//
//                $monthlyData[] = [
//                    'month' => $monthName,
//                    'year' => $currentYear,
//                    'fee_names' => $this->getFeeNamesForMonth($filteredFeeStructures, $monthName),
//                    'due_date' => $calculation['due_date'] ? $calculation['due_date']->format('d/m/Y') : 'N/A',
//                    'status' => $status,
//                    'base_amount' => $calculation['base_amount'],
//                    'fine_amount' => $calculation['fine_amount'],
//                    'total_expected' => $calculation['total_amount'],
//                    'discount_applied' => $isPaid ? $existingPayment->discount : 0,
//                    'paid_amount' => $paidAmount,
//                    'balance_amount' => $balanceAmount,
//                    'payment_date' => $isPaid ? $existingPayment->created_at->format('d/m/Y') : 'N/A',
//                    'is_paid' => $isPaid,
//                    'is_overdue' => $calculation['is_late_payment'],
//                    'existing_payment' => $existingPayment,
//                    'data_status' => $isPaid ? 'paid' : ($calculation['is_late_payment'] ? 'overdue' : 'pending')
//                ];
//
//                // Atualiza totais
//                $totalExpected += $calculation['total_amount'];
//                if ($isPaid) {
//                    $totalPaid += $paidAmount;
//                } else {
//                    if ($calculation['is_late_payment']) {
//                        $totalOverdue += $calculation['total_amount'];
//                    } else {
//                        $totalPending += $calculation['total_amount'];
//                    }
//                }
//
//            } catch (\Exception $e) {
//                \Log::error('Error calculating month data', [
//                    'month' => $monthName,
//                    'year' => $currentYear,
//                    'student_id' => $this->studentId,
//                    'error' => $e->getMessage()
//                ]);
//
//                // Dados de fallback para meses com erro
//                $monthlyData[] = [
//                    'month' => $monthName,
//                    'year' => $currentYear,
//                    'fee_names' => 'Taxa Escolar',
//                    'due_date' => 'N/A',
//                    'status' => 'Erro',
//                    'base_amount' => 0,
//                    'fine_amount' => 0,
//                    'total_expected' => 0,
//                    'discount_applied' => 0,
//                    'paid_amount' => 0,
//                    'balance_amount' => 0,
//                    'payment_date' => 'N/A',
//                    'is_paid' => false,
//                    'is_overdue' => false,
//                    'existing_payment' => null,
//                    'data_status' => 'error'
//                ];
//            }
//        }
//
//        // Busca pagamentos existentes (para compatibilidade)
//        $fees = Fee_assign::where('student_id', $this->studentId)
//                         ->orderBy('created_at', 'desc')
//                         ->get()
//                         ->map(function ($fee) {
//                             $fee->total_expected = $fee->amount + $fee->fine - $fee->discount;
//                             $fee->has_fine = $fee->fine > 0;
//                             $fee->fine_percentage = $fee->amount > 0 ? round(($fee->fine / $fee->amount) * 100, 1) : 0;
//                             $fee->payment_status = 'complete';
//                             return $fee;
//                         });
//
//        $discounts = discount::where('student_id', $this->studentId)->get();
//
//        return view('livewire.admin.fee.fee-collection', [
//            'student' => $this->selectedStudent,
//            'fees' => $fees,
//            'fee' => $this->calculatedTotal,
//            'feestructures' => $filteredFeeStructures,
//            'discounts' => $discounts,
//            'calculatedBaseFee' => $this->calculatedBaseFee,
//            'calculatedFine' => $this->calculatedFine,
//            'calculatedTotal' => $this->calculatedTotal,
//            'isLatePayment' => $this->isLatePayment,
//            'dueDate' => $this->dueDate,
//
//            // NOVOS DADOS PARA A TABELA
//            'monthlyData' => $monthlyData,
//            'yearSummary' => [
//                'total_expected' => $totalExpected,
//                'total_paid' => $totalPaid,
//                'total_pending' => $totalPending,
//                'total_overdue' => $totalOverdue,
//                'current_year' => $currentYear
//            ],
//            'selectedYear' => $this->selectedYear // ✅ PASSAR PARA A VIEW
//        ]);
//    }
//
//    private function getFeeNamesForMonth($feeStructures, $month)
//    {
//        $names = [];
//        foreach ($feeStructures as $structure) {
//            if (empty($structure->months) || in_array($month, explode(',', $structure->months))) {
//                $names[] = $structure->fee_name ?? 'Taxa Escolar';
//            }
//        }
//        return empty($names) ? 'Taxa Escolar' : implode(', ', array_unique($names));
//    }
//
//    public function openModal($feeAssignId, $amount, $month, $year)
//    {
//        $this->selectedFeeAssignId = $feeAssignId;
//        $this->month = (string) $month;
//        $this->year = (int) $year;
//
//        // Recalcula com os novos parâmetros
//        $this->calculateCurrentFee();
//
//        $this->dispatchBrowserEvent('openModal');
//        $this->emit('openModal', $feeAssignId, $amount, $month, $year);
//    }
//
//    // Métodos auxiliares para a interface (MANTIDOS INALTERADOS)
//    public function setMonth($month)
//    {
//        $this->month = $month;
//        $this->calculateCurrentFee();
//    }
//
//    public function setYear($year)
//    {
//        $this->year = $year;
//        $this->calculateCurrentFee();
//    }
//
//    public function addFine($amount)
//    {
//        $this->fine += $amount;
//        $this->calculateCurrentFee();
//    }
//
//    public function addDiscount($amount)
//    {
//        $this->discount += $amount;
//        $this->calculateCurrentFee();
//    }
//
//    public function resetCalculation()
//    {
//        $this->fine = 0;
//        $this->discount = 0;
//        $this->month = null;
//        $this->year = null;
//        $this->calculateCurrentFee();
//    }
//
//    // Método para verificar se pagamento já existe
//    public function checkExistingPayment($month, $year)
//    {
//        return $this->feeCalculationService->hasPaymentForPeriod(
//            $this->selectedStudent,
//            $month,
//            $year
//        );
//    }
//
//    // Propriedade computada para exibir detalhes do cálculo
//    public function getCalculationDetailsProperty()
//    {
//        return [
//            'base_fee' => $this->calculatedBaseFee,
//            'calculated_auto_fine' => max(0, $this->calculatedFine - (float)$this->fine),
//            'manual_fine' => (float)$this->fine,
//            'total_fine' => $this->calculatedFine,
//            'discount' => (float)$this->discount,
//            'total' => $this->calculatedTotal,
//            'is_late' => $this->isLatePayment,
//            'due_date' => $this->dueDate?->format('d/m/Y'),
//            'month' => $this->month ?: 'Current',
//            'year' => $this->year ?: date('Y'),
//            'preservation_note' => 'As multas são preservadas no histórico para auditoria completa'
//        ];
//    }
//}


namespace App\Http\Livewire\Admin\Fee;

use App\Models\Fee_assign;
use App\Models\User;
use App\Services\FeeCalculationService;
use Livewire\Component;
use App\Models\FeeStructure;
use Carbon\Carbon;
use App\Models\FeesDiscount as discount;
use Maatwebsite\Excel\Facades\Excel;
use Barryvdh\DomPDF\Facade\Pdf;
use Illuminate\Support\Facades\Response;
use Maatwebsite\Excel\Concerns\ShouldAutoSize;

class FeeCollection extends Component
{
    public $studentId;
    public $feeGroup;
    public $date;
    public $amount;
    public $discountGroup;
    public $discount = 0;
    public $fine = 0;
    public $paymentMode = 'Cash';
    public $note;
    public $students = [];
    public $selectedStudent;
    public $selectedFee;
    public $selectedFeeAssignId;
    public $month;
    public $year;
    public $calculatedBaseFee = 0;
    public $calculatedFine = 0;
    public $calculatedTotal = 0;
    public $isLatePayment = false;
    public $dueDate = null;
    public $selectedYear;

    protected $feeCalculationService;

    public function boot(FeeCalculationService $feeCalculationService)
    {
        $this->feeCalculationService = $feeCalculationService;
    }

    public function mount($studentId)
    {
        $this->studentId = $studentId ? $studentId : "cpmc-1218";
        $this->selectedStudent = User::findOrFail($studentId);
        $this->date = now()->format('d/m/Y');
        $this->selectedYear = now()->year;
        $this->calculateCurrentFee();
    }

    public function updated($propertyName)
    {
        if (in_array($propertyName, ['month', 'year', 'discount', 'fine'])) {
            $this->calculateCurrentFee();
        }
    }

    public function calculateCurrentFee()
    {
        if (!$this->selectedStudent) {
            return;
        }

        try {
            $calculation = $this->feeCalculationService->calculateFeeForStudent(
                $this->selectedStudent,
                $this->month,
                $this->year ? (int)$this->year : null
            );

            $this->calculatedBaseFee = $calculation['base_amount'];
            $this->calculatedFine = $calculation['fine_amount'] + (float)$this->fine;
            $this->calculatedTotal = $calculation['base_amount'] + $this->calculatedFine - (float)$this->discount;
            $this->isLatePayment = $calculation['is_late_payment'];
            $this->dueDate = $calculation['due_date'];
            $this->amount = max(0, $this->calculatedTotal);

            $this->emit('feeCalculated', [
                'baseFee' => $this->calculatedBaseFee,
                'autoFine' => $calculation['fine_amount'],
                'manualFine' => (float)$this->fine,
                'totalFine' => $this->calculatedFine,
                'total' => $this->calculatedTotal,
                'isLate' => $this->isLatePayment,
                'dueDate' => $this->dueDate?->format('d/m/Y')
            ]);

        } catch (\Exception $e) {
            \Log::error('Error calculating fee', [
                'student_id' => $this->studentId,
                'month' => $this->month,
                'year' => $this->year,
                'error' => $e->getMessage()
            ]);
            $this->fallbackCalculation();
        }
    }

    private function fallbackCalculation()
    {
        $studentClassroom = $this->selectedStudent->class->class ?? $this->selectedStudent->classroom->class ?? null;
        
        if (!$studentClassroom) {
            $this->calculatedBaseFee = 0;
            $this->calculatedFine = (float)$this->fine;
            $this->calculatedTotal = (float)$this->fine - (float)$this->discount;
            return;
        }

        $feeStructures = FeeStructure::where('active', 1)->get();
        $filteredFeeStructures = [];

        foreach ($feeStructures as $feeStructure) {
            $gradesArray = explode(',', $feeStructure->grades);
            if (in_array($studentClassroom, $gradesArray)) {
                $filteredFeeStructures[] = $feeStructure;
            }
        }

        $baseFee = 0;
        foreach ($filteredFeeStructures as $feeStructure) {
            $baseFee += $feeStructure->monthly_fee;
        }

        $this->calculatedBaseFee = $baseFee;
        $this->calculatedFine = (float)$this->fine;
        $this->calculatedTotal = $baseFee + (float)$this->fine - (float)$this->discount;
        $this->amount = max(0, $this->calculatedTotal);
    }

    public function collectFee()
    {
        $this->validate([
            'amount' => 'required|numeric|min:0',
            'discount' => 'numeric|min:0',
            'fine' => 'numeric|min:0',
            'paymentMode' => 'required',
        ]);

        try {
            $paymentData = [
                'month' => $this->month ?: date('F'),
                'year' => $this->year ?: date('Y'),
                'amount' => (float)$this->amount,
                'fine' => (float)$this->fine,
                'discount' => (float)$this->discount,
                'payment_mode' => $this->paymentMode,
                'paymentMode' => $this->paymentMode,
                'pay_type' => 'cash',
                'note' => $this->note,
                'payment_date' => now()
            ];

            $feeAssign = $this->feeCalculationService->createFeePayment(
                $this->selectedStudent,
                $paymentData
            );

            session()->flash('message', 'Pagamento de taxa/propina efetuado com sucesso. Multa preservada no histórico.');

            \Log::info('Admin fee payment collected', [
                'student_id' => $this->studentId,
                'fee_assign_id' => $feeAssign->id,
                'payment_mode' => $this->paymentMode,
                'total_paid' => $this->amount,
                'base_calculated' => $this->calculatedBaseFee,
                'fine_preserved' => $feeAssign->fine,
                'discount_applied' => $this->discount,
                'is_late_payment' => $this->isLatePayment,
                'month' => $this->month,
                'year' => $this->year
            ]);

            $this->dispatchBrowserEvent('closeModal');
            $this->reset(['amount', 'discount', 'fine', 'paymentMode', 'note']);
            $this->calculateCurrentFee();

        } catch (\Exception $e) {
            \Log::error('Error collecting fee', [
                'student_id' => $this->studentId,
                'error' => $e->getMessage(),
                'trace' => $e->getTraceAsString()
            ]);
            session()->flash('error', 'Erro ao processar pagamento: ' . $e->getMessage());
        }
    }
    
    
    

        
        // ✅ MÉTODO EXPORTEXCEL COMPLETO - VERSÃO FINAL

//        public function exportExcel()
//        {
//            try {
//                $data = $this->getExportDataForTable();
//                
//                return Excel::download(new class($data) implements
//                    \Maatwebsite\Excel\Concerns\FromArray,
//                    \Maatwebsite\Excel\Concerns\WithHeadings,
//                    \Maatwebsite\Excel\Concerns\WithStyles,
//                    \Maatwebsite\Excel\Concerns\WithTitle,
//                    \Maatwebsite\Excel\Concerns\WithProperties,
//                    \Maatwebsite\Excel\Concerns\ShouldAutoSize,
//                    \Maatwebsite\Excel\Concerns\WithEvents,
//                    \Maatwebsite\Excel\Concerns\WithColumnWidths {
//                    
//                    private $data;
//                    
//                    public function __construct($data) {
//                        $this->data = $data;
//                    }
//                    
//                    public function array(): array {
//                        $rows = [];
//                        
//                        // ✅ CABEÇALHO COMPACTO PARA MOBILE
//                        $rows[] = ['CPMC - EXTRATO DE MENSALIDADES ' . $this->data['year']];
//                        $rows[] = [''];
//                        
//                        // ✅ INFO ESTUDANTE EM FORMATO COMPACTO
//                        $rows[] = [
//                            'Estudante: ' . $this->data['student']->name,
//                            'ID: ' . $this->data['student']->student_id,
//                            'Classe: ' . ($this->data['student']->class->class ?? 'N/A'),
//                            'Gerado: ' . now()->format('d/m/Y H:i')
//                        ];
//                        $rows[] = [''];
//                        
//                        // ✅ RESUMO VISUAL COMPACTO
//                        $totalPago = $this->data['summary']['total_net_received'];
//                        $totalEsperado = $this->data['summary']['total_annual_value'];
//                        $percentual = $totalEsperado > 0 ? round(($totalPago / $totalEsperado) * 100, 1) : 0;
//                        
//                        $rows[] = [
//                            '💰 Total Pago: MT ' . number_format($totalPago, 2, ',', '.'),
//                            '📊 Total Esperado: MT ' . number_format($totalEsperado, 2, ',', '.'),
//                            '📈 Progresso: ' . $percentual . '%',
//                            ''
//                        ];
//                        $rows[] = [''];
//                        
//                        // ✅ CABEÇALHO DA TABELA OTIMIZADO
//                        $rows[] = [
//                            'Período',
//                            'Tipo de Taxa',
//                            'Vencimento',
//                            'Status',
//                            'Valor Base (MT)',
//                            'Multa (MT)',
//                            'Desconto (MT)',
//                            'Valor Pago (MT)',
//                            'Data Pagamento'
//                        ];
//                        
//                        // ✅ DADOS DAS MENSALIDADES COM FORMATAÇÃO MOBILE-FRIENDLY
//                        foreach ($this->data['monthlyData'] as $monthData) {
//                            // Formatar período de forma mais compacta
//                            $periodo = $this->formatPeriodoCompacto($monthData['month'], $monthData['year']);
//                            
//                            // Simplificar nome das taxas
//                            $tipoTaxa = $this->simplificarTipoTaxa($monthData['fee_names']);
//                            
//                            // Status com emoji para fácil identificação
//                            $statusFormatado = $this->formatarStatusComEmoji($monthData['status']);
//                            
//                            // Data de pagamento mais compacta
//                            $dataPagamento = $monthData['payment_date'] !== '--' && $monthData['payment_date'] !== 'N/A'
//                                ? $this->formatarDataCompacta($monthData['payment_date'])
//                                : '--';
//                            
//                            $rows[] = [
//                                $periodo,
//                                $tipoTaxa,
//                                $monthData['due_date'],
//                                $statusFormatado,
//                                number_format($monthData['base_amount'], 2, ',', '.'),
//                                number_format($monthData['fine_amount'], 2, ',', '.'),
//                                number_format($monthData['discount_applied'], 2, ',', '.'),
//                                number_format($monthData['paid_amount'], 2, ',', '.'),
//                                $dataPagamento
//                            ];
//                        }
//                        
//                        // ✅ LINHA DE SEPARAÇÃO
//                        $rows[] = [''];
//                        
//                        // ✅ TOTAIS DESTACADOS
//                        $rows[] = [
//                            '📊 TOTAIS:',
//                            '',
//                            '',
//                            '',
//                            'MT ' . number_format($this->data['summary']['total_annual_value'], 2, ',', '.'),
//                            'MT ' . number_format($this->data['summary']['total_fines_paid'], 2, ',', '.'),
//                            'MT ' . number_format($this->data['summary']['total_discounts_given'], 2, ',', '.'),
//                            'MT ' . number_format($this->data['summary']['total_net_received'], 2, ',', '.'),
//                            ''
//                        ];
//                        
//                        // ✅ ESTATÍSTICAS RÁPIDAS
//                        $mesesPagos = $this->data['summary']['months_paid_count'];
//                        $mesesComTaxas = max($this->data['summary']['months_with_fees'], $mesesPagos);
//                        $taxaCumprimento = $this->data['summary']['payment_rate'];
//                        
//                        $rows[] = [''];
//                        $rows[] = [
//                            '📈 ESTATÍSTICAS:',
//                            "✅ Pagos: {$mesesPagos}/{$mesesComTaxas} meses",
//                            "📊 Taxa de Cumprimento: {$taxaCumprimento}%",
//                            ''
//                        ];
//                        
//                        // ✅ NOTAS IMPORTANTES
//                        $rows[] = [''];
//                        $rows[] = ['📝 OBSERVAÇÕES IMPORTANTES:'];
//                        $rows[] = ['• Valores em Meticais (MT)'];
//                        $rows[] = ['• ✅ = Pago | ⏰ = Em Atraso | ⏳ = Pendente'];
//                        $rows[] = ['• Para dúvidas: contacte a secretaria acadêmica'];
//                        $rows[] = ['• Documento gerado automaticamente em ' . now()->format('d/m/Y H:i:s')];
//                        
//                        return $rows;
//                    }
//                    
//                    // ✅ MÉTODOS AUXILIARES PARA FORMATAÇÃO MOBILE-FRIENDLY
//                    private function formatPeriodoCompacto($month, $year) {
//                        $mesesPt = [
//                            'January' => 'Jan', 'February' => 'Fev', 'March' => 'Mar',
//                            'April' => 'Abr', 'May' => 'Mai', 'June' => 'Jun',
//                            'July' => 'Jul', 'August' => 'Ago', 'September' => 'Set',
//                            'October' => 'Out', 'November' => 'Nov', 'December' => 'Dez'
//                        ];
//                        
//                        return ($mesesPt[$month] ?? $month) . ' ' . $year;
//                    }
//                    
//                    private function simplificarTipoTaxa($feeNames) {
//                        if (stripos($feeNames, 'propina') !== false) return 'Propina';
//                        if (stripos($feeNames, 'transporte') !== false) return 'Transporte';
//                        if (stripos($feeNames, 'alimentacao') !== false) return 'Alimentação';
//                        if (stripos($feeNames, 'alimentação') !== false) return 'Alimentação';
//                        if (stripos($feeNames, 'material') !== false) return 'Material';
//                        if (stripos($feeNames, 'matricula') !== false) return 'Matrícula';
//                        if (stripos($feeNames, 'matrícula') !== false) return 'Matrícula';
//                        return 'Taxa Escolar';
//                    }
//                    
//                    private function formatarStatusComEmoji($status) {
//                        switch ($status) {
//                            case 'Pago': return '✅ Pago';
//                            case 'Em Atraso': return '⏰ Em Atraso';
//                            case 'Não Pago': return '⏳ Pendente';
//                            default: return '❓ ' . $status;
//                        }
//                    }
//                    
//                    private function formatarDataCompacta($dataCompleta) {
//                        // Converte "18/08/2025 19:13" para "18/08 19:13"
//                        if (preg_match('/(\d{2})\/(\d{2})\/(\d{4})\s+(\d{2}:\d{2})/', $dataCompleta, $matches)) {
//                            return $matches[1] . '/' . $matches[2] . ' ' . $matches[4];
//                        }
//                        return $dataCompleta;
//                    }
//                    
//                    public function headings(): array {
//                        return [];
//                    }
//                    
//                    public function title(): string {
//                        return 'Mensalidades ' . $this->data['year'];
//                    }
//                    
//                    public function properties(): array {
//                        return [
//                            'creator' => 'Sistema CPMC',
//                            'title' => 'Extrato Mensalidades - ' . $this->data['student']->name,
//                            'description' => 'Extrato completo otimizado para visualização móvel',
//                            'subject' => 'Mensalidades',
//                            'company' => 'CPMC',
//                        ];
//                    }
//                    
//                    // ✅ LARGURAS OTIMIZADAS PARA MOBILE
//                    public function columnWidths(): array {
//                        return [
//                            'A' => 12,  // Período
//                            'B' => 15,  // Tipo Taxa
//                            'C' => 12,  // Vencimento
//                            'D' => 15,  // Status
//                            'E' => 14,  // Valor Base
//                            'F' => 12,  // Multa
//                            'G' => 12,  // Desconto
//                            'H' => 14,  // Valor Pago
//                            'I' => 14,  // Data Pagamento
//                        ];
//                    }
//                    
//                    public function styles(\PhpOffice\PhpSpreadsheet\Worksheet\Worksheet $sheet) {
//                        $dataRowStart = 7; // Linha onde começam os dados
//                        $dataRowEnd = $dataRowStart + count($this->data['monthlyData']) - 1;
//                        $totalsRow = $dataRowEnd + 2;
//                        
//                        return [
//                            // ✅ TÍTULO PRINCIPAL - DESIGN MOBILE
//                            1 => [
//                                'font' => ['bold' => true, 'size' => 14, 'color' => ['rgb' => '1565C0']],
//                                'alignment' => ['horizontal' => 'center'],
//                                'fill' => [
//                                    'fillType' => \PhpOffice\PhpSpreadsheet\Style\Fill::FILL_SOLID,
//                                    'color' => ['rgb' => 'E3F2FD']
//                                ]
//                            ],
//                            
//                            // ✅ INFO ESTUDANTE
//                            3 => [
//                                'font' => ['bold' => true, 'size' => 10],
//                                'fill' => [
//                                    'fillType' => \PhpOffice\PhpSpreadsheet\Style\Fill::FILL_SOLID,
//                                    'color' => ['rgb' => 'F8F9FA']
//                                ]
//                            ],
//                            
//                            // ✅ RESUMO COM EMOJIS
//                            5 => [
//                                'font' => ['bold' => true, 'size' => 11, 'color' => ['rgb' => '2E7D32']],
//                                'fill' => [
//                                    'fillType' => \PhpOffice\PhpSpreadsheet\Style\Fill::FILL_SOLID,
//                                    'color' => ['rgb' => 'E8F5E9']
//                                ]
//                            ],
//                            
//                            // ✅ CABEÇALHO DA TABELA - DESIGN MODERNO
//                            $dataRowStart => [
//                                'font' => ['bold' => true, 'color' => ['rgb' => 'FFFFFF'], 'size' => 10],
//                                'fill' => [
//                                    'fillType' => \PhpOffice\PhpSpreadsheet\Style\Fill::FILL_SOLID,
//                                    'color' => ['rgb' => '1565C0']
//                                ],
//                                'alignment' => ['horizontal' => 'center', 'vertical' => 'center'],
//                                'borders' => [
//                                    'allBorders' => [
//                                        'borderStyle' => \PhpOffice\PhpSpreadsheet\Style\Border::BORDER_THIN,
//                                        'color' => ['rgb' => '0D47A1']
//                                    ]
//                                ]
//                            ],
//                            
//                            // ✅ DADOS DA TABELA
//                            ($dataRowStart + 1) . ':' . $dataRowEnd => [
//                                'font' => ['size' => 9],
//                                'alignment' => ['horizontal' => 'center', 'vertical' => 'center'],
//                                'borders' => [
//                                    'allBorders' => [
//                                        'borderStyle' => \PhpOffice\PhpSpreadsheet\Style\Border::BORDER_THIN,
//                                        'color' => ['rgb' => 'E0E0E0']
//                                    ]
//                                ]
//                            ],
//                            
//                            // ✅ LINHA DE TOTAIS
//                            $totalsRow => [
//                                'font' => ['bold' => true, 'size' => 11, 'color' => ['rgb' => '1565C0']],
//                                'fill' => [
//                                    'fillType' => \PhpOffice\PhpSpreadsheet\Style\Fill::FILL_SOLID,
//                                    'color' => ['rgb' => 'FFF3E0']
//                                ],
//                                'borders' => [
//                                    'allBorders' => [
//                                        'borderStyle' => \PhpOffice\PhpSpreadsheet\Style\Border::BORDER_MEDIUM,
//                                        'color' => ['rgb' => 'FF9800']
//                                    ]
//                                ]
//                            ],
//                            
//                            // ✅ ESTATÍSTICAS
//                            ($totalsRow + 2) => [
//                                'font' => ['bold' => true, 'size' => 10, 'color' => ['rgb' => '4CAF50']],
//                                'fill' => [
//                                    'fillType' => \PhpOffice\PhpSpreadsheet\Style\Fill::FILL_SOLID,
//                                    'color' => ['rgb' => 'F1F8E9']
//                                ]
//                            ],
//                            
//                            // ✅ COLUNAS DE VALORES - FORMATAÇÃO MONETÁRIA
//                            'E:H' => [
//                                'font' => ['bold' => true],
//                                'numberFormat' => [
//                                    'formatCode' => '#,##0.00'
//                                ]
//                            ],
//                            
//                            // ✅ OBSERVAÇÕES
//                            ($totalsRow + 4) . ':' . ($totalsRow + 10) => [
//                                'font' => ['size' => 8, 'italic' => true],
//                                'fill' => [
//                                    'fillType' => \PhpOffice\PhpSpreadsheet\Style\Fill::FILL_SOLID,
//                                    'color' => ['rgb' => 'FAFAFA']
//                                ]
//                            ]
//                        ];
//                    }
//                    
//                    public function registerEvents(): array {
//                        return [
//                            \Maatwebsite\Excel\Events\AfterSheet::class => function(\Maatwebsite\Excel\Events\AfterSheet $event) {
//                                $sheet = $event->sheet->getDelegate();
//                                
//                                // ✅ MERGE TÍTULO PRINCIPAL
//                                $sheet->mergeCells('A1:I1');
//                                
//                                // ✅ ALTURA DAS LINHAS OTIMIZADA PARA MOBILE
//                                $sheet->getRowDimension(1)->setRowHeight(25); // Título
//                                $sheet->getRowDimension(7)->setRowHeight(20); // Cabeçalho
//                                
//                                // ✅ CONGELAMENTO INTELIGENTE
//                                $sheet->freezePane('A8'); // Congela após cabeçalho
//                                
//                                // ✅ APLICAR CORES POR STATUS COM EMOJIS
//                                $dataRowStart = 8; // Primeira linha de dados
//                                foreach ($this->data['monthlyData'] as $index => $monthData) {
//                                    $rowNumber = $dataRowStart + $index;
//                                    $status = $monthData['status'];
//                                    
//                                    // Cores mais suaves para mobile
//                                    $fillColor = 'FFFFFF';
//                                    $fontColor = '000000';
//                                    
//                                    if ($status === 'Pago') {
//                                        $fillColor = 'C8E6C9'; // Verde suave
//                                        $fontColor = '1B5E20';
//                                    } elseif ($status === 'Em Atraso') {
//                                        $fillColor = 'FFCDD2'; // Vermelho suave
//                                        $fontColor = 'B71C1C';
//                                    } elseif ($status === 'Não Pago') {
//                                        $fillColor = 'FFF9C4'; // Amarelo suave
//                                        $fontColor = 'E65100';
//                                    }
//                                    
//                                    // Aplicar cor à linha inteira para melhor visualização
//                                    $sheet->getStyle("A{$rowNumber}:I{$rowNumber}")->applyFromArray([
//                                        'fill' => [
//                                            'fillType' => \PhpOffice\PhpSpreadsheet\Style\Fill::FILL_SOLID,
//                                            'color' => ['rgb' => $fillColor]
//                                        ]
//                                    ]);
//                                    
//                                    // Destacar coluna de status
//                                    $sheet->getStyle("D{$rowNumber}")->applyFromArray([
//                                        'font' => [
//                                            'bold' => true,
//                                            'color' => ['rgb' => $fontColor]
//                                        ]
//                                    ]);
//                                }
//                                
//                                // ✅ BORDAS PROFISSIONAIS PARA TABELA
//                                $dataRowEnd = $dataRowStart + count($this->data['monthlyData']) - 1;
//                                $tableRange = "A7:I{$dataRowEnd}";
//                                $sheet->getStyle($tableRange)->applyFromArray([
//                                    'borders' => [
//                                        'outline' => [
//                                            'borderStyle' => \PhpOffice\PhpSpreadsheet\Style\Border::BORDER_MEDIUM,
//                                            'color' => ['rgb' => '1565C0']
//                                        ]
//                                    ]
//                                ]);
//                                
//                                // ✅ AUTO-AJUSTE FINAL
//                                foreach (range('A', 'I') as $column) {
//                                    $sheet->getColumnDimension($column)->setAutoSize(false);
//                                }
//                            }
//                        ];
//                    }
//                    
//                }, "mensalidades_{$this->selectedStudent->student_id}_{$this->selectedYear}.xlsx");
//                
//                session()->flash('message', 'Excel exportado com sucesso! Mostra todos os pagamentos reais.');
//                
//            } catch (\Exception $e) {
//                \Log::error('Excel export failed', [
//                    'error' => $e->getMessage(),
//                    'trace' => $e->getTraceAsString()
//                ]);
//                session()->flash('error', 'Erro ao exportar Excel: ' . $e->getMessage());
//                return redirect()->back();
//            }
//        }
//
//        // ✅ MÉTODO GETEXPORTDATAFORTABLE COMPLETO - BUSCA PAGAMENTOS REAIS
//        private function getExportDataForTable()
//        {
//            $currentYear = $this->selectedYear ?? now()->year;
//            $months = [
//                'January', 'February', 'March', 'April', 'May', 'June',
//                'July', 'August', 'September', 'October', 'November', 'December'
//            ];
//
//            $studentClassroom = $this->selectedStudent->class->class ?? $this->selectedStudent->classroom->class ?? null;
//            $filteredFeeStructures = [];
//
//            if ($studentClassroom) {
//                $feeStructures = FeeStructure::where('active', 1)->get();
//                
//                foreach ($feeStructures as $feeStructure) {
//                    $gradesArray = explode(',', $feeStructure->grades);
//                    if (in_array($studentClassroom, $gradesArray)) {
//                        $filteredFeeStructures[] = $feeStructure;
//                    }
//                }
//            }
//
//            // ✅ BUSCAR TODOS OS PAGAMENTOS REAIS DO ESTUDANTE PARA O ANO
//            $pagamentosReais = Fee_assign::where('student_id', $this->studentId)
//                ->where('year', $currentYear)
//                ->get()
//                ->keyBy('month'); // Indexar por mês para fácil acesso
//
//            \Log::info('Pagamentos encontrados para Excel', [
//                'student_id' => $this->studentId,
//                'year' => $currentYear,
//                'pagamentos_count' => $pagamentosReais->count(),
//                'meses_pagos' => $pagamentosReais->keys()->toArray()
//            ]);
//
//            $monthlyData = [];
//            $summary = [
//                'total_annual_value' => 0,
//                'total_paid' => 0,
//                'total_fines_paid' => 0,
//                'total_discounts_given' => 0,
//                'total_net_received' => 0,
//                'months_with_fees' => 0,
//                'months_paid_count' => 0
//            ];
//
//            foreach ($months as $monthName) {
//                try {
//                    // ✅ PRIMEIRO: VERIFICAR SE EXISTE PAGAMENTO REAL
//                    $pagamentoReal = $pagamentosReais->get($monthName);
//                    $isPaid = !is_null($pagamentoReal);
//
//                    // ✅ CALCULAR VALORES ESPERADOS (PARA MESES NÃO PAGOS)
//                    $calculation = null;
//                    try {
//                        $calculation = $this->feeCalculationService->calculateFeeForStudent(
//                            $this->selectedStudent,
//                            $monthName,
//                            $currentYear
//                        );
//                    } catch (\Exception $e) {
//                        \Log::warning('Could not calculate fee for month', [
//                            'month' => $monthName,
//                            'year' => $currentYear,
//                            'error' => $e->getMessage()
//                        ]);
//                        
//                        // Fallback: usar valores básicos
//                        $calculation = [
//                            'base_amount' => 0,
//                            'fine_amount' => 0,
//                            'total_amount' => 0,
//                            'is_late_payment' => false,
//                            'due_date' => null
//                        ];
//                    }
//
//                    // ✅ SE NÃO TEM PAGAMENTO E NEM TAXA ESPERADA, PULAR
//                    if (!$isPaid && $calculation['base_amount'] <= 0) {
//                        continue;
//                    }
//
//                    // ✅ VALORES FINAIS (PRIORIZAR DADOS REAIS)
//                    if ($isPaid) {
//                        // Usar dados do pagamento real
//                        $baseAmount = $pagamentoReal->amount ?? 0;
//                        $fineAmount = $pagamentoReal->fine ?? 0;
//                        $discountAmount = $pagamentoReal->discount ?? 0;
//                        $netPaidAmount = $baseAmount + $fineAmount - $discountAmount;
//                        $paymentDate = $pagamentoReal->created_at->format('d/m/Y H:i');
//                        $status = 'Pago';
//                        
//                        // ✅ BUSCAR DATA DE VENCIMENTO MESMO PARA PAGOS
//                        $dueDate = 'N/A';
//                        if ($calculation && $calculation['due_date']) {
//                            $dueDate = $calculation['due_date']->format('d/m/Y');
//                        } else {
//                            // Fallback: calcular data de vencimento baseada nas estruturas
//                            foreach ($filteredFeeStructures as $feeStructure) {
//                                if (in_array($monthName, explode(',', $feeStructure->months))) {
//                                    $dueDateDay = $feeStructure->payment_due_day ?? 15;
//                                    $dueDate = \Carbon\Carbon::createFromDate($currentYear, array_search($monthName, $months) + 1, $dueDateDay)->format('d/m/Y');
//                                    break;
//                                }
//                            }
//                        }
//                        
//                    } else {
//                        // Usar dados calculados para não pagos
//                        $baseAmount = $calculation['base_amount'];
//                        $fineAmount = $calculation['fine_amount'];
//                        $discountAmount = 0;
//                        $netPaidAmount = 0;
//                        $paymentDate = '--';
//                        $dueDate = $calculation['due_date'] ? $calculation['due_date']->format('d/m/Y') : 'N/A';
//                        
//                        // Determinar status baseado na data de vencimento
//                        $status = 'Não Pago';
//                        if ($calculation['is_late_payment']) {
//                            $status = 'Em Atraso';
//                        }
//                    }
//
//                    // ✅ BUSCAR REFERÊNCIA REAL
//                    $referencia = $this->getPaymentReference($monthName, $currentYear);
//
//                    // ✅ NOME DAS TAXAS
//                    $feeNames = $this->getFeeNamesForMonth($filteredFeeStructures, $monthName);
//
//                    // ✅ ADICIONAR AOS DADOS
//                    $monthlyData[] = [
//                        'month' => $monthName,
//                        'year' => $currentYear,
//                        'reference' => $referencia,
//                        'fee_names' => $feeNames,
//                        'due_date' => $dueDate,
//                        'status' => $status,
//                        'base_amount' => $baseAmount,
//                        'fine_amount' => $fineAmount,
//                        'discount_applied' => $discountAmount,
//                        'paid_amount' => $netPaidAmount,
//                        'payment_date' => $paymentDate,
//                        'is_paid' => $isPaid,
//                        'is_overdue' => $calculation['is_late_payment'] ?? false,
//                        'real_payment' => $pagamentoReal // ✅ DADOS REAIS DO PAGAMENTO
//                    ];
//
//                    // ✅ ATUALIZAR RESUMO
//                    if ($baseAmount > 0) {
//                        $summary['total_annual_value'] += $baseAmount;
//                        $summary['months_with_fees']++;
//                    }
//                    
//                    if ($isPaid) {
//                        $summary['total_paid'] += $baseAmount;
//                        $summary['total_fines_paid'] += $fineAmount;
//                        $summary['total_discounts_given'] += $discountAmount;
//                        $summary['total_net_received'] += $netPaidAmount;
//                        $summary['months_paid_count']++;
//                    }
//
//                } catch (\Exception $e) {
//                    \Log::error('Error preparing export data for month', [
//                        'month' => $monthName,
//                        'year' => $currentYear,
//                        'student_id' => $this->studentId,
//                        'error' => $e->getMessage(),
//                        'trace' => $e->getTraceAsString()
//                    ]);
//                    
//                    // ✅ VERIFICAR SE PELO MENOS TEM PAGAMENTO REAL
//                    $pagamentoReal = $pagamentosReais->get($monthName);
//                    if ($pagamentoReal) {
//                        $monthlyData[] = [
//                            'month' => $monthName,
//                            'year' => $currentYear,
//                            'reference' => 'REF-ERRO-' . strtoupper(substr($monthName, 0, 3)) . $currentYear,
//                            'fee_names' => 'Taxa Escolar',
//                            'due_date' => 'N/A',
//                            'status' => 'Pago',
//                            'base_amount' => $pagamentoReal->amount ?? 0,
//                            'fine_amount' => $pagamentoReal->fine ?? 0,
//                            'discount_applied' => $pagamentoReal->discount ?? 0,
//                            'paid_amount' => ($pagamentoReal->amount ?? 0) + ($pagamentoReal->fine ?? 0) - ($pagamentoReal->discount ?? 0),
//                            'payment_date' => $pagamentoReal->created_at->format('d/m/Y H:i'),
//                            'is_paid' => true,
//                            'is_overdue' => false,
//                            'real_payment' => $pagamentoReal
//                        ];
//                        
//                        $summary['total_paid'] += $pagamentoReal->amount ?? 0;
//                        $summary['total_fines_paid'] += $pagamentoReal->fine ?? 0;
//                        $summary['total_discounts_given'] += $pagamentoReal->discount ?? 0;
//                        $summary['total_net_received'] += ($pagamentoReal->amount ?? 0) + ($pagamentoReal->fine ?? 0) - ($pagamentoReal->discount ?? 0);
//                        $summary['months_paid_count']++;
//                    }
//                    
//                    continue;
//                }
//            }
//
//            // ✅ VERIFICAR SE EXISTEM PAGAMENTOS QUE NÃO FORAM CAPTURADOS
//            $mesesProcessados = collect($monthlyData)->pluck('month')->toArray();
//            $pagamentosNaoCapturados = $pagamentosReais->filter(function($pagamento, $mes) use ($mesesProcessados) {
//                return !in_array($mes, $mesesProcessados);
//            });
//
//            if ($pagamentosNaoCapturados->count() > 0) {
//                \Log::warning('Pagamentos não capturados encontrados', [
//                    'student_id' => $this->studentId,
//                    'year' => $currentYear,
//                    'pagamentos_nao_capturados' => $pagamentosNaoCapturados->keys()->toArray()
//                ]);
//
//                // Adicionar pagamentos não capturados
//                foreach ($pagamentosNaoCapturados as $mes => $pagamento) {
//                    $monthlyData[] = [
//                        'month' => $mes,
//                        'year' => $currentYear,
//                        'reference' => $this->getPaymentReference($mes, $currentYear),
//                        'fee_names' => 'Taxa Escolar',
//                        'due_date' => 'N/A',
//                        'status' => 'Pago',
//                        'base_amount' => $pagamento->amount ?? 0,
//                        'fine_amount' => $pagamento->fine ?? 0,
//                        'discount_applied' => $pagamento->discount ?? 0,
//                        'paid_amount' => ($pagamento->amount ?? 0) + ($pagamento->fine ?? 0) - ($pagamento->discount ?? 0),
//                        'payment_date' => $pagamento->created_at->format('d/m/Y H:i'),
//                        'is_paid' => true,
//                        'is_overdue' => false,
//                        'real_payment' => $pagamento
//                    ];
//                    
//                    $summary['total_paid'] += $pagamento->amount ?? 0;
//                    $summary['total_fines_paid'] += $pagamento->fine ?? 0;
//                    $summary['total_discounts_given'] += $pagamento->discount ?? 0;
//                    $summary['total_net_received'] += ($pagamento->amount ?? 0) + ($pagamento->fine ?? 0) - ($pagamento->discount ?? 0);
//                    $summary['months_paid_count']++;
//                }
//            }
//
//            // ✅ ORDENAR POR MÊS
//            usort($monthlyData, function($a, $b) use ($months) {
//                $indexA = array_search($a['month'], $months);
//                $indexB = array_search($b['month'], $months);
//                return $indexA <=> $indexB;
//            });
//
//            $summary['payment_rate'] = $summary['months_with_fees'] > 0
//                ? round(($summary['months_paid_count'] / max($summary['months_with_fees'], $summary['months_paid_count'])) * 100, 1)
//                : 0;
//
//            \Log::info('Export data prepared', [
//                'student_id' => $this->studentId,
//                'year' => $currentYear,
//                'total_months_in_data' => count($monthlyData),
//                'months_paid' => $summary['months_paid_count'],
//                'total_net_received' => $summary['total_net_received']
//            ]);
//
//            return [
//                'monthlyData' => $monthlyData,
//                'summary' => $summary,
//                'student' => $this->selectedStudent,
//                'year' => $currentYear
//            ];
//        }
//
//        // ✅ MÉTODO AUXILIAR: BUSCAR REFERÊNCIA REAL DO SISTEMA
//        private function getPaymentReference($month, $year)
//        {
//            try {
//                // ✅ BUSCA REFERÊNCIA REAL NA TABELA payment_references
//                $paymentReference = \App\Models\PaymentReference::where('student_id', $this->studentId)
//                    ->where('fee_month', $month)
//                    ->where('fee_year', $year)
//                    ->whereNotNull('reference_number')
//                    ->first();
//                    
//                if ($paymentReference) {
//                    return $paymentReference->reference_number;
//                }
//                
//                // ✅ SE NÃO EXISTE PARA ESTE MÊS, BUSCA QUALQUER DO ANO E ADAPTA
//                $anyReferenceThisYear = \App\Models\PaymentReference::where('student_id', $this->studentId)
//                    ->where('fee_year', $year)
//                    ->whereNotNull('reference_number')
//                    ->first();
//                    
//                if ($anyReferenceThisYear) {
//                    // Modifica os últimos 2 dígitos para representar o mês
//                    $monthNumber = array_search($month, [
//                        'January', 'February', 'March', 'April', 'May', 'June',
//                        'July', 'August', 'September', 'October', 'November', 'December'
//                    ]) + 1;
//                    
//                    $baseRef = $anyReferenceThisYear->reference_number;
//                    
//                    // Se a referência tem 11 dígitos (padrão comum)
//                    if (strlen($baseRef) == 11) {
//                        return substr($baseRef, 0, 9) . str_pad($monthNumber, 2, '0', STR_PAD_LEFT);
//                    }
//                    
//                    // Senão, adiciona mês no final
//                    return $baseRef . str_pad($monthNumber, 2, '0', STR_PAD_LEFT);
//                }
//                
//                // ✅ ÚLTIMO RECURSO: MARCA COMO "SEM REFERÊNCIA"
//                return 'REF-PENDENTE-' . strtoupper(substr($month, 0, 3)) . $year;
//                
//            } catch (\Exception $e) {
//                \Log::error('Error getting payment reference', [
//                    'student_id' => $this->studentId,
//                    'month' => $month,
//                    'year' => $year,
//                    'error' => $e->getMessage()
//                ]);
//                
//                return 'REF-ERRO-' . strtoupper(substr($month, 0, 3)) . $year;
//            }
//        }
   
//
        
    
    
    
    
    
    
    
    
    
    // ✅ MÉTODO AUXILIAR: OBTER NOMES DAS TAXAS PARA O MÊS
        private function getFeeNamesForMonth($feeStructures, $month)
        {
            $names = [];
            foreach ($feeStructures as $structure) {
                if (empty($structure->months) || in_array($month, explode(',', $structure->months))) {
                    $names[] = $structure->fee_name ?? 'Taxa Escolar';
                }
            }
            return empty($names) ? 'Taxa Escolar' : implode(', ', array_unique($names));
        }

   

    
    // ✅ MÉTODO EXPORTEXCEL COMPLETO MAS OTIMIZADO

    public function exportExcel()
    {
        try {
            $data = $this->getExportDataComplete();
            
            return Excel::download(new class($data) implements
                \Maatwebsite\Excel\Concerns\FromArray,
                \Maatwebsite\Excel\Concerns\WithStyles,
                \Maatwebsite\Excel\Concerns\WithTitle,
                \Maatwebsite\Excel\Concerns\WithColumnWidths,
                \Maatwebsite\Excel\Concerns\WithEvents {
                
                private $data;
                
                public function __construct($data) {
                    $this->data = $data;
                }
                
                public function array(): array {
                    $rows = [];
                    
                    // ✅ CABEÇALHO COMPLETO
                    $rows[] = ['COPMOZ - EXTRATO DE MENSALIDADES ' . $this->data['year']];
                    $rows[] = [''];
                    
                    // ✅ INFO ESTUDANTE
                    $rows[] = [
                        'Estudante: ' . $this->data['student']->name,
                        'ID: ' . $this->data['student']->student_id,
                         ($this->data['student']->class->class ?? 'N/A') . ' Classe - Turma:  ' . ($this->data['student']->class->name ?? 'N/A'),
                        'Gerado: ' . now()->format('d/m/Y H:i')
                    ];
                    $rows[] = [''];
                    
                    // ✅ RESUMO FINANCEIRO
                    $totalPago = $this->data['summary']['total_net_received'];
                    $totalEsperado = $this->data['summary']['total_annual_value'];
                    $percentual = $totalEsperado > 0 ? round(($totalPago / $totalEsperado) * 100, 1) : 0;
                    
                    $rows[] = [
                        '💰 Total Pago: MT ' . number_format($totalPago, 2, ',', '.'),
                        '📊 Total Esperado: MT ' . number_format($totalEsperado, 2, ',', '.'),
                        '📈 Progresso: ' . $percentual . '%',
                        ''
                    ];
                    $rows[] = [''];
                    
                    // ✅ CABEÇALHO DA TABELA
                    $rows[] = [
                        'Período',
                        'Tipo de Taxa',
                        'Vencimento',
                        'Status',
                        'Valor Base (MT)',
                        'Multa (MT)',
                        'Desconto (MT)',
                        'Valor Pago (MT)',
                        'Data Pagamento'
                    ];
                    
                    // ✅ DADOS DAS MENSALIDADES
                    foreach ($this->data['monthlyData'] as $monthData) {
                        $periodo = $this->formatPeriodoCompacto($monthData['month'], $monthData['year']);
                        $tipoTaxa = $this->simplificarTipoTaxa($monthData['fee_names']);
                        $statusFormatado = $this->formatarStatusComEmoji($monthData['status']);
                        
                        // ✅ DATA COMPLETA - NÃO COMPACTAR
                        $dataPagamento = $monthData['payment_date'];
                        if ($dataPagamento !== '--' && $dataPagamento !== 'N/A' && !empty($dataPagamento)) {
                            // Manter data completa com hora
                            $dataPagamento = $this->formatarDataCompleta($dataPagamento);
                        } else {
                            $dataPagamento = '--';
                        }
                        
                        $rows[] = [
                            $periodo,
                            $tipoTaxa,
                            $monthData['due_date'],
                            $statusFormatado,
                            number_format($monthData['base_amount'], 2, ',', '.'),
                            number_format($monthData['fine_amount'], 2, ',', '.'),
                            number_format($monthData['discount_applied'], 2, ',', '.'),
                            number_format($monthData['paid_amount'], 2, ',', '.'),
                            $dataPagamento
                        ];
                    }
                    
                    // ✅ TOTAIS
                    $rows[] = [''];
                    $rows[] = [
                        '📊 TOTAIS:',
                        '',
                        '',
                        '',
                        'MT ' . number_format($this->data['summary']['total_annual_value'], 2, ',', '.'),
                        'MT ' . number_format($this->data['summary']['total_fines_paid'], 2, ',', '.'),
                        'MT ' . number_format($this->data['summary']['total_discounts_given'], 2, ',', '.'),
                        'MT ' . number_format($this->data['summary']['total_net_received'], 2, ',', '.'),
                        ''
                    ];
                    
                    // ✅ ESTATÍSTICAS
                    $mesesPagos = $this->data['summary']['months_paid_count'];
                    $mesesComTaxas = max($this->data['summary']['months_with_fees'], $mesesPagos);
                    $taxaCumprimento = $this->data['summary']['payment_rate'];
                    
                    $rows[] = [''];
                    $rows[] = [
                        '📈 ESTATÍSTICAS:',
                        "✅ Pagos: {$mesesPagos}/{$mesesComTaxas} meses",
                        "📊 Taxa de Cumprimento: {$taxaCumprimento}%",
                        ''
                    ];
                    
                    return $rows;
                }
                
                // ✅ MÉTODOS AUXILIARES MANTIDOS
                private function formatPeriodoCompacto($month, $year) {
                    $mesesPt = [
                        'January' => 'Jan', 'February' => 'Fev', 'March' => 'Mar',
                        'April' => 'Abr', 'May' => 'Mai', 'June' => 'Jun',
                        'July' => 'Jul', 'August' => 'Ago', 'September' => 'Set',
                        'October' => 'Out', 'November' => 'Nov', 'December' => 'Dez'
                    ];
                    return ($mesesPt[$month] ?? $month) . ' ' . $year;
                }
                
                private function simplificarTipoTaxa($feeNames) {
                    // ✅ NÃO INVENTAR NOMES - USAR O NOME REAL DA BASE DE DADOS
                    // Apenas limpar/encurtar se necessário para caber na célula
                    if (empty($feeNames) || trim($feeNames) === '') {
                        return 'Taxa Escolar';
                    }
                    
                    // Se o nome é muito longo, encurtar mas manter a essência
                    $feeNames = trim($feeNames);
                    
                    // Limitar tamanho para caber na célula do Excel
                    if (strlen($feeNames) > 20) {
                        // Tentar extrair a palavra-chave principal
                        if (stripos($feeNames, 'propina') !== false) {
                            return 'Propina';
                        } elseif (stripos($feeNames, 'transporte') !== false) {
                            return 'Transporte';
                        } elseif (stripos($feeNames, 'alimentação') !== false || stripos($feeNames, 'alimentacao') !== false) {
                            return 'Alimentação';
                        } elseif (stripos($feeNames, 'material') !== false) {
                            return 'Material';
                        } elseif (stripos($feeNames, 'matrícula') !== false || stripos($feeNames, 'matricula') !== false) {
                            return 'Matrícula';
                        } else {
                            // Se não consegue identificar, truncar mantendo o início
                            return substr($feeNames, 0, 17) . '...';
                        }
                    }
                    
                    // Se o nome cabe, usar o nome real completo
                    return $feeNames;
                }
                
                private function formatarStatusComEmoji($status) {
                    switch ($status) {
                        case 'Pago': return '✅ Pago';
                        case 'Em Atraso': return '⏰ Em Atraso';
                        case 'Não Pago': return '⏳ Pendente';
                        default: return '❓ ' . $status;
                    }
                }
                
                private function formatarDataCompleta($dataCompleta) {
                    // ✅ GARANTIR QUE A DATA APAREÇA COMPLETA
                    if ($dataCompleta === '--' || $dataCompleta === 'N/A' || empty($dataCompleta)) {
                        return '--';
                    }
                    
                    // Se já está no formato correto d/m/Y H:i, retornar
                    if (preg_match('/\d{2}\/\d{2}\/\d{4}\s+\d{2}:\d{2}/', $dataCompleta)) {
                        return $dataCompleta;
                    }
                    
                    // Se está só com data (sem hora), retornar
                    if (preg_match('/\d{2}\/\d{2}\/\d{4}/', $dataCompleta)) {
                        return $dataCompleta;
                    }
                    
                    // Tentar converter outros formatos
                    try {
                        $carbon = \Carbon\Carbon::parse($dataCompleta);
                        return $carbon->format('d/m/Y H:i');
                    } catch (\Exception $e) {
                        // Se não conseguir converter, retornar como está
                        return $dataCompleta;
                    }
                }
                
                private function formatarDataCompacta($dataCompleta) {
                    // ✅ MÉTODO MANTIDO PARA COMPATIBILIDADE SE NECESSÁRIO
                    return $this->formatarDataCompleta($dataCompleta);
                }
                
                public function title(): string {
                    return 'Mensalidades ' . $this->data['year'];
                }
                
                public function columnWidths(): array {
                    return [
                        'A' => 30, // Período
                        'B' => 30, // Tipo Taxa (aumentado para nomes reais)
                        'C' => 30, // Vencimento
                        'D' => 15, // Status
                        'E' => 14, // Valor Base
                        'F' => 12, // Multa
                        'G' => 12, // Desconto
                        'H' => 14, // Valor Pago
                        'I' => 18  // ✅ Data Pagamento (aumentado para data completa)
                    ];
                }
                
                // ✅ ESTILOS OTIMIZADOS (MENOS COMPLEXOS)
                public function styles(\PhpOffice\PhpSpreadsheet\Worksheet\Worksheet $sheet) {
                    $dataRowStart = 7;
                    $dataRowEnd = $dataRowStart + count($this->data['monthlyData']) - 1;
                    
                    return [
                        1 => [
                            'font' => ['bold' => true, 'size' => 14, 'color' => ['rgb' => '1565C0']],
                            'alignment' => ['horizontal' => 'center']
                        ],
                        3 => ['font' => ['bold' => true, 'size' => 10]],
                        5 => ['font' => ['bold' => true, 'size' => 11, 'color' => ['rgb' => '2E7D32']]],
                        $dataRowStart => [
                            'font' => ['bold' => true, 'color' => ['rgb' => 'FFFFFF'], 'size' => 10],
                            'fill' => ['fillType' => 'solid', 'color' => ['rgb' => '1565C0']],
                            'alignment' => ['horizontal' => 'center']
                        ],
                        'E:H' => ['font' => ['bold' => true]],
                    ];
                }
                
                // ✅ EVENTOS SIMPLIFICADOS
                public function registerEvents(): array {
                    return [
                        \Maatwebsite\Excel\Events\AfterSheet::class => function(\Maatwebsite\Excel\Events\AfterSheet $event) {
                            $sheet = $event->sheet->getDelegate();
                            $sheet->mergeCells('A1:I1');
                            $sheet->getRowDimension(1)->setRowHeight(25);
                            $sheet->freezePane('A8');
                            
                            // ✅ APLICAR CORES SIMPLES POR STATUS
                            $dataRowStart = 8;
                            foreach ($this->data['monthlyData'] as $index => $monthData) {
                                $rowNumber = $dataRowStart + $index;
                                $status = $monthData['status'];
                                
                                $fillColor = 'FFFFFF';
                                if ($status === 'Pago') $fillColor = 'C8E6C9';
                                elseif ($status === 'Em Atraso') $fillColor = 'FFCDD2';
                                elseif ($status === 'Não Pago') $fillColor = 'FFF9C4';
                                
                                $sheet->getStyle("D{$rowNumber}")->getFill()
                                    ->setFillType('solid')->getStartColor()->setRGB($fillColor);
                            }
                        }
                    ];
                }
                
            }, "mensalidades_{$this->selectedStudent->student_id}_{$this->selectedYear}.xlsx");
            
            session()->flash('message', 'Excel exportado com sucesso!');
            
        } catch (\Exception $e) {
            \Log::error('Excel export failed', ['error' => $e->getMessage()]);
            session()->flash('error', 'Erro ao exportar Excel: ' . $e->getMessage());
            return redirect()->back();
        }
    }

    // ✅ MÉTODO COMPLETO MAS OTIMIZADO - MULTAS DO FEE_STRUCTURE
    private function getExportDataComplete()
    {
        $currentYear = $this->selectedYear ?? now()->year;
        $months = [
            'January', 'February', 'March', 'April', 'May', 'June',
            'July', 'August', 'September', 'October', 'November', 'December'
        ];

        // ✅ BUSCA OTIMIZADA DE DADOS
        $studentClassroom = $this->selectedStudent->class->class ?? $this->selectedStudent->classroom->class ?? null;
        
        // Buscar todas as estruturas de taxa de uma vez
        $allFeeStructures = collect();
        if ($studentClassroom) {
            $allFeeStructures = FeeStructure::where('active', 1)
                ->whereRaw("FIND_IN_SET(?, grades)", [$studentClassroom])
                ->get();
        }

        // Buscar todos os pagamentos de uma vez
        $pagamentosReais = Fee_assign::where('student_id', $this->studentId)
            ->where('year', $currentYear)
            ->get()
            ->keyBy('month');

        \Log::info('Export data optimization', [
            'fee_structures_found' => $allFeeStructures->count(),
            'payments_found' => $pagamentosReais->count(),
            'student_class' => $studentClassroom
        ]);

        $monthlyData = [];
        $summary = [
            'total_annual_value' => 0,
            'total_paid' => 0,
            'total_fines_paid' => 0,
            'total_discounts_given' => 0,
            'total_net_received' => 0,
            'months_with_fees' => 0,
            'months_paid_count' => 0
        ];

        foreach ($months as $monthName) {
            $pagamentoReal = $pagamentosReais->get($monthName);
            $isPaid = !is_null($pagamentoReal);
            
            // ✅ BUSCAR ESTRUTURAS APLICÁVEIS PARA ESTE MÊS
            $feeStructuresForMonth = $allFeeStructures->filter(function($structure) use ($monthName) {
                return empty($structure->months) || in_array($monthName, explode(',', $structure->months));
            });

            // Calcular valor base para o mês
            $baseAmountForMonth = $feeStructuresForMonth->sum('monthly_fee');
            
            // Pular se não tem pagamento nem estrutura
            if (!$isPaid && $baseAmountForMonth <= 0) {
                continue;
            }

            if ($isPaid) {
                // ✅ USAR DADOS REAIS DO PAGAMENTO
                $baseAmount = $pagamentoReal->amount ?? 0;
                $fineAmount = $pagamentoReal->fine ?? 0;
                $discountAmount = $pagamentoReal->discount ?? 0;
                $netPaidAmount = $baseAmount + $fineAmount - $discountAmount;
                $paymentDate = $pagamentoReal->created_at->format('d/m/Y H:i');
                $status = 'Pago';
                
                // ✅ BUSCAR NOME REAL DA TAXA DO PAGAMENTO
                $feeNames = $this->getRealFeeNameFromPayment($pagamentoReal, $feeStructuresForMonth);
                
                // Data de vencimento mesmo para pagos
                $dueDate = $this->calculateDueDateForMonth($feeStructuresForMonth, $monthName, $currentYear);
                
            } else {
                // ✅ CALCULAR MULTA CORRETA DO FEE_STRUCTURE
                $baseAmount = $baseAmountForMonth;
                $dueDate = $this->calculateDueDateForMonth($feeStructuresForMonth, $monthName, $currentYear);
                
                // Verificar se está em atraso
                $isOverdue = false;
                if ($dueDate !== 'N/A') {
                    try {
                        $dueDateCarbon = \Carbon\Carbon::createFromFormat('d/m/Y', $dueDate);
                        $isOverdue = now()->gt($dueDateCarbon);
                    } catch (\Exception $e) {
                        $isOverdue = false;
                    }
                }
                
                // ✅ CALCULAR MULTA BASEADA NO FEE_STRUCTURE
                $fineAmount = 0;
                if ($isOverdue) {
                    foreach ($feeStructuresForMonth as $structure) {
                        if ($structure->penalty_type === 'fixed') {
                            $fineAmount += $structure->late_penalty_percentage ?? 0;
                        } else {
                            // Percentual sobre o valor
                            $fineAmount += ($structure->monthly_fee * ($structure->late_penalty_percentage ?? 0)) / 100;
                        }
                    }
                }
                
                // ✅ NOME DAS TAXAS DA ESTRUTURA
                $feeNames = $feeStructuresForMonth->pluck('fee_name')->filter()->unique()->implode(', ');
                if (empty($feeNames)) $feeNames = 'Taxa Escolar';
                
                $discountAmount = 0;
                $netPaidAmount = 0;
                $paymentDate = '--';
                $status = $isOverdue ? 'Em Atraso' : 'Não Pago';
            }

            // Referência (simplificada para velocidade)
            $referencia = $this->getPaymentReferenceSimple($monthName, $currentYear);

            $monthlyData[] = [
                'month' => $monthName,
                'year' => $currentYear,
                'reference' => $referencia,
                'fee_names' => $feeNames,
                'due_date' => $dueDate,
                'status' => $status,
                'base_amount' => $baseAmount,
                'fine_amount' => $fineAmount,
                'discount_applied' => $discountAmount,
                'paid_amount' => $netPaidAmount,
                'payment_date' => $paymentDate,
                'is_paid' => $isPaid,
                'is_overdue' => $status === 'Em Atraso'
            ];

            // Atualizar resumo
            if ($baseAmount > 0) {
                $summary['total_annual_value'] += $baseAmount;
                $summary['months_with_fees']++;
            }
            
            if ($isPaid) {
                $summary['total_paid'] += $baseAmount;
                $summary['total_fines_paid'] += $fineAmount;
                $summary['total_discounts_given'] += $discountAmount;
                $summary['total_net_received'] += $netPaidAmount;
                $summary['months_paid_count']++;
            }
        }

        $summary['payment_rate'] = $summary['months_with_fees'] > 0
            ? round(($summary['months_paid_count'] / $summary['months_with_fees']) * 100, 1)
            : 0;

        return [
            'monthlyData' => $monthlyData,
            'summary' => $summary,
            'student' => $this->selectedStudent,
            'year' => $currentYear
        ];
    }

    // ✅ MÉTODO PARA BUSCAR NOME REAL DA TAXA DO PAGAMENTO
    private function getRealFeeNameFromPayment($pagamentoReal, $feeStructuresForMonth)
    {
        // ✅ PRIMEIRA TENTATIVA: Buscar se o pagamento tem referência à estrutura de taxa
        try {
            // Se o pagamento tem fee_group_id ou fee_structure_id
            if (isset($pagamentoReal->fee_group_id) && $pagamentoReal->fee_group_id) {
                $feeGroup = \App\Models\FeeGroup::find($pagamentoReal->fee_group_id);
                if ($feeGroup && $feeGroup->name) {
                    return $feeGroup->name;
                }
            }
            
            // Se o pagamento tem fee_structure_id
            if (isset($pagamentoReal->fee_structure_id) && $pagamentoReal->fee_structure_id) {
                $feeStructure = \App\Models\FeeStructure::find($pagamentoReal->fee_structure_id);
                if ($feeStructure && $feeStructure->fee_name) {
                    return $feeStructure->fee_name;
                }
            }
            
            // ✅ SEGUNDA TENTATIVA: Buscar pelo valor pago nas estruturas do mês
            $baseAmount = $pagamentoReal->amount ?? 0;
            foreach ($feeStructuresForMonth as $structure) {
                if ($structure->monthly_fee == $baseAmount) {
                    return $structure->fee_name ?? 'Taxa Escolar';
                }
            }
            
            // ✅ TERCEIRA TENTATIVA: Se pagamento tem campo 'note' ou 'description'
            if (isset($pagamentoReal->note) && !empty($pagamentoReal->note)) {
                // Extrair nome da taxa da nota se contém informação útil
                $note = strtolower($pagamentoReal->note);
                if (stripos($note, 'propina') !== false) return 'Propina';
                if (stripos($note, 'transporte') !== false) return 'Transporte';
                if (stripos($note, 'alimentação') !== false) return 'Alimentação';
                if (stripos($note, 'material') !== false) return 'Material Escolar';
            }
            
            // ✅ QUARTA TENTATIVA: Buscar por payment_mode específico
            if (isset($pagamentoReal->paymentMode) || isset($pagamentoReal->payment_mode)) {
                $paymentMode = $pagamentoReal->paymentMode ?? $pagamentoReal->payment_mode;
                if (stripos($paymentMode, 'propina') !== false) return 'Propina';
                if (stripos($paymentMode, 'transporte') !== false) return 'Transporte';
            }
            
            // ✅ QUINTA TENTATIVA: Buscar baseado no valor e estruturas disponíveis
            $possibleStructures = $feeStructuresForMonth->filter(function($structure) use ($baseAmount) {
                return abs($structure->monthly_fee - $baseAmount) <= 0.01; // Tolerância de 1 centavo
            });
            
            if ($possibleStructures->count() > 0) {
                return $possibleStructures->first()->fee_name ?? 'Taxa Escolar';
            }
            
            // ✅ ÚLTIMA TENTATIVA: Usar a estrutura de taxa mais comum para o valor
            $closestStructure = $feeStructuresForMonth->sortBy(function($structure) use ($baseAmount) {
                return abs($structure->monthly_fee - $baseAmount);
            })->first();
            
            if ($closestStructure && $closestStructure->fee_name) {
                return $closestStructure->fee_name;
            }
            
        } catch (\Exception $e) {
            \Log::warning('Error getting real fee name from payment', [
                'payment_id' => $pagamentoReal->id ?? null,
                'student_id' => $pagamentoReal->student_id ?? null,
                'error' => $e->getMessage()
            ]);
        }
        
        // ✅ FALLBACK: Se não conseguiu determinar, usar da estrutura ou genérico
        $fallbackName = $feeStructuresForMonth->pluck('fee_name')->filter()->first();
        return $fallbackName ?: 'Taxa Escolar';
    }

    // ✅ MÉTODO OTIMIZADO PARA BUSCAR NOMES DE TAXAS BASEADO NO VALOR
    private function getFeeNamesByValue($amount, $feeStructures)
    {
        $matchingStructures = $feeStructures->filter(function($structure) use ($amount) {
            return abs($structure->monthly_fee - $amount) <= 0.01;
        });
        
        if ($matchingStructures->count() > 0) {
            return $matchingStructures->pluck('fee_name')->filter()->unique()->implode(', ');
        }
        
        // Se não encontrou por valor exato, pegar a mais próxima
        $closestStructure = $feeStructures->sortBy(function($structure) use ($amount) {
            return abs($structure->monthly_fee - $amount);
        })->first();
        
        return $closestStructure ? ($closestStructure->fee_name ?? 'Taxa Escolar') : 'Taxa Escolar';
    }

    // ✅ MÉTODOS AUXILIARES OTIMIZADOS
    private function calculateDueDateForMonth($feeStructures, $monthName, $year)
    {
        foreach ($feeStructures as $structure) {
            $dueDateDay = $structure->payment_due_day ?? 15;
            $monthIndex = array_search($monthName, [
                'January', 'February', 'March', 'April', 'May', 'June',
                'July', 'August', 'September', 'October', 'November', 'December'
            ]) + 1;
            
            return str_pad($dueDateDay, 2, '0', STR_PAD_LEFT) . '/' .
                   str_pad($monthIndex, 2, '0', STR_PAD_LEFT) . '/' . $year;
        }
        return 'N/A';
    }

    private function getPaymentReferenceSimple($month, $year)
    {
        // Versão simplificada para velocidade
        static $cachedReference = null;
        
        if ($cachedReference === null) {
            $ref = \App\Models\PaymentReference::where('student_id', $this->studentId)
                ->where('fee_year', $year)
                ->whereNotNull('reference_number')
                ->first();
            $cachedReference = $ref ? $ref->reference_number : 'REF-' . $this->studentId;
        }
        
        // Adaptar para o mês
        $monthNumber = array_search($month, [
            'January', 'February', 'March', 'April', 'May', 'June',
            'July', 'August', 'September', 'October', 'November', 'December'
        ]) + 1;
        
        if (strlen($cachedReference) >= 11) {
            return substr($cachedReference, 0, 9) . str_pad($monthNumber, 2, '0', STR_PAD_LEFT);
        }
        
        return $cachedReference . str_pad($monthNumber, 2, '0', STR_PAD_LEFT);
    }
    
    
    public function exportPdf()
    {
        try {
            $data = $this->getExportData();
            
            $pdf = Pdf::loadView('exports.student-finance-pdf', [
                'student' => $this->selectedStudent,
                'year' => $this->selectedYear,
                'data' => $data,
                'generated_at' => now()->format('d/m/Y H:i'),
            ]);
            
            return $pdf->download("extrato_financeiro_{$this->selectedStudent->student_id}_{$this->selectedYear}.pdf");
            
        } catch (\Exception $e) {
            \Log::error('PDF export failed', ['error' => $e->getMessage()]);
            session()->flash('error', 'Erro ao exportar PDF: ' . $e->getMessage());
        }
    }

    private function getExportData()
    {
        $currentYear = $this->selectedYear ?? now()->year;
        $months = [
            'January', 'February', 'March', 'April', 'May', 'June',
            'July', 'August', 'September', 'October', 'November', 'December'
        ];

        $studentClassroom = $this->selectedStudent->class->class ?? $this->selectedStudent->classroom->class ?? null;
        $filteredFeeStructures = [];

        if ($studentClassroom) {
            $feeStructures = FeeStructure::where('active', 1)->get();
            
            foreach ($feeStructures as $feeStructure) {
                $gradesArray = explode(',', $feeStructure->grades);
                if (in_array($studentClassroom, $gradesArray)) {
                    $filteredFeeStructures[] = $feeStructure;
                }
            }
        }

        $exportData = [];
        $summary = [
            'total_annual_value' => 0,
            'total_paid' => 0,
            'total_due' => 0,
            'total_overdue' => 0,
            'total_fines_paid' => 0,
            'total_discounts_given' => 0,
            'total_net_received' => 0,
            'months_with_fees' => 0,
            'months_paid_count' => 0
        ];

        foreach ($months as $monthName) {
            try {
                $calculation = $this->feeCalculationService->calculateFeeForStudent(
                    $this->selectedStudent,
                    $monthName,
                    $currentYear
                );

                if ($calculation['base_amount'] <= 0) continue;

                $existingPayment = $this->feeCalculationService->getPaymentForPeriod(
                    $this->selectedStudent,
                    $monthName,
                    $currentYear
                );

                $isPaid = !is_null($existingPayment);
                $baseAmountPaid = $isPaid ? ($existingPayment->amount ?? 0) : 0;
                $fineAmountPaid = $isPaid ? ($existingPayment->fine ?? 0) : 0;
                $discountAmount = $isPaid ? ($existingPayment->discount ?? 0) : 0;
                $netPaidAmount = $baseAmountPaid + $fineAmountPaid - $discountAmount;

                $fineAmountToShow = $isPaid ? $fineAmountPaid : $calculation['fine_amount'];

                $entidade = '90013';
                $referencia = $this->getPaymentReference($monthName, $currentYear);

                $status = 'Não Pago';
                if ($isPaid) {
                    $status = 'Pago';
                } elseif ($calculation['is_late_payment']) {
                    $status = 'Em Atraso';
                }

                $feeNames = $this->getFeeNamesForMonth($filteredFeeStructures, $monthName);
                $dueDate = $calculation['due_date'] ? $calculation['due_date']->format('d/m/Y') : 'N/A';
                $paymentDate = $isPaid ? $existingPayment->created_at->format('d/m/Y H:i') : '--';

                $exportData[] = [
                    $monthName . ' ' . $currentYear,
                    $entidade,
                    $referencia,
                    $feeNames,
                    $dueDate,
                    $status,
                    number_format($calculation['base_amount'], 2, ',', '.'),
                    number_format($fineAmountToShow, 2, ',', '.'),
                    number_format($discountAmount, 2, ',', '.'),
                    number_format($netPaidAmount, 2, ',', '.'),
                    $paymentDate
                ];

                $summary['total_annual_value'] += $calculation['base_amount'];
                $summary['months_with_fees']++;
                
                if ($isPaid) {
                    $summary['total_paid'] += $baseAmountPaid;
                    $summary['total_fines_paid'] += $fineAmountPaid;
                    $summary['total_discounts_given'] += $discountAmount;
                    $summary['total_net_received'] += $netPaidAmount;
                    $summary['months_paid_count']++;
                } else {
                    if ($calculation['is_late_payment']) {
                        $summary['total_overdue'] += $calculation['base_amount'];
                    } else {
                        $summary['total_due'] += $calculation['base_amount'];
                    }
                }

            } catch (\Exception $e) {
                \Log::error('Error preparing export data for month', [
                    'month' => $monthName,
                    'year' => $currentYear,
                    'error' => $e->getMessage()
                ]);
                continue;
            }
        }

        $summary['payment_rate'] = $summary['months_with_fees'] > 0
            ? round(($summary['months_paid_count'] / $summary['months_with_fees']) * 100, 1)
            : 0;

        return [
            'rows' => $exportData,
            'summary' => $summary,
            'student' => $this->selectedStudent,
            'year' => $currentYear
        ];
    }



        public function render()
        {
            // ✅ BUSCA ESTRUTURAS DE TAXA APLICÁVEIS PARA EXIBIÇÃO
            $studentClassroom = $this->selectedStudent->class->class ?? $this->selectedStudent->classroom->class ?? null;
            $filteredFeeStructures = [];

            if ($studentClassroom) {
                $feeStructures = FeeStructure::where('active', 1)->get();
                
                foreach ($feeStructures as $feeStructure) {
                    $gradesArray = explode(',', $feeStructure->grades);
                    if (in_array($studentClassroom, $gradesArray)) {
                        $filteredFeeStructures[] = $feeStructure;
                    }
                }
            }

            // ✅ GERA DADOS PARA A TABELA - Todos os meses do ano selecionado
            $currentYear = $this->selectedYear ?? date('Y');
            $months = [
                'January', 'February', 'March', 'April', 'May', 'June',
                'July', 'August', 'September', 'October', 'November', 'December'
            ];

            // ✅ INICIALIZAÇÃO DE VARIÁVEIS PARA CÁLCULOS
            $monthlyData = [];
            
            // Totais para compatibilidade com código antigo
            $totalExpected = 0;
            $totalPaid = 0;
            $totalPending = 0;
            $totalOverdue = 0;
            
            // ✅ NOVOS TOTAIS PARA OS WIDGETS CORRIGIDOS
            $totalAnnualValue = 0;          // Total base esperado no ano
            $totalBasePaid = 0;             // Total de valores base pagos
            $totalDue = 0;                  // Total pendente (no prazo)
            $totalOverdueBase = 0;          // Total em atraso (apenas base)
            $totalFinesPaid = 0;            // Total de multas pagas
            $totalDiscountsGiven = 0;       // Total de descontos concedidos
            $totalNetReceived = 0;          // ✅ NOVO: Total Pago (Base + Multa - Desconto)
            $monthsWithFees = 0;            // Meses que têm taxas definidas
            $monthsPaidCount = 0;           // Meses efetivamente pagos

            // ✅ PROCESSAMENTO MÊS A MÊS
            foreach ($months as $monthName) {
                try {
                    // Calcula taxa usando o service unificado
                    $calculation = $this->feeCalculationService->calculateFeeForStudent(
                        $this->selectedStudent,
                        $monthName,
                        $currentYear
                    );

                    // Pula meses sem taxa definida
                    if ($calculation['base_amount'] <= 0) continue;

                    // Verifica se já foi pago
                    $existingPayment = $this->feeCalculationService->getPaymentForPeriod(
                        $this->selectedStudent,
                        $monthName,
                        $currentYear
                    );

                    $isPaid = !is_null($existingPayment);
                    
                    // ✅ CÁLCULO CORRETO DOS VALORES PAGOS
                    $baseAmountPaid = $isPaid ? ($existingPayment->amount ?? 0) : 0;
                    $fineAmountPaid = $isPaid ? ($existingPayment->fine ?? 0) : 0;
                    $discountAmount = $isPaid ? ($existingPayment->discount ?? 0) : 0;
                    $netPaidAmount = $baseAmountPaid + $fineAmountPaid - $discountAmount; // ✅ VALOR REAL PAGO
                    
                    //$balanceAmount = $isPaid ? 0 : $calculation['total_amount'];
                    $fineAmountToShow = $isPaid ? $fineAmountPaid : $calculation['fine_amount'];

                    // ✅ DETERMINA STATUS DO PAGAMENTO
                    $status = 'Não Pago';
                    if ($isPaid) {
                        $status = 'Pago';
                    } elseif ($calculation['is_late_payment']) {
                        $status = 'Em Atraso';
                    }

                    // ✅ MONTA DADOS PARA A TABELA
                    $monthlyData[] = [
                        'month' => $monthName,
                        'year' => $currentYear,
                        'fee_names' => $this->getFeeNamesForMonth($filteredFeeStructures, $monthName),
                        'due_date' => $calculation['due_date'] ? $calculation['due_date']->format('d/m/Y') : 'N/A',
                        'status' => $status,
                        'base_amount' => $calculation['base_amount'],
                        'fine_amount' => $calculation['fine_amount'],
                        'total_expected' => $calculation['total_amount'],
                        'discount_applied' => $discountAmount,
                        'paid_amount' => $netPaidAmount, // ✅ VALOR REAL PAGO
                        'balance_amount' => $balanceAmount,
                        'payment_date' => $isPaid ? $existingPayment->created_at->format('d/m/Y') : 'N/A',
                        'is_paid' => $isPaid,
                        'is_overdue' => $calculation['is_late_payment'],
                        'existing_payment' => $existingPayment,
                        'data_status' => $isPaid ? 'paid' : ($calculation['is_late_payment'] ? 'overdue' : 'pending')
                    ];

                    // ✅ ATUALIZA TOTAIS PARA OS WIDGETS
                    $monthsWithFees++;
                    $totalAnnualValue += $calculation['base_amount'];
                    
                    if ($isPaid) {
                        $totalBasePaid += $baseAmountPaid;
                        $totalFinesPaid += $fineAmountPaid;
                        $totalDiscountsGiven += $discountAmount;
                        $totalNetReceived += $netPaidAmount; // ✅ TOTAL REAL RECEBIDO
                        $monthsPaidCount++;
                    } else {
                        if ($calculation['is_late_payment']) {
                            $totalOverdueBase += $calculation['base_amount'];
                        } else {
                            $totalDue += $calculation['base_amount'];
                        }
                    }

                    // ✅ COMPATIBILIDADE COM CÓDIGO ANTIGO
                    $totalExpected += $calculation['total_amount'];
                    if ($isPaid) {
                        $totalPaid += $netPaidAmount;
                    } else {
                        if ($calculation['is_late_payment']) {
                            $totalOverdue += $calculation['total_amount'];
                        } else {
                            $totalPending += $calculation['total_amount'];
                        }
                    }

                } catch (\Exception $e) {
                    \Log::error('Error calculating month data', [
                        'month' => $monthName,
                        'year' => $currentYear,
                        'student_id' => $this->studentId,
                        'error' => $e->getMessage()
                    ]);

                    // ✅ DADOS DE FALLBACK PARA MESES COM ERRO
                    $monthlyData[] = [
                        'month' => $monthName,
                        'year' => $currentYear,
                        'fee_names' => 'Taxa Escolar',
                        'due_date' => 'N/A',
                        'status' => 'Erro',
                        'base_amount' => 0,
                        'fine_amount' => 0,
                        'total_expected' => 0,
                        'discount_applied' => 0,
                        'paid_amount' => 0,
                        'balance_amount' => 0,
                        'payment_date' => 'N/A',
                        'is_paid' => false,
                        'is_overdue' => false,
                        'existing_payment' => null,
                        'data_status' => 'error'
                    ];
                }
            }

            // ✅ CÁLCULO DA TAXA DE CUMPRIMENTO
            $paymentRate = ($monthsWithFees > 0) ? round(($monthsPaidCount / $monthsWithFees) * 100, 1) : 0;

            // ✅ BUSCA PAGAMENTOS EXISTENTES (PARA COMPATIBILIDADE)
            $fees = Fee_assign::where('student_id', $this->studentId)
                             ->orderBy('created_at', 'desc')
                             ->get()
                             ->map(function ($fee) {
                                 $fee->total_expected = $fee->amount + $fee->fine - $fee->discount;
                                 $fee->has_fine = $fee->fine > 0;
                                 $fee->fine_percentage = $fee->amount > 0 ? round(($fee->fine / $fee->amount) * 100, 1) : 0;
                                 $fee->payment_status = 'complete';
                                 return $fee;
                             });

            // ✅ BUSCA DESCONTOS APLICÁVEIS
            $discounts = discount::where('student_id', $this->studentId)->get();

            // ✅ RETORNA VIEW COM TODOS OS DADOS
            return view('livewire.admin.fee.fee-collection', [
                // ✅ DADOS BÁSICOS DO ESTUDANTE
                'student' => $this->selectedStudent,
                'fees' => $fees,
                'fee' => $this->calculatedTotal,
                'feestructures' => $filteredFeeStructures,
                'discounts' => $discounts,
                
                // ✅ DADOS DO CÁLCULO ATUAL
                'calculatedBaseFee' => $this->calculatedBaseFee,
                'calculatedFine' => $this->calculatedFine,
                'calculatedTotal' => $this->calculatedTotal,
                'isLatePayment' => $this->isLatePayment,
                'dueDate' => $this->dueDate,
                
                // ✅ DADOS PARA A TABELA MENSAL
                'monthlyData' => $monthlyData,
                
                // ✅ RESUMO DO ANO (COMPATIBILIDADE)
                'yearSummary' => [
                    'total_expected' => $totalExpected,
                    'total_paid' => $totalPaid,
                    'total_pending' => $totalPending,
                    'total_overdue' => $totalOverdue,
                    'current_year' => $currentYear
                ],
                
                // ✅ ANO SELECIONADO PARA FILTROS E EXPORTAÇÃO
                'selectedYear' => $this->selectedYear,

                // ✅ DADOS CORRIGIDOS PARA OS WIDGETS
                'widgetData' => [
                    'total_annual_value' => $totalAnnualValue,           // Total anual esperado (base)
                    'total_base_paid' => $totalBasePaid,                // Total arrecadado (apenas base)
                    'total_net_received' => $totalNetReceived,          // ✅ NOVO: Total Pago (Base + Multa - Desconto)
                    'total_due' => $totalDue,                           // Pendente (no prazo)
                    'total_overdue_base' => $totalOverdueBase,          // Em atraso (base)
                    'total_fines_paid' => $totalFinesPaid,              // Multas pagas
                    'total_discounts_given' => $totalDiscountsGiven,    // Descontos concedidos
                    'payment_rate' => $paymentRate,                     // Taxa de cumprimento (%)
                    'months_with_fees' => $monthsWithFees,              // Meses com taxas
                    'months_paid_count' => $monthsPaidCount             // Meses pagos
                ],

                // ✅ DADOS EXTRAS PARA ANÁLISE E DEBUG
                'analysisData' => [
                    'total_students_in_class' => 1, // Pode ser expandido
                    'average_payment_delay' => 0,   // Pode ser calculado
                    'most_delayed_month' => null,   // Pode ser identificado
                    'payment_trend' => 'stable',    // Pode ser analisado
                ],

                // ✅ CONFIGURAÇÕES PARA A INTERFACE
                'uiConfig' => [
                    'show_advanced_stats' => true,
                    'enable_bulk_actions' => false,
                    'default_payment_mode' => 'Cash',
                    'currency_symbol' => 'MT',
                    'date_format' => 'd/m/Y',
                    'enable_debug_mode' => app()->environment('local'),
                ],

                // ✅ DADOS PARA RELATÓRIOS E EXPORTAÇÃO
                'reportMetadata' => [
                    'generated_at' => now(),
                    'generated_by' => auth()->user()->name ?? 'Sistema',
                    'academic_year' => $currentYear,
                    'student_class' => $studentClassroom,
                    'total_months_analyzed' => count($months),
                    'months_with_data' => count(array_filter($monthlyData, fn($m) => $m['base_amount'] > 0)),
                    'data_quality_score' => round(($monthsWithFees > 0 ? ($monthsPaidCount / $monthsWithFees) : 0) * 100, 1),
                ]
            ]);
        }
        }
