<?php

namespace App\Http\Livewire\Admin\Fee;

use App\Models\FeeGroup;
use Jantinnerezo\LivewireAlert\LivewireAlert;
use LaravelMultipleGuards\Traits\FindGuard;
use Livewire\Component;
use Livewire\WithPagination;

class ListFeeGroup extends Component
{
    use WithPagination, FindGuard, LivewireAlert;

    public $search, $delete;
    protected $queryString = ['search'];
    protected string $paginationTheme = 'bootstrap';
    public bool $readyToLoad = false;

    protected $listeners = [
        'confirmed',
        'cancelled',
        'FeeGroupDeleted' => '$refresh', // 🔥 Auto-refresh when a record is deleted
    ];

    /**
     * Reset pagination when searching
     */
    public function updatingSearch()
    {
        $this->resetPage();
    }

    /**
     * Load data on initialization
     */
    public function loadData()
    {
        $this->readyToLoad = true;
        $this->dispatchBrowserEvent('refreshTable'); // 🔥 Force UI refresh
    }

    /**
     * Confirm delete action
     */
    public function submit($id)
    {
        $this->delete = FeeGroup::query()->firstWhere('id', $id);
        $this->confirm('Tem certeza de que deseja prosseguir?', [
            'toast' => false,
            'position' => 'center',
            'showConfirmButton' => true,
            'confirmButtonText' => 'Sim, eu tenho certeza!',
            'cancelButtonText' => 'Não, cancelar!',
            'onConfirmed' => 'confirmed',
            'onDismissed' => 'cancelled'
        ]);
    }

    /**
     * Delete FeeGroup and refresh list
     */
    public function confirmed()
    {
        FeeGroup::where('id', $this->delete->id)->delete();
        
        
        $this->emit('FeeGroupDeleted');

        
        $this->reset(['delete']);
        $this->resetPage(); 
        
        // Show success alert
        $this->alert('success', 'Deletado com sucesso');
    }

    /**
     * Handle cancel action
     */
    public function cancelled()
    {
        $this->alert('error', 'Você cancelou.');
    }

    /**
     * Render Livewire component
     */
    public function render()
    {
        return view('livewire.admin.fee.list-fee-group', [
            'FeeGroups' => $this->readyToLoad
                ? FeeGroup::query()
                    ->latest('updated_at')
                    ->where('name', 'like', '%' . $this->search . '%')
                    ->paginate(10)
                : []
        ]);
    }
}
