<?php

// namespace App\Http\Livewire\Admin\Paymentconformation;

// use App\Models\Admin;

// use App\Models\Classroom;
// use App\Models\User;

// use App\Models\PaymentConfirmation;
// use Illuminate\Validation\ValidationException;
// use Jantinnerezo\LivewireAlert\LivewireAlert;
// use LaravelMultipleGuards\Traits\FindGuard;
// use Livewire\Component;
// use Note\Note;
// use App\Http\Controllers\SystemController;
// use App\Models\Category;
// use Livewire\WithFileUploads;

// class AddPayment extends Component
// {
//     use FindGuard, LivewireAlert, WithFileUploads;

//     public $title, $description, $category_id, $photo,$pdf,$author,  $validatedData, $type, $class_id, $student_id;
//     public $updateMode = false;
//     public $user;
//     protected $listeners = [
//         'confirmed',
//         'cancelled'
//     ];

//     protected array $rules = [
//         'title' => ['required', 'string', 'max:255'],
//         'photo' => ['required'], // 2MB Max
//         //'pdf' => ['required', 'mimes:pdf'], // 2MB Max
//     ];

//     /**
//      * D0 real time validations
//      * @param $propertyName
//      * @throws ValidationException
//      */
//     public function updated($propertyName)
//     {
//         $this->validateOnly($propertyName);

//     }

//     public function submit()
//     {
//         //$this->validatedData = $this->validate();

//         $details = SystemController::store_media($this->photo);
//         //$pdfd = SystemController::store_media($this->pdf);
//         if(empty($this->type)){
//             $this->type = "all";
//         }
//         $downloadcenter = PaymentConfirmation::query()->create([
//             'title' => $this->title,
//             'media_name'=> $details[0],
//             'media_url'=>$details[1],
//             'type'=>$this->type,
//             'class_id'=> $this->class_id,
//             'student_id'=>$this->student_id,
            
//         ]);




//         Note::createSystemNotification(Admin::class, 'Conf. de pagamento', 'Nova conf. de pagamento com sucesso ' . $this->title);
//         $this->emit('noteAdded');
//         $this->alert('success', 'Nova conf. de pagamento adicionada com sucesso ' . $this->title . $downloadcenter->slug);
//         $this->reset();
//         /*$this->confirm('Tem certeza de que deseja prosseguir?', [
//             'toast' => false,
//             'position' => 'center',
//             'showConfirmButton' => true,
//             'confirmButtonText' => 'Sim, eu tenho certeza!',
//             'cancelButtonText' => 'Não, cancelar!',
//             'onConfirmed' => 'confirmed',
//             'onDismissed' => 'cancelled'
//         ]);*/
//     }

//     public function confirmed()
//     {

        
//     }

//     public function cancelled()
//     {
//         $this->alert('error', 'Você cancelou.');
//     }
//     public function render()
//     {
//         if(!empty($this->type)){
//             return view('livewire.admin.paymentconfirmation.add-payment', [
//                 'Classroom' => Classroom::query()->orderBy('class')->get(),
//                 'students' => User::Where("classroom_id",$this->class_id)->get(),
//             ]);
//         }else{
//             return view('livewire.admin.paymentconfirmation.add-payment', [
//                 'Classroom' => Classroom::query()->orderBy('class')->get(),
//             ]);
//         }
//     }
// }

namespace App\Http\Livewire\Admin\Paymentconformation;

use App\Models\Admin;
use App\Models\Classroom;
use App\Models\User;
use App\Models\PaymentConfirmation;
use Illuminate\Validation\ValidationException;
use Jantinnerezo\LivewireAlert\LivewireAlert;
use LaravelMultipleGuards\Traits\FindGuard;
use Livewire\Component;
use Note\Note;
use App\Http\Controllers\SystemController;
use App\Models\Category;
use Livewire\WithFileUploads;
use Kreait\Firebase\Factory;
use Kreait\Firebase\Messaging\CloudMessage;
use Kreait\Firebase\Messaging\Notification;
use Illuminate\Support\Facades\Log;

class AddPayment extends Component
{
    use FindGuard, LivewireAlert, WithFileUploads;

    public $title, $description, $category_id, $photo, $pdf, $author, $validatedData, $type, $class_id, $student_id;
    public $updateMode = false;
    public $user;
    protected $listeners = [
        'confirmed',
        'cancelled'
    ];

    protected array $rules = [
        'title' => ['required', 'string', 'max:255'],
        'photo' => ['required'], // 2MB Max
    ];

    public function updated($propertyName)
    {
        $this->validateOnly($propertyName);
    }

    public function submit()
    {
        $details = SystemController::store_media($this->photo);

        if (empty($this->type)) {
            $this->type = "all";
        }

        $paymentConfirmation = PaymentConfirmation::query()->create([
            'title' => $this->title,
            'media_name'=> $details[0],
            'media_url' => $details[1],
            'type' => $this->type,
            'class_id' => $this->class_id,
            'student_id' => $this->student_id,
        ]);

        Note::createSystemNotification(Admin::class, 'Conf. de pagamento', 'Nova conf. de pagamento adicionada com sucesso ' . $this->title);
        $this->emit('noteAdded');
        $this->alert('success', 'Nova conf. de pagamento adicionada com sucesso ' . $this->title);

        // Enviar notificações
        if ($this->type == 'all') {
            $users = User::whereHas('deviceTokens')->get();
            $this->sendNotifications($users);
        } elseif ($this->type == 'class') {
            $users = User::where('classroom_id', $this->class_id)->get();
            $this->sendNotifications($users);
        } elseif ($this->type == 'student') {
            $user = User::find($this->student_id);
            if ($user) {
                $this->sendNotifications([$user]);
            }
        }

        // Resetar campos
        $this->reset(['title', 'photo', 'type', 'class_id', 'student_id']);
    }

    private function sendNotifications($users)
    {
        // Your Firebase credentials (make sure to securely store your private key)
        $firebaseCredentials = [
            "type"=> "service_account",
            "project_id"=> "copmoz-3x",
            "private_key_id"=> "bb9e045f0e2345c069b299a14636203509899ef8",
            "private_key"=> "-----BEGIN PRIVATE KEY-----\nMIIEvgIBADANBgkqhkiG9w0BAQEFAASCBKgwggSkAgEAAoIBAQDYfKrqJJyR6/8w\nP0NI75wA0OMzBMq53JD0GX/2G488VD2gE+Wbxt90e/6PUGdrOEwo7C+ilCNKsoX7\nzyy6l6kOt6MgVjO39bc7/qwaKYcA05/48grMrLMUxb6SNAMmKmj3CTQ9dU/zAmqA\n96HleqAkHt22wRSQ8hy4qg44CC1f8faBJxGb68YeMm9TmoYcdUhc7QT13JoMRZjl\nbi5gNDVIFWDyUhXeVpvw13Z3Sfo+EgkiT2Tb2Nr8//rptIabmrhzUsAFTEKnHblh\nY+1nsxBBwImu1NRtr5aQUCNLUZXcbWpuoym6EZtCLe3u6/mL3wI05407q1YqpUOq\nppfDwuHdAgMBAAECggEAMuv0Kfotp/dKgddHpObTm6+G2a/VXa2fnQNIgaPO5+Jq\n0nYLqr43PoeSA7TmdqZ556BSvhu5R29Bq876FvPojLEuWkNci/dsv9xyL/83pb6h\noOWSG729q/OtlWdNnFMaeI0+L/yhrygQ1EArYTacZ5KpFT1KcKO6lMdPa+ekgK4T\nPuwGVD/3VDFG9AWCEm+v3w6bQAhpKbdZiBPpGvTrfFHYov97/Yzv/iC3599VnW+i\no3GweFGaqsOn4PxuyIyYujzgoIc6kBrivUV+ddxZqLufrsQL1uE78SuWjhRNS8/k\n5rUD3Qvaj3BOQzkqCnttclfPZYSmbjMtVyLOMjMcQQKBgQDkE1SnrhY/dZF5QCFg\nIMaf7wkPLLCSStugOeYMGx2oeD0MxaY9L9N1ffRLekngffzANrO/ybE7AlRzgBJB\n2NYFd7fueihmrWuTpMafkBivG+mf+HdTjkxF0aQfYUL+MMW7viBBzGDbwckRSTX5\n5pSqzEHmRvctiLTfHqqgUnDeIQKBgQDy/hzbdteqvgqRok7KoXy3ciij4SQbDOQZ\n19KcmMTFgMiT/xm/3uni924Qw82VVSYQjDbAoSltTl7cpvtkXzSB2LIg00YEhfcE\nj/atYfswDIBYBAGCUZDalOn6s/8TWuTGVfCkQVwHA2Xa3rKqIrI1gHTuu5N4J/P4\niCmL3Vd0PQKBgQC1mirC5Rvz5ZIywHySxSZCfJtzCLuDkLV1zAQ/yWuBFFRQEiS+\n/ZDbMbJOUw32AXs6NZREdr125fEGkoh3A8fOTLgY3A3FS/qncgFxVdRBwfDxHm8t\nCdXzleyfy9sC+STIy6d1nN3WvWNzLx8aX54qrT8fs4vnJr4WFp330Azs4QKBgQCc\nnDj/Hb5sdmWbbW+425HlLfeRf+bkZE+TdG1yrmeMH6+m6zCuYD6AIRbYSUp0J9gL\nrEMRrg1kPLGZJyo5i77svTw5OdIT0j/dueez4cWiNzx0/cf3NRjWOEoBYgdRczCl\nv/gD9XgZsQ/xm7ytOQWAxBUZVN38AEwW77NPSM43xQKBgCgCmFCO57u8Fc6d+4G9\nBy/Vfmy3tZpwGCTGqxkwhFvG+qXZTERJOwRg4jejIM/W6iQlOPmfsis2CWhCZvYL\nSimfvuVeWSVixdnsxVpjVyyT7ci9jMhPXeL7LtMCjNF4hB34qgejqpkwh62Zqg0h\nNuy5ZdoARi0VwY/spf6HK03b\n-----END PRIVATE KEY-----\n",
            "client_email"=>"firebase-adminsdk-as4sm@copmoz-3x.iam.gserviceaccount.com",
            "client_id"=> "112030584520787629755",
            "auth_uri"=> "https://accounts.google.com/o/oauth2/auth",
            "token_uri"=> "https://oauth2.googleapis.com/token",
            "auth_provider_x509_cert_url"=> "https://www.googleapis.com/oauth2/v1/certs",
            "client_x509_cert_url"=> "https://www.googleapis.com/robot/v1/metadata/x509/firebase-adminsdk-as4sm%40copmoz-3x.iam.gserviceaccount.com",
            "universe_domain"=> "googleapis.com"
        ];

        $messaging = (new Factory)
            ->withServiceAccount($firebaseCredentials)
            ->createMessaging();

        foreach ($users as $user) {
            foreach ($user->deviceTokens as $token) {
                try {
                    $message = CloudMessage::withTarget('token', $token->token)
                        ->withNotification(Notification::create('Nova Confirmação de Pagamento: ', $this->title));

                    $messaging->send($message);
                } catch (\Exception $e) {
                    Log::error('Erro ao enviar notificação Firebase: ' . $e->getMessage());
                }
            }
        }
    }

    public function confirmed()
    {
    }

    public function cancelled()
    {
        $this->alert('error', 'Você cancelou.');
    }

    public function render()
    {
        if (!empty($this->type)) {
            return view('livewire.admin.paymentconfirmation.add-payment', [
                'Classroom' => Classroom::query()->orderBy('class')->get(),
                'students' => User::where("classroom_id", $this->class_id)->get(),
            ]);
        } else {
            return view('livewire.admin.paymentconfirmation.add-payment', [
                'Classroom' => Classroom::query()->orderBy('class')->get(),
            ]);
        }
    }
}

