<?php

namespace App\Http\Livewire\Admin\Reports;
use App\Models\Admin;
use Illuminate\Validation\ValidationException;
use Jantinnerezo\LivewireAlert\LivewireAlert;
use LaravelMultipleGuards\Traits\FindGuard;
use Livewire\Component;

class GeneratePermission extends Component {
    use FindGuard, LivewireAlert;

    public $user;

    public $canAddMarks;
    public $canEditMarks;
    public $validatedData;

    protected $listeners = [
        'confirmed',
        'cancelled',
    ];

    public function mount() {
        $this->user = $this->findGuardType()->user();
        $resultAddMarks = Admin::query()->select( 'canAddMarks' )->distinct()->where( 'role', 2 )->where( 'is_active', 1 )->first();
        $getAddMarks = $resultAddMarks->toArray();

        //echo '<pre>' . $getAddMarks['canAddMarks'] . '</pre>';

        $resultEditMarks = Admin::query()->select( 'canEditMarks' )->distinct()->where( 'role', 3 )->where( 'is_active', 1 )->first();
        $getEditMarks = $resultEditMarks->toArray();

        $this->canAddMarks = $getAddMarks['canAddMarks'];
        $this->canEditMarks = $getEditMarks['canEditMarks'];
    }

    protected array $rules = [
        'canAddMarks'  => [],
        'canEditMarks' => [],
    ];

    /**
     * D0 real time validations
     * @param $propertyName
     * @throws ValidationException
     */
    public function updated( $propertyName ) {
        $this->validateOnly( $propertyName );
    }

    public function savePermission() {

        //0 = admin
        //1 = accounting
        //2 = teacher
        //3 = reg academic

        if ( $this->canAddMarks == 'yes' || $this->canAddMarks == 'no' ) {
            //update teacher status
            Admin::where( 'role', 2 )
                ->where( 'is_active', 1 )
                ->update( ['canAddMarks' => $this->canAddMarks] );
        }

        if ( $this->canEditMarks == 'yes' || $this->canEditMarks == 'no' ) {
            //update reg academic status
            Admin::where( 'role', 3 )
                ->where( 'is_active', 1 )
                ->update( ['canEditMarks' => $this->canEditMarks] );
        }

        $this->alert( 'success', 'Configurações guardadas com sucesso' );
        //return redirect()->route( 'admin.permission' );
    }

    public function confirmed() {
        //get the id
    }

    public function cancelled() {
        $this->alert( 'error', 'Você cancelou.' );
    }

    public function render() {
        return view( 'livewire.admin.reports.generate-permission' );
    }
}
