<?php

namespace App\Http\Livewire\Admin\Sendsms;

use App\Models\Admin;

use App\Models\Classroom;
use App\Models\User;
use Illuminate\Support\Facades\Auth;
use Illuminate\Support\Facades\App;
use App\Models\SendSms;
use Illuminate\Validation\ValidationException;
use Jantinnerezo\LivewireAlert\LivewireAlert;
use LaravelMultipleGuards\Traits\FindGuard;
use Livewire\Component;
use Note\Note;
use App\Http\Controllers\SystemController;
use App\Models\Category;
use Livewire\WithFileUploads;
use Twilio\Rest\Client;
use Exception;

class AddSms extends Component
{
    use FindGuard, LivewireAlert, WithFileUploads;

    public $title, $description, $category_id, $photo, $pdf, $author,  $validatedData, $type, $class_id, $student_id, $student_type, $created_by;
    public $updateMode = false;
    public $user;
    protected $listeners = [
        'confirmed',
        'cancelled'
    ];

    protected array $rules = [
        'title' => ['required', 'string', 'max:255'],
        //'photo' => ['required'], // 2MB Max
        'student_type' => ['required'], // 2MB Max
    ];

    /**
     * D0 real time validations
     * @param $propertyName
     * @throws ValidationException
     */
    public function updated($propertyName)
    {
        $this->validateOnly($propertyName);

    }

    public function submit()
    {
        $user = Auth::user();

        // Ensure the user is not null
    if (!$user) {
        $this->alert('error', 'Usuário não autenticado.');
        return;
    }

        //$this->validatedData = $this->validate();
        if(!empty($this->photo) ){
            $details = SystemController::store_media($this->photo);
            //$pdfd = SystemController::store_media($this->pdf);
            $downloadcenter = SendSms::query()->create([                
            'title' => $this->title,
            'media_name'=> $details[0],
            'media_url'=>$details[1],
            'type'=>$this->type,
            'class_id'=> $this->class_id,
            'student_id'=>$this->student_id,
            'created_by' => $user->id,  // Include the logged-in user's ID
            ]);

        }else{
            $downloadcenter = SendSms::query()->create([
            'title' => $this->title,
            //'media_name'=> $details[0],
            //'media_url'=>$details[1],
            'type'=>$this->type,
            'class_id'=> $this->class_id,
            'student_id'=>$this->student_id,
            'created_by' => $user->id,  // Include the logged-in user's ID

            ]);
        }
        
        if(empty($this->type)){
            $this->type = "all";
        }
        

        if($this->type == "all"){
            $students = User::where("is_paid",$this->student_type)->where("is_active","1")->get();
            
        }elseif($this->type == "class"){   
            $students = User::where("classroom_id",$this->class_id)->where("is_active","1")->get();

        }elseif($this->type == "student"){
            $students = User::where("id",$this->student_id)->get();
        }

        //dd($students);
        foreach($students as $student){
            //echo $student->name." | ".$student->phone_number."<br/>";
       
            
            try {
                $account_sid = getenv("TWILIO_SID");
                $auth_token = getenv("TWILIO_TOKEN");
                $twilio_number = getenv("TWILIO_FROM");
                
                //dd(getenv("TWILIO_TOKEN"));
                //dd(env("TWILIO_SID"), env("TWILIO_TOKEN"), env("TWILIO_FROM"));
                
               
                $client = new Client($account_sid, $auth_token);

                // Generate the callback URL based on your route
                $callbackUrl = route('login');

                // Include the URL on a new line using \n
                $message = "Ola " . $student->name . " ".$this->title;

                $client->messages->create('+258' . $student->phone_number, [
                    'from' => $twilio_number,
                    'body' => $message,
                    'riskCheck' => 'disable' // Disable RiskCheck
                ]);
            } catch (Exception $e) {
                $this->alert('error', 'Erro ao enviar notificações por SMS');
            }

        }



        Note::createSystemNotification(Admin::class, 'Nova SMS', 'Nova SMS enviada com sucesso ' . $this->title);
        $this->emit('noteAdded');
        $this->alert('success', 'Nova SMS enviada com sucesso ' . $this->title);
        $this->reset();
        /**/
    }

    public function confirmed()
    {
        $this->confirm('Tem certeza de que deseja prosseguir?', [
            'toast' => false,
            'position' => 'center',
            'showConfirmButton' => true,
            'confirmButtonText' => 'Sim, eu tenho certeza!',
            'cancelButtonText' => 'Não, cancelar!',
            'onConfirmed' => 'confirmed',
            'onDismissed' => 'cancelled'
        ]);
        
    }

    public function cancelled()
    {
        $this->alert('error', 'Você cancelou.');
    }
    public function render()
    {
        if(!empty($this->type)){
            return view('livewire.admin.sendsms.add-sms', [
                'Classroom' => Classroom::query()->orderBy('class')->get(),
                'students' => User::Where("classroom_id",$this->class_id)->get(),
            ]);
        }else{
            return view('livewire.admin.sendsms.add-sms', [
                'Classroom' => Classroom::query()->orderBy('class')->get(),
            ]);
        }
    }
}
