<?php

namespace App\Http\Livewire\Admin\Students;

use App\Models\User;
use Jantinnerezo\LivewireAlert\LivewireAlert;
use LaravelMultipleGuards\Traits\FindGuard;
use Livewire\Component;
use Livewire\WithPagination;
use Note\Note;
use App\Models\Exam;

class ListStudents extends Component
{
    use WithPagination, FindGuard, LivewireAlert;

    public $search, $delete;
    public $user;
    public $selectedClass = '';
    public $selectedTurma = '';
    public $selectedStatus = '';
    public $selectedPaymentStatus = '';
    public $turmas = [];

    protected $queryString = ['search', 'selectedClass', 'selectedTurma', 'selectedStatus', 'selectedPaymentStatus'];

    protected string $paginationTheme = 'bootstrap';

    public function updatingSearch()
    {
        $this->resetPage();
    }

    public function exportPDF()
    {
        return redirect()->route('admin.students.export.pdf', [
            'class' => $this->selectedClass,
            'turma' => $this->selectedTurma,
            'status' => $this->selectedStatus,
            'payment' => $this->selectedPaymentStatus,
            'search' => $this->search
        ]);
    }

    public function exportExcel()
    {
        return redirect()->route('admin.students.export.excel', [
            'class' => $this->selectedClass,
            'turma' => $this->selectedTurma,
            'status' => $this->selectedStatus,
            'payment' => $this->selectedPaymentStatus,
            'search' => $this->search
        ]);
    }

    public function updatedSelectedClass($value)
    {
        $this->selectedTurma = '';
        $this->resetPage();

        if ($value) {
            $this->turmas = \App\Models\Classroom::where('class', $value)->get();
        } else {
            $this->turmas = [];
        }
    }

    public function updatedSelectedTurma()
    {
        $this->resetPage();
    }

    public function updatedSelectedStatus()
    {
        $this->resetPage();
    }

    public function updatedSelectedPaymentStatus()
    {
        $this->resetPage();
    }

    public bool $readyToLoad = false;

    public function loadData()
    {
        $this->readyToLoad = true;
    }

    protected $listeners = [
        'confirmed',
        'cancelled',
        'complete'
    ];

    public function submit($id)
    {
        $this->delete = User::query()->firstWhere('id', $id);
        $this->confirm('Tem certeza de que deseja prosseguir?', [
            'toast' => false,
            'position' => 'center',
            'showConfirmButton' => true,
            'confirmButtonText' => 'Sim, eu tenho certeza!',
            'cancelButtonText' => 'Não, cancelar!',
            'onConfirmed' => 'confirmed',
            'onDismissed' => 'cancelled'
        ]);
    }

    public function submitcomplete($id)
    {
        $this->delete = User::query()->firstWhere('id', $id);
        $this->confirm('Tem certeza de que deseja marcar como não regurlarizado/pago?', [
            'toast' => false,
            'position' => 'center',
            'showConfirmButton' => true,
            'confirmButtonText' => 'Sim, eu tenho certeza!',
            'cancelButtonText' => 'Não, cancelar!',
            'onConfirmed' => 'complete',
            'onDismissed' => 'cancelled'
        ]);
    }
    public function complete()
    {
        User::query()
            ->where('id', $this->delete->id)
            ->update([
                'is_paid' => false,
            ]);
        Note::createSystemNotification(User::class, 'Estudante', 'Marcado como não pago com sucesso ');
        $this->emit('noteAdded');
        $this->alert('success', 'Marcado como não pago com sucesso ');
        return back();
    }
    public function confirmed()
    {
        //check if already enrolled
        //check if already enrolled
        $check = Exam::query()->where('student_id', $this->delete->id)->get();
        if (count($check) >= 1) {
            $this->alert('warning', 'Desculpa este modelo tem subscritores e nao pode ser deletado');
            return back();
        }        
 	User::where('id', $this->delete->id)->delete();
        Note::createSystemNotification(Admin::class, 'Estudante', 'Deletado com sucesso ');
        $this->emit('noteAdded');
        $this->alert('success', 'Deletado com sucesso ');
        return back();

    }

    public function cancelled()
    {
        $this->alert('error', 'Você cancelou.');
    }
    public function testMethod($userId)
    {
        $this->alert('success', 'Test method executed successfully!'.$userId);
    }

    public function toggleActive($userId)
    {
        $user = User::find($userId);

        if ($user) {
            $user->is_active = !$user->is_active; // Toggle active status
            $user->save();

            $status = $user->is_active ? 'activated' : 'deactivated';
            $this->alert('success', "User has been successfully $status.");
        } else {
            $this->alert('error', 'User not found.');
        }
    }


    public function render()
    {
         $this->user = $this->findGuardType()->user();

         // Buscar todas as classes para o filtro
         $classes = \App\Models\Classroom::select('class')->distinct()->orderBy('class')->get();

        return view('livewire.admin.students.list-students', [
                'models' => $this->readyToLoad
                    ? User::query()
                        ->where(function ($query) {
                            $query->orWhere('name', 'like', '%' . $this->search . '%')
                                ->orWhere('slug', 'like', '%' . $this->search . '%')
				->orWhere('student_id', 'like', '%' . $this->search . '%')
				 ->orWhere('phone_number', 'like', '%' . $this->search . '%');
                        })
                        // Filtro por Classe
                        ->when($this->selectedClass, function ($query) {
                            $query->whereHas('class', function ($subQuery) {
                                $subQuery->where('class', $this->selectedClass);
                            });
                        })
                        // Filtro por Turma específica
                        ->when($this->selectedTurma, function ($query) {
                            $query->where('classroom_id', $this->selectedTurma);
                        })
                        // Filtro por Estado de Acesso (is_active)
                        ->when($this->selectedStatus !== '', function ($query) {
                            $query->where('is_active', $this->selectedStatus);
                        })
                        // Filtro por Estado de Pagamento (is_paid)
                        ->when($this->selectedPaymentStatus !== '', function ($query) {
                            $query->where('is_paid', $this->selectedPaymentStatus);
                        })
    			->orderBy('name') // Order by the 'name' column in alphabetical order
                        ->paginate(10)
                    : [],
                'classes' => $classes
            ]
        );
    }

}
