<?php

namespace App\Http\Livewire\Admin\Subjects;

use App\Models\Admin;
use App\Models\Plan;
use App\Models\Subject;
use Illuminate\Validation\ValidationException;
use Jantinnerezo\LivewireAlert\LivewireAlert;
use LaravelMultipleGuards\Traits\FindGuard;
use Livewire\Component;
use Note\Note;

class AddSubject extends Component
{
    use FindGuard, LivewireAlert;

    public $name,  $validatedData;
    public $updateMode = false;
    public $user;
    protected $listeners = [
        'confirmed',
        'cancelled'
    ];

    protected array $rules = [
        'name' => ['required', 'string', 'max:255'],
    ];

    /**
     * D0 real time validations
     * @param $propertyName
     * @throws ValidationException
     */
    public function updated($propertyName)
    {
        $this->validateOnly($propertyName);
    }

    public function submit()
    {
        $this->validatedData = $this->validate();
        $this->confirm('Tem certeza de que deseja prosseguir?', [
            'toast' => false,
            'position' => 'center',
            'showConfirmButton' => true,
            'confirmButtonText' => 'Sim, eu tenho certeza!',
            'cancelButtonText' => 'Não, cancelar!',
            'onConfirmed' => 'confirmed',
            'onDismissed' => 'cancelled'
        ]);
    }

    public function confirmed()
    {
        Subject::Create([
            'name' => $this->name,
        ]);
        Note::createSystemNotification(Admin::class, 'Disciplina', ' Criada com sucesso ' . $this->name);
        $this->emit('noteAdded');
        $this->alert('success', 'Nova disciplina criada com sucesso ' . $this->name);
        $this->reset();
    }

    public function cancelled()
    {
        $this->alert('error', 'Você cancelou.');
    }

    public function render()
    {
        $recentSubjects = Subject::latest()->take(5)->get();

        return view('livewire.admin.subjects.add-subject', [
            'recentSubjects' => $recentSubjects
        ]);
    }
}
