<?php

namespace App\Models;

use Illuminate\Database\Eloquent\Factories\HasFactory;
use Illuminate\Database\Eloquent\Model;
use Spatie\Sluggable\HasSlug;
use Spatie\Sluggable\SlugOptions;

class Downloadsetings extends Model
{
    //use HasFactory;
    use HasFactory;
    protected $fillable = [
        'type',
         'class_id',
        'student_id',
        'active',
        'download_id',
    ];
    
    public function download()
    {
        return $this->belongsTo(\App\Models\Downloadcenter::class, 'download_id', 'slug');
    }

    public function classroom()
    {
        return $this->belongsTo(\App\Models\Classroom::class, 'class_id', 'id');
    }

    public function student()
    {
        return $this->belongsTo(\App\Models\User::class, 'student_id', 'id');
    }

}



