<?php

namespace App\Models;

use Illuminate\Database\Eloquent\Factories\HasFactory;
use Illuminate\Database\Eloquent\Model;

class FeeStructure extends Model
{
    use HasFactory;

    // Table name (optional if it follows Laravel's convention)
    protected $table = 'fee_structures';

    // Mass assignable fields
    protected $fillable = [
        'grade',
        'monthly_fee',
        'fee_name',
        'late_penalty_percentage',
        'payment_start_day',
        'payment_due_day',
        'active', // Active status column
        'months',
        'grades',
        'palenty_type',
    ];

    // Scope to get active fee structures
    public function scopeActive($query)
    {
        return $query->where('active', 1);
    }

    // Optionally, you can add an accessor to make 'active' more intuitive
    public function getActiveStatusAttribute()
    {
        return $this->active ? 'Active' : 'Inactive';
    }
}

?>
