<!DOCTYPE html>
<html>
<head>
    <meta charset="UTF-8">
    <title>Lista de Matrizes</title>
    <style>
        body {
            font-family: Arial, sans-serif;
            font-size: 12px;
        }
        .header {
            text-align: center;
            margin-bottom: 30px;
            border-bottom: 2px solid #333;
            padding-bottom: 10px;
        }
        .header h1 {
            margin: 0;
            font-size: 20px;
        }
        .header p {
            margin: 5px 0;
            color: #666;
        }
        table {
            width: 100%;
            border-collapse: collapse;
            margin-top: 20px;
        }
        th {
            background-color: #4e73df;
            color: white;
            padding: 10px;
            text-align: left;
            font-size: 11px;
        }
        td {
            padding: 8px;
            border-bottom: 1px solid #ddd;
            font-size: 10px;
        }
        tr:nth-child(even) {
            background-color: #f8f9fa;
        }
        .footer {
            margin-top: 30px;
            text-align: center;
            font-size: 10px;
            color: #666;
        }
        a {
            color: #4e73df;
            text-decoration: underline;
        }
        a:hover {
            color: #2e59d9;
        }
    </style>
</head>
<body>
    <div class="header">
        <h1>COLÉGIO POLITÉCNICO DE MOÇAMBIQUE</h1>
        <p>Lista de Matrizes</p>
        <p>Gerado em: {{ date('d/m/Y H:i') }}</p>
    </div>

    <table>
        <thead>
            <tr>
                @foreach($headings as $heading)
                    <th>{{ $heading }}</th>
                @endforeach
            </tr>
        </thead>
        <tbody>
            @foreach($matrizes as $matriz)
                <tr>
                    <td>{{ $matriz['para'] }}</td>
                    <td>{{ $matriz['classe'] }}</td>
                    <td>{{ $matriz['estudante'] }}</td>
                    <td>{{ $matriz['titulo'] }}</td>
                    <td>
                        @if(isset($matriz['ficheiros']) && count($matriz['ficheiros']) > 0)
                            @foreach($matriz['ficheiros'] as $file)
                                <a href="{{ $file->media_url }}" style="color: #4e73df; text-decoration: none;">{{ $file->media_name }}</a>
                                @if(!$loop->last)<br>@endif
                            @endforeach
                        @else
                            {{ $matriz['ficheiro'] }}
                        @endif
                    </td>
                    <td>{{ $matriz['data'] }}</td>
                </tr>
            @endforeach
        </tbody>
    </table>

    <div class="footer">
        <p>Total de registros: {{ count($matrizes) }}</p>
    </div>
</body>
</html>