<!DOCTYPE html>
<html lang="pt">
<head>
    <meta charset="UTF-8">
    <title>Extrato Financeiro - {{ $student->name }}</title>
    <style>
        * { margin: 0; padding: 0; box-sizing: border-box; }
        body { font-family: 'DejaVu Sans', sans-serif; font-size: 10px; color: #333; }
        .header { background-color: #667eea; color: white; padding: 15px; margin-bottom: 10px; text-align: center; }
        .school-name { font-size: 14px; font-weight: bold; }
        .document-title { text-align: center; font-size: 13px; font-weight: bold; margin: 10px 0; color: #667eea; }
        .student-info { background-color: #f8f9fa; padding: 10px; margin-bottom: 10px; }
        .info-row { margin-bottom: 3px; }
        table { width: 100%; border-collapse: collapse; margin-bottom: 10px; font-size: 9px; }
        thead { background-color: #667eea; color: white; }
        th { padding: 6px 4px; text-align: left; font-weight: bold; }
        td { padding: 5px 4px; border-bottom: 1px solid #eee; }
        .text-center { text-align: center; }
        .text-right { text-align: right; }
        .summary-box { background-color: #f8f9fa; padding: 10px; margin-top: 10px; }
        .summary-row { margin-bottom: 3px; font-size: 9px; }
        .footer { margin-top: 15px; text-align: center; font-size: 8px; color: #777; border-top: 1px solid #e0e0e0; padding-top: 10px; }
    </style>
</head>
<body>
    <!-- Header -->
    <div class="header">
        <div class="school-name">COLÉGIO POLITÉCNICO DE MOÇAMBIQUE</div>
        <div style="font-size: 9px;">Email: info@copmoz.ac.mz | Nampula, Moçambique</div>
    </div>

    <!-- Title -->
    <h1 class="document-title">EXTRATO FINANCEIRO {{ $year }}</h1>

    <!-- Student Info -->
    <div class="student-info">
        <div class="info-row"><strong>Nome:</strong> {{ $student->name }}</div>
        <div class="info-row"><strong>ID:</strong> {{ $student->student_id }}</div>
        <div class="info-row"><strong>Classe:</strong> {{ $student->class->class ?? 'N/A' }} | <strong>Turma:</strong> {{ $student->class->name ?? 'N/A' }}</div>
        <div class="info-row"><strong>Gerado em:</strong> {{ $generated_at }}</div>
    </div>

    <!-- Data Table -->
    <table>
        <thead>
            <tr>
                <th width="12%">Período</th>
                <th width="18%">Tipo de Taxa</th>
                <th width="12%">Vencimento</th>
                <th width="12%">Status</th>
                <th width="12%" class="text-right">Base (MT)</th>
                <th width="12%" class="text-right">Multa (MT)</th>
                <th width="12%" class="text-right">Desconto (MT)</th>
                <th width="12%" class="text-right">Pago (MT)</th>
            </tr>
        </thead>
        <tbody>
            @php
                $totalBase = 0;
                $totalFines = 0;
                $totalDiscounts = 0;
                $totalPaid = 0;
            @endphp

            @foreach($data['rows'] as $row)
            @php
                // $row format: [periodo, fee_names, due_date, status, base, fine, discount, net_paid, payment_date]
                $base = (float)str_replace(['.', ','], ['', '.'], $row[4]);
                $fine = (float)str_replace(['.', ','], ['', '.'], $row[5]);
                $discount = (float)str_replace(['.', ','], ['', '.'], $row[6]);
                $paid = (float)str_replace(['.', ','], ['', '.'], $row[7]);

                $totalBase += $base;
                $totalFines += $fine;
                $totalDiscounts += $discount;
                $totalPaid += $paid;
            @endphp
            <tr>
                <td>{{ $row[0] }}</td>
                <td>{{ $row[1] }}</td>
                <td class="text-center">{{ $row[2] }}</td>
                <td>{{ $row[3] }}</td>
                <td class="text-right">{{ $row[4] }}</td>
                <td class="text-right">{{ $row[5] }}</td>
                <td class="text-right">{{ $row[6] }}</td>
                <td class="text-right">{{ $row[7] }}</td>
            </tr>
            @endforeach
        </tbody>
        <tfoot>
            <tr style="font-weight: bold; background-color: #f8f9fa;">
                <td colspan="4" class="text-right">TOTAIS:</td>
                <td class="text-right">{{ number_format($totalBase, 2, ',', '.') }}</td>
                <td class="text-right">{{ number_format($totalFines, 2, ',', '.') }}</td>
                <td class="text-right">{{ number_format($totalDiscounts, 2, ',', '.') }}</td>
                <td class="text-right">{{ number_format($totalPaid, 2, ',', '.') }}</td>
            </tr>
        </tfoot>
    </table>

    <!-- Summary -->
    <div class="summary-box">
        <div class="summary-row"><strong>Total Esperado:</strong> MT {{ number_format($data['summary']['total_annual_value'], 2, ',', '.') }}</div>
        <div class="summary-row"><strong>Total Pago:</strong> MT {{ number_format($data['summary']['total_net_received'], 2, ',', '.') }}</div>
        <div class="summary-row"><strong>Meses Pagos:</strong> {{ $data['summary']['months_paid_count'] }}/{{ $data['summary']['months_with_fees'] }}</div>
        <div class="summary-row"><strong>Taxa de Cumprimento:</strong> {{ $data['summary']['payment_rate'] }}%</div>
    </div>

    <!-- Footer -->
    <div class="footer">
        <p><strong>COLÉGIO POLITÉCNICO DE MOÇAMBIQUE</strong> | Documento gerado automaticamente</p>
        <p>© {{ now()->year }} COPMOZ - Todos os direitos reservados</p>
    </div>
</body>
</html>
