<div>
    <div class="page-content">
        <div class="main-wrapper">
            <div class="card border-0 shadow">
                <div class="card-header bg-primary text-white py-3">
                    <h2 class="h5 mb-0">
                        <i class="fas fa-users-cog me-2"></i>
                        Gestão de Staff
                    </h2>
                </div>

                <div class="card-body">
                    <div class="row justify-content-center">
                        <div class="col-12 col-md-10 col-lg-8 col-xl-7">
                            <form wire:submit.prevent="submit" class="needs-validation" novalidate>
                                <!-- Nome Completo -->
                                <div class="form-group mb-3">
                                    <label for="name" class="form-label fw-semibold">Nome Completo <span class="text-danger">*</span></label>
                                    <div class="input-group">
                                        <span class="input-group-text bg-light"><i class="fas fa-user"></i></span>
                                        <input type="text"
                                               id="name"
                                               wire:model="name"
                                               class="form-control @error('name') is-invalid @enderror"
                                               placeholder="Ex: João Silva"
                                               required>
                                    </div>
                                    @error('name') <span class="text-danger small">{{ $message }}</span> @enderror
                                </div>

                                <!-- Email -->
                                <div class="form-group mb-3">
                                    <label for="email" class="form-label fw-semibold">Email <span class="text-danger">*</span></label>
                                    <div class="input-group">
                                        <span class="input-group-text bg-light"><i class="fas fa-envelope"></i></span>
                                        <input type="email"
                                               id="email"
                                               wire:model="email"
                                               class="form-control @error('email') is-invalid @enderror"
                                               placeholder="Ex: joao@copmoz.ac.mz"
                                               required>
                                    </div>
                                    @error('email') <span class="text-danger small">{{ $message }}</span> @enderror
                                </div>

                                <!-- Número Celular -->
                                <div class="form-group mb-3">
                                    <label for="phone_number" class="form-label fw-semibold">Número Celular <span class="text-danger">*</span></label>
                                    <div class="input-group">
                                        <span class="input-group-text bg-light"><i class="fas fa-phone"></i></span>
                                        <input type="text"
                                               id="phone_number"
                                               wire:model="phone_number"
                                               class="form-control @error('phone_number') is-invalid @enderror"
                                               placeholder="Ex: 845123456"
                                               required>
                                    </div>
                                    @error('phone_number') <span class="text-danger small">{{ $message }}</span> @enderror
                                </div>

                                <!-- Privilégio/Função -->
                                <div class="form-group mb-4">
                                    <label for="role" class="form-label fw-semibold">Função/Privilégio <span class="text-danger">*</span></label>
                                    <div class="input-group">
                                        <span class="input-group-text bg-light"><i class="fas fa-user-tag"></i></span>
                                        <select id="role"
                                                wire:model="role"
                                                class="form-select @error('role') is-invalid @enderror"
                                                required>
                                            <option value="">Selecione a função...</option>
                                            <option value="0">Admin</option>
                                            <option value="1">Contabilidade</option>
                                            <option value="2">Professor</option>
                                            <option value="3">Reg. Acadêmico</option>
                                        </select>
                                    </div>
                                    @error('role') <span class="text-danger small">{{ $message }}</span> @enderror
                                </div>

                                <!-- Botões -->
                                <div class="d-grid gap-2">
                                    <button type="submit"
                                            class="btn btn-primary btn-lg"
                                            wire:loading.attr="disabled"
                                            wire:offline.attr="disabled">
                                        <span wire:loading.remove wire:target="submit">
                                            <i class="fas fa-save me-2"></i>Guardar
                                        </span>
                                        <span wire:loading wire:target="submit">
                                            <span class="spinner-border spinner-border-sm me-2"></span>
                                            Processando...
                                        </span>
                                    </button>
                                </div>
                            </form>
                        </div>
                    </div>
                </div>
            </div>
        </div>
    </div>

    <style>
        .form-label.fw-semibold {
            font-weight: 600;
            color: #495057;
        }

        .input-group-text {
            background-color: #f8f9fa;
            border-right: none;
        }

        .input-group .form-control,
        .input-group .form-select {
            border-left: none;
        }

        .input-group .form-control:focus,
        .input-group .form-select:focus {
            border-color: #ced4da;
            box-shadow: none;
        }

        .input-group:focus-within .input-group-text {
            border-color: #80bdff;
        }
    </style>
</div>
