<div class="page-content">
    <div class="container-fluid">
        <!-- Page Header -->
        <div class="row mb-4 mt-3">
            <div class="col-12">
                <div class="d-flex justify-content-between align-items-center">
                    <div class="pt-3">
                        <h1 class="h3 mb-1 text-primary">
                            <i class="fas fa-users-cog me-2"></i>Lista de Staff
                        </h1>
                        <p class="text-muted mb-0">
                            Gerencie os membros da equipe administrativa
                        </p>
                    </div>
                </div>
            </div>
        </div>

        <!-- Filters Card -->
        <div class="card border-0 shadow-sm mb-4">
            <div class="card-body">
                <div class="d-flex justify-content-between align-items-center mb-4">
                    <h5 class="card-title mb-0 text-primary">
                        <i class="fas fa-filter me-2"></i>Filtros de Pesquisa
                    </h5>
                    <div class="btn-group" role="group">
                        <button type="button" wire:click="exportPDF" class="btn btn-danger btn-sm">
                            <i class="fa fa-file-pdf me-1"></i>PDF
                        </button>
                        <button type="button" wire:click="exportExcel" class="btn btn-success btn-sm">
                            <i class="fa fa-file-excel me-1"></i>Excel
                        </button>
                    </div>
                </div>

                <div class="row g-3">
                    <div class="col-md-3">
                        <label for="selectedRole" class="form-label">Função</label>
                        <select class="form-select" wire:model="selectedRole" id="selectedRole">
                            <option value="">Todas</option>
                            <option value="0">Admin</option>
                            <option value="1">Contabilidade</option>
                            <option value="2">Professor</option>
                            <option value="3">Reg. Acadêmico</option>
                        </select>
                    </div>

                    <div class="col-md-3">
                        <label for="selectedStatus" class="form-label">Estado</label>
                        <select class="form-select" wire:model="selectedStatus" id="selectedStatus">
                            <option value="">Todos</option>
                            <option value="1">Ativo</option>
                            <option value="0">Suspenso</option>
                        </select>
                    </div>

                    <div class="col-md-6">
                        <label for="search" class="form-label">Pesquisar</label>
                        <input
                            type="search"
                            wire:model.debounce.300ms="search"
                            placeholder="Buscar por nome, email ou telefone..."
                            class="form-control"
                            id="search"
                        />
                    </div>
                </div>
            </div>
        </div>

        <!-- Table Card -->
        <div class="card border-0 shadow-sm">
            <div class="card-body" wire:init="loadData">
                <div class="table-responsive">
                    @if(count($users))
                        <table class="table table-hover align-middle mb-0">
                            <thead class="bg-light">
                                <tr>
                                    <th style="width: 50px;">#</th>
                                    <th>Nome Completo</th>
                                    <th>Email</th>
                                    <th>Telefone</th>
                                    <th>Função</th>
                                    <th>Estado</th>
                                    <th>Data de Registro</th>
                                    <th class="text-end pe-4" style="width: 100px;">Ações</th>
                                </tr>
                            </thead>
                            <tbody>
                            @foreach($users as $user)
                                <tr style="transition: all 0.2s;">
                                    <td><span class="text-muted fw-bold">{{ $loop->iteration }}</span></td>
                                    <td>
                                        <strong class="text-dark">{{ $user->name }}</strong>
                                    </td>
                                    <td>
                                        <span class="text-muted">{{ $user->email }}</span>
                                    </td>
                                    <td>
                                        <span class="text-muted">{{ $user->phone_number }}</span>
                                    </td>
                                    <td>
                                        @if ($user->role == 2)
                                            <span class="badge bg-info">Professor</span>
                                        @elseif ($user->role == 3)
                                            <span class="badge bg-warning">Reg. Acadêmico</span>
                                        @elseif ($user->role == 1)
                                            <span class="badge bg-primary">Contabilidade</span>
                                        @elseif ($user->role == 0)
                                            <span class="badge bg-dark">Admin</span>
                                        @endif
                                    </td>
                                    <td>
                                        @if ($user->is_active)
                                            <span class="badge bg-success">Ativo</span>
                                        @else
                                            <span class="badge bg-danger">Suspenso</span>
                                        @endif
                                    </td>
                                    <td>
                                        <small class="text-muted">{{ $user->created_at->format('d/m/Y H:i') }}</small>
                                    </td>
                                    <td>
                                        <div class="btn-group btn-group-sm" role="group">
                                            <a href="{{ route('admin.edit.admin', $user->slug) }}"
                                                class="btn btn-outline-primary btn-sm"
                                                title="Editar">
                                                <span class="fa fa-edit"></span>
                                            </a>
                                        </div>
                                    </td>
                                </tr>
                            @endforeach
                            </tbody>
                        </table>

                        <div class="d-flex justify-content-center mt-3">
                            {{ $users->links() }}
                        </div>
                    @else
                        <div class="text-center py-5">
                            <div wire:loading class="spinner-border text-primary mb-3" role="status">
                                <span class="visually-hidden">Processando...</span>
                            </div>
                            <p class="text-muted"><strong>Nenhum membro da equipe foi encontrado.</strong></p>
                        </div>
                    @endif
                </div>
            </div>
        </div>
    </div>

    <style>
        .table-hover tbody tr:hover {
            background-color: #f8f9fa;
            transform: translateY(-2px);
            box-shadow: 0 2px 4px rgba(0,0,0,0.05);
        }

        .form-select:focus, .form-control:focus {
            border-color: #4e73df;
            box-shadow: 0 0 0 0.2rem rgba(78, 115, 223, 0.25);
        }

        .btn-group-sm .btn {
            padding: 0.25rem 0.5rem;
        }
    </style>
</div>
