 <div>
    <div class="page-content" wire:init="loadData">

        <div class="main-wrapper" wire:init="loadData">
            <!-- Advanced Filters -->
            <div class="card border-0 shadow-sm mb-4">
                <div class="card-header bg-primary text-white py-3">
                    <h5 class="mb-0"><i class="fas fa-filter me-2"></i>Filtros Avançados</h5>
                </div>
                <div class="card-body">
                    <div class="row g-3">
                        <!-- Search -->
                        <div class="col-md-3">
                            <label for="search" class="form-label fw-semibold">Pesquisar</label>
                            <div class="input-group">
                                <span class="input-group-text bg-light"><i class="fas fa-search"></i></span>
                                <input type="search"
                                       wire:model="search"
                                       id="search"
                                       placeholder="Título ou autor..."
                                       class="form-control">
                            </div>
                        </div>

                        <!-- Category -->
                        <div class="col-md-3">
                            <label for="category_id" class="form-label fw-semibold">Categoria</label>
                            <div class="input-group">
                                <span class="input-group-text bg-light"><i class="fas fa-folder"></i></span>
                                <select wire:model="category_id" id="category_id" class="form-select">
                                    <option value="">Todas as Categorias</option>
                                    @foreach($categories as $category)
                                        <option value="{{ $category->id }}">{{ $category->name }}</option>
                                    @endforeach
                                </select>
                            </div>
                        </div>

                        <!-- Author -->
                        <div class="col-md-3">
                            <label for="author" class="form-label fw-semibold">Autor</label>
                            <div class="input-group">
                                <span class="input-group-text bg-light"><i class="fas fa-user-edit"></i></span>
                                <select wire:model="author" id="author" class="form-select">
                                    <option value="">Todos os Autores</option>
                                    @foreach($authors as $authorName)
                                        <option value="{{ $authorName }}">{{ $authorName }}</option>
                                    @endforeach
                                </select>
                            </div>
                        </div>

                        <!-- Status -->
                        <div class="col-md-3">
                            <label for="is_active" class="form-label fw-semibold">Status</label>
                            <div class="input-group">
                                <span class="input-group-text bg-light"><i class="fas fa-toggle-on"></i></span>
                                <select wire:model="is_active" id="is_active" class="form-select">
                                    <option value="">Todos os Status</option>
                                    <option value="1">Ativo</option>
                                    <option value="0">Inativo</option>
                                </select>
                            </div>
                        </div>
                    </div>

                    <!-- Clear Filters Button -->
                    <div class="row mt-3">
                        <div class="col-12 d-flex justify-content-end">
                            <button wire:click="clearFilters" class="btn btn-outline-secondary">
                                <i class="fas fa-redo me-2"></i>Limpar Filtros
                            </button>
                        </div>
                    </div>
                </div>
            </div>
            @if (count($models))
                <div class="row">
                    @foreach ($models as $model)
                        <div class="col-md-3 col-lg-3">
                            <div class="card h-100">
                                <a href="#"><img class="card-img-top" src="{{ $model->media_url }}"
                                        style="height: 250px;" alt=""></a>
                                <div class="card-body">
                                     <h6>{{ $model->title }} &nbsp; <i>por: {{ $model->author }}</i></h6>
                                    <p class="card-text">{!! Str::limit($model->description, 50, ' .......') !!}</p>
                                    <a href="{{ route('admin.edit.book', $model->slug) }}"
                                        class="btn btn-block btn-outline-primary btn-sm"><span
                                            class="fa fa-edit"></span>
                                    </a>
                                    <a type="button" wire:click="submit('{{ $model->id }}')"
                                        class="btn btn-outline-danger"><span class="fa fa-trash"></span></a>
                                    <a href="{{ route('admin.show.book', $model->slug) }}"
                                        class="btn btn-outline-primary"><span class="fa fa-eye"></span>
                                    </a>
                                    <a href="{{ route('pd', $model->slug) }}"
                                        class="btn btn-outline-secondary btn-sm"> <span class="fas fa-book-reader"></i></span>
                                    </a>
                                </div>
                            </div>
                        </div>
                    @endforeach
                </div> 
                
                <div class="row float-end">
                    {{ $models->links() }}
                </div>
            @else
                <br>
                <br>
                <div class="d-flex justify-content-center">
                    <div wire:loading class="spinner-border text-primary" role="status">
                        <span class="sr-only">Processando...</span>
                    </div>
                </div>
                <p class="text-center"><B>Nenhum dado foi encontrado no momento.</B></p>
            @endif
        </div>

    </div>
</div>
