<div>
    <div class="page-content">
        <div class="main-wrapper">
            <div class="row">
                <div class="col">
                    <div class="card border-0 shadow">
                        <div class="card-header bg-primary text-white py-3 d-flex justify-content-between align-items-center">
                            <h2 class="h5 mb-0">
                                <i class="fas fa-book me-2"></i>Lista de Livros e Capítulos
                            </h2>
                            <a href="{{ route('admin.add.chapter') }}" class="btn btn-light btn-sm">
                                <i class="fas fa-plus me-1"></i>Novo Capítulo
                            </a>
                        </div>
                        <div class="card-body p-4" wire:init="loadData">
                            <!-- Search Bar -->
                            <div class="row mb-4">
                                <div class="col-md-12">
                                    <div class="input-group">
                                        <span class="input-group-text bg-light"><i class="fas fa-search"></i></span>
                                        <input type="search"
                                               wire:model="search"
                                               placeholder="Pesquisar por título..."
                                               class="form-control">
                                    </div>
                                </div>
                            </div>

                            <!-- Table -->
                            <div class="table-responsive" wire:init="loadData">
                                @if(count($models))
                                    <table class="table table-hover align-middle">
                                        <thead class="table-light">
                                            <tr>
                                                <th scope="col" style="width: 5%">#</th>
                                                <th scope="col">Título</th>
                                                <th scope="col" style="width: 15%">Capítulos</th>
                                                <th scope="col" style="width: 20%">Data/Hora</th>
                                                <th scope="col" class="text-end" style="width: 15%">Ações</th>
                                            </tr>
                                        </thead>
                                        <tbody>
                                        @php($count = 1)
                                        @foreach($models as $model)
                                            <tr>
                                                <th scope="row" class="text-muted">{{ $count++ }}</th>
                                                <td>
                                                    <div class="d-flex align-items-center">
                                                        <i class="fas fa-book text-primary me-2"></i>
                                                        <strong>{{ $model->title }}</strong>
                                                    </div>
                                                </td>
                                                <td>
                                                    <a href="{{ route('admin.list.book.chapter', $model->slug) }}"
                                                       class="btn btn-sm btn-outline-info">
                                                        <i class="fa fa-eye me-1"></i>
                                                        Ver ({{ $model->chapters->count() }})
                                                    </a>
                                                </td>
                                                <td class="text-muted">
                                                    <i class="far fa-clock me-1"></i>
                                                    {{ date('d/m/Y H:i', strtotime($model->created_at)) }}
                                                </td>
                                                <td>
                                                    <div class="d-flex gap-2 justify-content-end">
                                                        <a href="{{ route('admin.edit.book', $model->slug) }}"
                                                           class="btn btn-sm btn-outline-primary"
                                                           title="Editar">
                                                            <i class="fa fa-edit"></i>
                                                        </a>
                                                        <button wire:click="submit('{{ $model->id }}')"
                                                                class="btn btn-sm btn-outline-danger"
                                                                title="Deletar">
                                                            <i class="fa fa-trash"></i>
                                                        </button>
                                                    </div>
                                                </td>
                                            </tr>
                                        @endforeach
                                        </tbody>
                                    </table>

                                    <!-- Pagination -->
                                    <div class="d-flex justify-content-end mt-3">
                                        {{ $models->links() }}
                                    </div>
                                @else
                                    <div class="text-center py-5">
                                        <div wire:loading class="spinner-border text-primary mb-3" role="status">
                                            <span class="visually-hidden">Processando...</span>
                                        </div>
                                        <div wire:loading.remove>
                                            <i class="fas fa-book-open fa-3x text-muted mb-3"></i>
                                            <p class="text-muted"><strong>Nenhum dado foi encontrado no momento.</strong></p>
                                        </div>
                                    </div>
                                @endif
                            </div>
                        </div>
                    </div>
                </div>
            </div>
        </div>
    </div>
</div>
