<div>
    <div class="page-content">
        <div class="main-wrapper">
            <div class="row">
                <div class="col">
                    <div class="card">
                        <div class="card-body">
                            <h5 class="card-title">Atualizar Plano de Taxa</h5>
                            <form class="row g-3" wire:submit.prevent="updateFeeMaster"> <!-- Updated submit function -->
                                
                               <!-- Fees Group -->
                            <div class="col-md-12">
                                <label for="fees_group" class="form-label">Grupo de Taxa</label>
                                <select class="form-control @error('fees_group') is-invalid @enderror" id="fees_group" wire:model="fees_group">
                                    <option value="">Selecionar grupo de taxa</option>
                                    @foreach ($FeeGroups as $group)
                                        <option value="{{ $group->id }}" @if($group->id == $fees_group) selected @endif>{{ $group->name }}</option>
                                    @endforeach
                                </select>
                                @error('fees_group')
                                <span class="invalid-feedback" role="alert">
                                    <strong>{{ $message }}</strong>
                                </span>
                                @enderror 
                            </div>

                            <!-- Fees Type -->
                            <div class="col-md-12">
                                <label for="fees_type" class="form-label">Tipo de Taxa</label>
                                <select class="form-control @error('fees_type') is-invalid @enderror" id="fees_type" wire:model="fees_type">
                                    <option value="">Selecionar tipo de taxa</option>
                                    @foreach ($FeeTypes as $type)
                                        <option value="{{ $type->id }}" @if($type->id == $fees_type) selected @endif>{{ $type->name }}</option>
                                    @endforeach
                                </select>
                                @error('fees_type')
                                <span class="invalid-feedback" role="alert">
                                    <strong>{{ $message }}</strong>
                                </span>
                                @enderror
                            </div>

                                <!-- Due Date -->
                                <div class="col-md-12">
                                    <label for="due_date" class="form-label">Data de Vencimento</label>
                                    <input type="date" class="form-control @error('due_date') is-invalid @enderror"
                                           id="due_date" wire:model.lazy="due_date">
                                    @error('due_date')
                                    <span class="invalid-feedback" role="alert">
                                        <strong>{{ $message }}</strong>
                                    </span>
                                    @enderror
                                </div>

                                <!-- Amount -->
                                <div class="col-md-12">
                                    <label for="amount" class="form-label">Montante</label>
                                    <input type="number" class="form-control @error('amount') is-invalid @enderror"
                                           id="amount" placeholder="Insira o montante..." wire:model.lazy="amount">
                                    @error('amount')
                                    <span class="invalid-feedback" role="alert">
                                        <strong>{{ $message }}</strong>
                                    </span>
                                    @enderror
                                </div>

                                <!-- Fine Types -->
                                <div class="col-md-12">
                                    <label class="form-label">Tipo de Multa</label><br>
                                    <div class="form-check form-check-inline">
                                        <input class="form-check-input" type="radio" wire:model="fine_type" value="none" id="fineNone">
                                        <label class="form-check-label" for="fineNone">Nenhum</label>
                                    </div>
                                    <div class="form-check form-check-inline">
                                        <input class="form-check-input" type="radio" wire:model="fine_type" value="percentage" id="finePercentage">
                                        <label class="form-check-label" for="finePercentage">Percentagem</label>
                                    </div>
                                    <div class="form-check form-check-inline">
                                        <input class="form-check-input" type="radio" wire:model="fine_type" value="amount" id="fineAmount">
                                        <label class="form-check-label" for="fineAmount">Valor fixo</label>
                                    </div>
                                    @error('fine_type')
                                    <span class="invalid-feedback" role="alert">
                                        <strong>{{ $message }}</strong>
                                    </span>
                                    @enderror
                                </div>

                                <!-- Percentage and Fixed Amount Row -->
                                <div class="row">
                                    @if($fine_type === 'percentage')
                                    <!-- Percentage Field -->
                                    <div class="col-md-6">
                                        <label for="percentage" class="form-label">Percentagem</label>
                                        <input type="number" class="form-control @error('percentage') is-invalid @enderror"
                                            id="percentage" placeholder="Insira o valor (%)..." wire:model.lazy="percentage">
                                        @error('percentage')
                                        <span class="invalid-feedback" role="alert">
                                            <strong>{{ $message }}</strong>
                                        </span>
                                        @enderror
                                    </div>
                                    @endif

                                    @if($fine_type === 'amount')
                                    <!-- Fixed Amount Field -->
                                    <div class="col-md-6">
                                        <label for="fixed_amount" class="form-label">Valor fixo</label>
                                        <input type="number" class="form-control @error('fixed_amount') is-invalid @enderror"
                                            id="fixed_amount" placeholder="Insira o valor fixo..." wire:model.lazy="fixed_amount">
                                        @error('fixed_amount')
                                        <span class="invalid-feedback" role="alert">
                                            <strong>{{ $message }}</strong>
                                        </span>
                                        @enderror
                                    </div>
                                    @endif
                                </div>

                                <!-- Submit Button -->
                                <div class="col-12">
                                    <button type="submit" class="btn btn-primary btn-lg float-end"
                                            wire:loading.attr="disabled">
                                        <span wire:loading.class="spinner-border spinner-border-sm"></span>
                                        Atualizar
                                    </button>
                                </div>
                            </form>
                        </div>
                    </div>
                </div>
            </div>
        </div>
    </div>
</div>
