{{-- resources/views/livewire/admin/fee/payment-reconciliation-dashboard.blade.php --}}
<div>
    <div class="page-content">
        <div class="main-wrapper">
            <div class="row">
                <div class="col">
                    <div class="card">
                        <div class="card-body">
                            <!-- Header Section -->
                            <div class="d-flex justify-content-between align-items-center mb-4">
                                <div>
                                    <h5 class="card-title mb-1">
                                        <i class="fas fa-sync-alt me-2 text-primary"></i>
                                        Dashboard de Reconciliação Bancária
                                    </h5>
                                    <p class="text-muted mb-0">Gestão completa de reconciliações BMEPS/MEPS e pagamentos manuais</p>
                                </div>
                                <div class="d-flex gap-2">
                                    <button wire:click="runAutomaticReconciliation" class="btn btn-primary" wire:loading.attr="disabled">
                                        <i class="fas fa-robot" wire:loading.remove></i>
                                        <i class="fas fa-spinner fa-spin" wire:loading></i>
                                        <span wire:loading.remove>Processar Automático</span>
                                        <span wire:loading>Processando...</span>
                                    </button>
                                    <button wire:click="openManualReconciliation" class="btn btn-success">
                                        <i class="fas fa-plus"></i> Reconciliação Manual
                                    </button>
                                    <button wire:click="exportReconciliationReport" class="btn btn-info">
                                        <i class="fas fa-download"></i> Exportar
                                    </button>
                                </div>
                            </div>

    <!-- Statistics -->
    <div class="recon-stats-grid">
        <div class="recon-stat-card">
            <div class="recon-stat-header">
                <div class="recon-stat-icon today"><i class="fas fa-calendar-day"></i></div>
                <h3 class="recon-stat-title">Hoje</h3>
            </div>
            <div class="recon-stat-metrics">
                <div class="recon-metric">
                    <span class="recon-metric-value">{{ $stats['today']['reconciled_payments'] ?? 0 }}</span>
                    <span class="recon-metric-label">Reconciliados</span>
                </div>
                <div class="recon-metric">
                    <span class="recon-metric-value">MT {{ number_format($stats['today']['total_amount'] ?? 0, 2, ',', '.') }}</span>
                    <span class="recon-metric-label">Valor Total</span>
                </div>
                <div class="recon-metric">
                    <span class="recon-metric-value">{{ $stats['today']['processed_files'] ?? 0 }}</span>
                    <span class="recon-metric-label">Ficheiros</span>
                </div>
            </div>
        </div>

        <div class="recon-stat-card">
            <div class="recon-stat-header">
                <div class="recon-stat-icon week"><i class="fas fa-calendar-week"></i></div>
                <h3 class="recon-stat-title">Esta Semana</h3>
            </div>
            <div class="recon-stat-metrics">
                <div class="recon-metric">
                    <span class="recon-metric-value">{{ $stats['week']['reconciled_payments'] ?? 0 }}</span>
                    <span class="recon-metric-label">Reconciliados</span>
                </div>
                <div class="recon-metric">
                    <span class="recon-metric-value">{{ $stats['week']['success_rate'] ?? 0 }}%</span>
                    <span class="recon-metric-label">Taxa Sucesso</span>
                </div>
                <div class="recon-metric">
                    <span class="recon-metric-value">MT {{ number_format($stats['week']['total_amount'] ?? 0, 2, ',', '.') }}</span>
                    <span class="recon-metric-label">Valor Total</span>
                </div>
            </div>
        </div>

        <div class="recon-stat-card">
            <div class="recon-stat-header">
                <div class="recon-stat-icon month"><i class="fas fa-calendar-alt"></i></div>
                <h3 class="recon-stat-title">Este Mês</h3>
            </div>
            <div class="recon-stat-metrics">
                <div class="recon-metric">
                    <span class="recon-metric-value">{{ $stats['month']['reconciled_payments'] ?? 0 }}</span>
                    <span class="recon-metric-label">Reconciliados</span>
                </div>
                <div class="recon-metric">
                    <span class="recon-metric-value">{{ $stats['month']['average_processing_time'] ?? 0 }}s</span>
                    <span class="recon-metric-label">Tempo Médio</span>
                </div>
                <div class="recon-metric">
                    <span class="recon-metric-value">MT {{ number_format($stats['month']['total_amount'] ?? 0, 2, ',', '.') }}</span>
                    <span class="recon-metric-label">Valor Total</span>
                </div>
            </div>
        </div>

        <div class="recon-stat-card">
            <div class="recon-stat-header">
                <div class="recon-stat-icon pending"><i class="fas fa-clock"></i></div>
                <h3 class="recon-stat-title">Pendentes</h3>
            </div>
            <div class="recon-stat-metrics">
                <div class="recon-metric">
                    <span class="recon-metric-value">{{ $stats['pending']['incoming_files'] ?? 0 }}</span>
                    <span class="recon-metric-label">Ficheiros</span>
                </div>
                <div class="recon-metric">
                    <span class="recon-metric-value">{{ $stats['pending']['unmatched_payments'] ?? 0 }}</span>
                    <span class="recon-metric-label">Não Coincidentes</span>
                </div>
                <div class="recon-metric">
                    <span class="recon-metric-value">{{ $stats['pending']['expired_references'] ?? 0 }}</span>
                    <span class="recon-metric-label">Referências Expiradas</span>
                </div>
            </div>
        </div>
    </div>

    <!-- Charts Section -->
    <div class="row mb-4">
        <!-- Payments Chart -->
        <div class="col-lg-8 mb-4">
            <div class="card border-0 shadow-sm">
                <div class="card-header bg-white border-bottom py-3">
                    <h5 class="mb-0"><i class="fas fa-chart-line text-primary me-2"></i>Volume de Pagamentos (Últimos 7 Dias)</h5>
                </div>
                <div class="card-body">
                    <canvas id="paymentsChart" height="80"></canvas>
                </div>
            </div>
        </div>

        <!-- Status Distribution Chart -->
        <div class="col-lg-4 mb-4">
            <div class="card border-0 shadow-sm">
                <div class="card-header bg-white border-bottom py-3">
                    <h5 class="mb-0"><i class="fas fa-chart-pie text-success me-2"></i>Distribuição de Status</h5>
                </div>
                <div class="card-body">
                    <canvas id="statusChart" height="200"></canvas>
                    <div class="mt-3">
                        <div class="d-flex justify-content-between align-items-center mb-2">
                            <span><i class="fas fa-circle text-success me-2" style="font-size: 10px;"></i>Reconciliados</span>
                            <strong>{{ $stats['week']['reconciled_payments'] ?? 0 }}</strong>
                        </div>
                        <div class="d-flex justify-content-between align-items-center mb-2">
                            <span><i class="fas fa-circle text-warning me-2" style="font-size: 10px;"></i>Pendentes</span>
                            <strong>{{ $stats['pending']['unmatched_payments'] ?? 0 }}</strong>
                        </div>
                        <div class="d-flex justify-content-between align-items-center">
                            <span><i class="fas fa-circle text-danger me-2" style="font-size: 10px;"></i>Falhados</span>
                            <strong>{{ $stats['today']['failed_transactions'] ?? 0 }}</strong>
                        </div>
                    </div>
                </div>
            </div>
        </div>

        <!-- Monthly Trend Chart -->
        <div class="col-lg-6 mb-4">
            <div class="card border-0 shadow-sm">
                <div class="card-header bg-white border-bottom py-3">
                    <h5 class="mb-0"><i class="fas fa-chart-bar text-info me-2"></i>Tendência Mensal de Valores</h5>
                </div>
                <div class="card-body">
                    <canvas id="monthlyTrendChart" height="100"></canvas>
                </div>
            </div>
        </div>

        <!-- Success Rate Chart -->
        <div class="col-lg-6 mb-4">
            <div class="card border-0 shadow-sm">
                <div class="card-header bg-white border-bottom py-3">
                    <h5 class="mb-0"><i class="fas fa-percentage text-purple me-2"></i>Taxa de Sucesso Semanal</h5>
                </div>
                <div class="card-body">
                    <canvas id="successRateChart" height="100"></canvas>
                    <div class="text-center mt-3">
                        <h3 class="text-success mb-0">{{ $stats['week']['success_rate'] ?? 0 }}%</h3>
                        <p class="text-muted mb-0">Taxa de sucesso desta semana</p>
                    </div>
                </div>
            </div>
        </div>
    </div>

    <!-- Main Grid -->
    <div class="recon-main-grid">
        <!-- Upload Section -->
        <div class="recon-section">
            <div class="recon-section-header">
                <h2 class="recon-section-title"><i class="fas fa-upload"></i> Carregar Ficheiro</h2>
                <span class="recon-badge">Manual</span>
            </div>
            <div class="recon-section-content">
                @if(!$uploadedFile)
                    <div class="recon-upload-zone"
                         x-data="{ 
                             dragover: false,
                             handleDragOver(e) { 
                                 e.preventDefault(); 
                                 this.dragover = true; 
                             },
                             handleDragLeave() { 
                                 this.dragover = false; 
                             },
                             handleDrop(e) { 
                                 e.preventDefault(); 
                                 this.dragover = false;
                                 if(e.dataTransfer.files.length > 0) {
                                     @this.set('uploadedFile', e.dataTransfer.files[0]);
                                 }
                             }
                         }"
                         :class="{ 'dragover': dragover }"
                         @dragover="handleDragOver"
                         @dragleave="handleDragLeave"
                         @drop="handleDrop"
                         onclick="document.getElementById('fileInput').click()">
                        <div class="recon-upload-icon">
                            <i class="fas fa-cloud-upload-alt"></i>
                        </div>
                        <h3 class="recon-upload-text">Arraste o ficheiro aqui ou clique para selecionar</h3>
                        <p class="recon-upload-subtext">Suporta ficheiros .txt/.TXT (máx. 10MB)</p>
                        <input type="file" wire:model="uploadedFile" accept=".txt,.TXT" class="recon-file-input" id="fileInput">
                        <button type="button" class="recon-btn recon-btn-outline">
                            <i class="fas fa-folder-open"></i> Selecionar Ficheiro
                        </button>
                    </div>
                @else
                    <div class="recon-file-preview">
                        <div class="recon-file-info">
                            <i class="fas fa-file-alt recon-text-info"></i>
                            <div class="recon-file-details">
                                <h4>{{ $uploadedFile->getClientOriginalName() }}</h4>
                                <p>{{ number_format($uploadedFile->getSize() / 1024, 2) }} KB</p>
                            </div>
                        </div>
                        
                        @if($uploadProgress > 0)
                            <div class="recon-progress-container">
                                <div class="recon-progress-bar">
                                    <div class="recon-progress-fill" style="width: {{ $uploadProgress }}%"></div>
                                </div>
                                <span class="recon-progress-text">{{ $uploadProgress }}%</span>
                            </div>
                        @endif
                        
                        <div class="recon-actions">
                            <button wire:click="processUploadedFile" class="recon-btn recon-btn-success"
                                    wire:loading.attr="disabled"
                                    @if($uploadProgress > 0 && $uploadProgress < 100) disabled @endif>
                                <i class="fas fa-play" wire:loading.remove></i>
                                <i class="fas fa-spinner recon-spinner" wire:loading></i>
                                Processar
                            </button>
                            <button wire:click="$set('uploadedFile', null)" class="recon-btn recon-btn-outline">
                                <i class="fas fa-times"></i> Cancelar
                            </button>
                        </div>
                    </div>
                @endif
            </div>
        </div>

        <!-- Incoming Files -->
        <div class="recon-section">
            <div class="recon-section-header">
                <h2 class="recon-section-title"><i class="fas fa-folder-open"></i> Ficheiros Pendentes</h2>
                <span class="recon-badge">{{ $incoming_files ? $incoming_files->count() : 0 }}</span>
            </div>
            <div class="recon-section-content">
                @if($incoming_files && $incoming_files->count() > 0)
                    <div class="recon-list">
                        @foreach($incoming_files as $file)
                            <div class="recon-list-item">
                                <div class="recon-list-icon">
                                    <i class="fas fa-file-alt"></i>
                                </div>
                                <div class="recon-list-content">
                                    <h4 class="recon-list-title">{{ $file['name'] }}</h4>
                                    <div class="recon-list-meta">
                                        <span><i class="fas fa-weight"></i> {{ $file['size_formatted'] }}</span>
                                        <span><i class="fas fa-clock"></i> {{ $file['modified_at']->format('d/m/Y H:i') }}</span>
                                    </div>
                                </div>
                                <button wire:click="deleteIncomingFile('{{ $file['name'] }}')"
                                        class="recon-btn recon-btn-sm recon-btn-outline-danger"
                                        onclick="return confirm('Eliminar este ficheiro?')">
                                    <i class="fas fa-trash"></i>
                                </button>
                            </div>
                        @endforeach
                    </div>
                @else
                    <div class="recon-empty">
                        <i class="fas fa-folder-open"></i>
                        <h3>Nenhum ficheiro pendente</h3>
                        <p>Todos os ficheiros foram processados</p>
                    </div>
                @endif
            </div>
        </div>

        <!-- Recent Activity -->
        <div class="recon-section">
            <div class="recon-section-header">
                <h2 class="recon-section-title"><i class="fas fa-history"></i> Atividade Recente</h2>
            </div>
            <div class="recon-section-content">
                @if($recent_activity && $recent_activity->count() > 0)
                    <div class="recon-activity-list">
                        @foreach($recent_activity as $activity)
                            <div class="recon-activity-item">
                                <div class="recon-activity-icon {{ $activity['color'] }}">
                                    <i class="{{ $activity['icon'] }}"></i>
                                </div>
                                <div class="recon-activity-content">
                                    <p class="recon-activity-desc">{{ $activity['description'] }}</p>
                                    <span class="recon-activity-time">{{ $activity['formatted_created_at'] }}</span>
                                </div>
                            </div>
                        @endforeach
                    </div>
                @else
                    <div class="recon-empty">
                        <i class="fas fa-history"></i>
                        <h3>Nenhuma atividade recente</h3>
                        <p>As atividades de reconciliação aparecerão aqui</p>
                    </div>
                @endif
            </div>
        </div>

        <!-- Unmatched Payments -->
        <div class="recon-section">
            <div class="recon-section-header">
                <h2 class="recon-section-title"><i class="fas fa-exclamation-triangle"></i> Pagamentos Não Coincidentes</h2>
                <span class="recon-badge warning">{{ $unmatched_payments ? $unmatched_payments->count() : 0 }}</span>
            </div>
            <div class="recon-section-content">
                @if($unmatched_payments && $unmatched_payments->count() > 0)
                    <div class="recon-list">
                        @foreach($unmatched_payments->take(5) as $payment)
                            <div class="recon-list-item">
                                <div class="recon-list-content">
                                    <h4 class="recon-list-title">{{ $payment->reference ?: 'Ref. N/A' }}</h4>
                                    <div class="recon-list-meta">
                                        <span class="recon-text-success recon-font-medium">{{ $payment->formatted_amount }}</span>
                                        <span class="recon-text-warning">{{ $payment->age_days }} dias</span>
                                    </div>
                                </div>
                                @if($payment->can_reconcile_manually)
                                    <button wire:click="openManualReconciliation"
                                            wire:click.prevent="$set('manualReference', '{{ $payment->reference }}')"
                                            class="recon-btn recon-btn-sm recon-btn-warning">
                                        <i class="fas fa-edit"></i> Reconciliar
                                    </button>
                                @endif
                            </div>
                        @endforeach
                        
                        @if($unmatched_payments && $unmatched_payments->count() > 5)
                            <div class="recon-text-center recon-mt-4">
                                <small class="recon-text-muted">
                                    Mais {{ $unmatched_payments->count() - 5 }} pagamentos...
                                </small>
                            </div>
                        @endif
                    </div>
                @else
                    <div class="recon-empty success">
                        <i class="fas fa-check-circle"></i>
                        <h3>Todos reconciliados</h3>
                        <p>Não há pagamentos não coincidentes</p>
                    </div>
                @endif
            </div>
        </div>
    </div>

    <!-- Logs Table -->
    <div class="recon-section">
        <div class="recon-section-header">
            <h2 class="recon-section-title"><i class="fas fa-list-alt"></i> Logs de Reconciliação</h2>
            <div class="recon-filters">
                <div class="recon-filter-group">
                    <select wire:model="filterStatus" class="recon-form-input">
                        <option value="all">Todos os Status</option>
                        <option value="completed">Completos</option>
                        <option value="failed">Falhados</option>
                        <option value="processing">Processando</option>
                    </select>
                </div>
                <div class="recon-filter-group">
                    <input type="date" wire:model="filterDateFrom" class="recon-form-input" placeholder="Data inicial">
                </div>
                <div class="recon-filter-group">
                    <input type="date" wire:model="filterDateTo" class="recon-form-input" placeholder="Data final">
                </div>
                <div class="recon-filter-group">
                    <input type="text" wire:model.debounce.300ms="searchTerm" class="recon-form-input"
                           placeholder="Pesquisar ficheiros...">
                </div>
            </div>
        </div>
        
        <div class="recon-section-content">
            <div class="recon-table-wrapper">
                <table class="recon-table">
                    <thead>
                        <tr>
                            <th>Ficheiro</th>
                            <th>Data/Hora</th>
                            <th>Status</th>
                            <th>Registos</th>
                            <th>Reconciliados</th>
                            <th>Falhados</th>
                            <th>Duplicados</th>
                            <th>Valor Total</th>
                            <th>Tempo</th>
                        </tr>
                    </thead>
                    <tbody>
                        @forelse($reconciliation_logs as $log)
                            <tr>
                                <td>
                                    <div class="recon-file-cell">
                                        <i class="fas fa-file-alt"></i>
                                        <span>{{ $log->file_name }}</span>
                                    </div>
                                </td>
                                <td>{{ \Carbon\Carbon::parse($log->started_at)->format('d/m/Y H:i') }}</td>
                                <td>
                                    <span class="recon-status-badge recon-status-{{ $log->status }}">
                                        @switch($log->status)
                                            @case('completed')
                                                <i class="fas fa-check-circle"></i> Completo
                                                @break
                                            @case('failed')
                                                <i class="fas fa-times-circle"></i> Falhado
                                                @break
                                            @case('processing')
                                                <i class="fas fa-spinner recon-spinner"></i> Processando
                                                @break
                                            @default
                                                <i class="fas fa-question-circle"></i> {{ ucfirst($log->status) }}
                                        @endswitch
                                    </span>
                                </td>
                                <td class="recon-text-center">{{ $log->total_records ?? 0 }}</td>
                                <td class="recon-text-center recon-text-success">{{ $log->reconciled ?? 0 }}</td>
                                <td class="recon-text-center recon-text-danger">{{ $log->failed ?? 0 }}</td>
                                <td class="recon-text-center recon-text-warning">{{ $log->duplicates ?? 0 }}</td>
                                <td class="recon-text-right">MT {{ number_format($log->total_amount ?? 0, 2, ',', '.') }}</td>
                                <td class="recon-text-center">
                                    @if($log->completed_at && $log->started_at)
                                        {{ \Carbon\Carbon::parse($log->started_at)->diffInSeconds(\Carbon\Carbon::parse($log->completed_at)) }}s
                                    @else
                                        --
                                    @endif
                                </td>
                            </tr>
                        @empty
                            <tr>
                                <td colspan="9" class="recon-text-center">
                                    <div class="recon-empty">
                                        <i class="fas fa-list-alt"></i>
                                        <h3>Nenhum log encontrado</h3>
                                        <p>Os logs de reconciliação aparecerão aqui após o processamento</p>
                                    </div>
                                </td>
                            </tr>
                        @endforelse
                    </tbody>
                </table>
            </div>
            
            @if($reconciliation_logs && method_exists($reconciliation_logs, 'hasPages') && $reconciliation_logs->hasPages())
                <div class="recon-pagination">
                    {{ $reconciliation_logs->links() }}
                </div>
            @endif
        </div>
    </div>

    <!-- Manual Reconciliation Modal -->
    @if($showManualModal)
        <div class="recon-modal-overlay active" wire:click="$set('showManualModal', false)">
            <div class="recon-modal" wire:click.stop>
                <div class="recon-modal-header">
                    <h3 class="recon-modal-title"><i class="fas fa-edit"></i> Reconciliação Manual</h3>
                    <button wire:click="$set('showManualModal', false)" class="recon-modal-close">
                        <i class="fas fa-times"></i>
                    </button>
                </div>
                
                <form wire:submit.prevent="processManualReconciliation">
                    <div class="recon-modal-body">
                        <div class="recon-form-row">
                            <div class="recon-form-group">
                                <label class="recon-form-label" for="manualReference">Referência de Pagamento *</label>
                                <input type="text" wire:model.defer="manualReference"
                                       id="manualReference" class="recon-form-input"
                                       placeholder="Ex: 12345678901" maxlength="11" required>
                                @error('manualReference') <div class="recon-form-error">{{ $message }}</div> @enderror
                            </div>
                            
                            <div class="recon-form-group">
                                <label class="recon-form-label" for="manualAmount">Valor Pago (MT) *</label>
                                <input type="number" wire:model.defer="manualAmount"
                                       id="manualAmount" class="recon-form-input"
                                       step="0.01" min="0.01" placeholder="0.00" required>
                                @error('manualAmount') <div class="recon-form-error">{{ $message }}</div> @enderror
                            </div>
                        </div>
                        
                        <div class="recon-form-row">
                            <div class="recon-form-group">
                                <label class="recon-form-label" for="manualDate">Data do Pagamento *</label>
                                <input type="date" wire:model.defer="manualDate"
                                       id="manualDate" class="recon-form-input" required>
                                @error('manualDate') <div class="recon-form-error">{{ $message }}</div> @enderror
                            </div>
                            
                            <div class="recon-form-group">
                                <label class="recon-form-label" for="manualTransactionId">ID da Transação</label>
                                <input type="text" wire:model.defer="manualTransactionId"
                                       id="manualTransactionId" class="recon-form-input"
                                       placeholder="Opcional">
                                @error('manualTransactionId') <div class="recon-form-error">{{ $message }}</div> @enderror
                            </div>
                        </div>
                        
                        <div class="recon-form-group">
                            <label class="recon-form-label" for="manualTerminalId">ID do Terminal</label>
                            <input type="text" wire:model.defer="manualTerminalId"
                                   id="manualTerminalId" class="recon-form-input"
                                   placeholder="Opcional">
                            @error('manualTerminalId') <div class="recon-form-error">{{ $message }}</div> @enderror
                        </div>
                        
                        <div class="recon-form-group">
                            <label class="recon-form-label" for="manualNote">Observações</label>
                            <textarea wire:model.defer="manualNote" id="manualNote"
                                      class="recon-form-input recon-form-textarea" rows="3"
                                      placeholder="Observações sobre esta reconciliação manual..."></textarea>
                            @error('manualNote') <div class="recon-form-error">{{ $message }}</div> @enderror
                        </div>
                        
                        <div class="recon-alert recon-alert-info">
                            <i class="fas fa-info-circle"></i>
                            <div>
                                <strong>Importante:</strong> Esta reconciliação será registada como manual no sistema.
                                Certifique-se de que os dados estão corretos antes de confirmar.
                            </div>
                        </div>
                    </div>
                    
                    <div class="recon-modal-footer">
                        <button type="button" wire:click="$set('showManualModal', false)"
                                class="recon-btn recon-btn-outline">
                            Cancelar
                        </button>
                        <button type="submit" class="recon-btn recon-btn-success" wire:loading.attr="disabled">
                            <i class="fas fa-check" wire:loading.remove></i>
                            <i class="fas fa-spinner recon-spinner" wire:loading></i>
                            <span wire:loading.remove>Confirmar Reconciliação</span>
                            <span wire:loading>Processando...</span>
                        </button>
                    </div>
                </form>
            </div>
        </div>
    @endif
</div>

<!-- Notifications -->
@if (session()->has('success'))
    <div class="recon-notification success show" x-data x-init="setTimeout(() => $el.classList.remove('show'), 5000)">
        <i class="fas fa-check-circle"></i>
        {{ session('success') }}
    </div>
@endif

@if (session()->has('error'))
    <div class="recon-notification error show" x-data x-init="setTimeout(() => $el.classList.remove('show'), 5000)">
        <i class="fas fa-exclamation-circle"></i>
        {{ session('error') }}
    </div>
@endif

@if (session()->has('info'))
    <div class="recon-notification info show" x-data x-init="setTimeout(() => $el.classList.remove('show'), 5000)">
        <i class="fas fa-info-circle"></i>
        {{ session('info') }}
    </div>
@endif

<style>
/* Reset para evitar conflitos */
.reconciliation-dashboard * {
    box-sizing: border-box;
}

.reconciliation-dashboard {
    font-family: -apple-system, BlinkMacSystemFont, 'Segoe UI', Roboto, sans-serif;
    color: #333;
    line-height: 1.6;
    padding: 1rem;
    background: #f8fafc;
    min-height: 100vh;
}

/* Header */
.recon-header {
    background: linear-gradient(135deg, #4f46e5 0%, #7c3aed 100%);
    color: white;
    padding: 1.5rem;
    border-radius: 8px;
    margin-bottom: 1.5rem;
}

.recon-header-content {
    display: flex;
    justify-content: space-between;
    align-items: center;
    flex-wrap: wrap;
    gap: 1rem;
}

.recon-header h1 {
    font-size: 1.75rem;
    font-weight: 600;
    margin: 0;
    display: flex;
    align-items: center;
    gap: 0.5rem;
}

.recon-header p {
    margin: 0.5rem 0 0 0;
    opacity: 0.9;
}

.recon-header-actions {
    display: flex;
    gap: 0.75rem;
    flex-wrap: wrap;
}

/* Stats Grid */
.recon-stats-grid {
    display: grid;
    grid-template-columns: repeat(auto-fit, minmax(250px, 1fr));
    gap: 1rem;
    margin-bottom: 1.5rem;
}

.recon-stat-card {
    background: white;
    border: 1px solid #e5e7eb;
    border-radius: 8px;
    padding: 1.25rem;
    box-shadow: 0 1px 3px rgba(0, 0, 0, 0.1);
}

.recon-stat-header {
    display: flex;
    align-items: center;
    gap: 0.75rem;
    margin-bottom: 1rem;
}

.recon-stat-icon {
    width: 40px;
    height: 40px;
    border-radius: 8px;
    display: flex;
    align-items: center;
    justify-content: center;
    color: white;
    font-size: 1.25rem;
}

.recon-stat-icon.today { background: #10b981; }
.recon-stat-icon.week { background: #3b82f6; }
.recon-stat-icon.month { background: #8b5cf6; }
.recon-stat-icon.pending { background: #f59e0b; }

.recon-stat-title {
    font-weight: 600;
    color: #374151;
    margin: 0;
}

.recon-stat-metrics {
    display: flex;
    flex-direction: column;
    gap: 0.5rem;
}

.recon-metric {
    display: flex;
    justify-content: space-between;
    align-items: center;
}

.recon-metric-value {
    font-weight: 600;
    color: #111827;
}

.recon-metric-label {
    font-size: 0.875rem;
    color: #6b7280;
}

/* Main Grid */
.recon-main-grid {
    display: grid;
    grid-template-columns: repeat(auto-fit, minmax(350px, 1fr));
    gap: 1.5rem;
    margin-bottom: 1.5rem;
}

/* Sections */
.recon-section {
    background: white;
    border: 1px solid #e5e7eb;
    border-radius: 8px;
    overflow: hidden;
    box-shadow: 0 1px 3px rgba(0, 0, 0, 0.1);
}

.recon-section-header {
    padding: 1rem 1.25rem;
    border-bottom: 1px solid #e5e7eb;
    background: #f9fafb;
    display: flex;
    justify-content: space-between;
    align-items: center;
    flex-wrap: wrap;
    gap: 0.5rem;
}

.recon-section-title {
    font-size: 1.125rem;
    font-weight: 600;
    color: #111827;
    margin: 0;
    display: flex;
    align-items: center;
    gap: 0.5rem;
}

.recon-badge {
    background: #e5e7eb;
    color: #374151;
    padding: 0.25rem 0.5rem;
    border-radius: 12px;
    font-size: 0.75rem;
    font-weight: 500;
}

.recon-badge.warning {
    background: #fef3c7;
    color: #d97706;
}

.recon-section-content {
    padding: 1.25rem;
}

/* Upload Section */
.recon-upload-zone {
    border: 2px dashed #d1d5db;
    border-radius: 6px;
    padding: 2rem 1rem;
    text-align: center;
    cursor: pointer;
    transition: all 0.2s;
}

.recon-upload-zone:hover {
    border-color: #9ca3af;
    background: #f9fafb;
}

.recon-upload-zone.dragover {
    border-color: #3b82f6;
    background: #eff6ff;
}

.recon-upload-icon {
    font-size: 2.5rem;
    color: #9ca3af;
    margin-bottom: 1rem;
}

.recon-upload-text {
    font-weight: 500;
    color: #374151;
    margin: 0 0 0.5rem 0;
}

.recon-upload-subtext {
    color: #6b7280;
    margin: 0 0 1rem 0;
    font-size: 0.875rem;
}

.recon-file-input {
    display: none;
}

.recon-file-preview {
    text-align: center;
}

.recon-file-info {
    display: flex;
    align-items: center;
    justify-content: center;
    gap: 1rem;
    margin-bottom: 1rem;
}

.recon-file-details h4 {
    margin: 0;
    font-weight: 500;
}

.recon-file-details p {
    margin: 0;
    color: #6b7280;
    font-size: 0.875rem;
}

.recon-progress-container {
    margin: 1rem 0;
}

.recon-progress-bar {
    width: 100%;
    height: 6px;
    background: #e5e7eb;
    border-radius: 3px;
    overflow: hidden;
}

.recon-progress-fill {
    height: 100%;
    background: linear-gradient(90deg, #3b82f6, #10b981);
    transition: width 0.3s;
}

.recon-progress-text {
    display: block;
    margin-top: 0.5rem;
    font-weight: 500;
    color: #374151;
}

/* Lists */
.recon-list {
    display: flex;
    flex-direction: column;
    gap: 0.75rem;
}

.recon-list-item {
    display: flex;
    align-items: center;
    gap: 0.75rem;
    padding: 0.75rem;
    border: 1px solid #e5e7eb;
    border-radius: 6px;
    transition: all 0.2s;
}

.recon-list-item:hover {
    border-color: #d1d5db;
    background: #f9fafb;
}

.recon-list-icon {
    font-size: 1.25rem;
    color: #6b7280;
    flex-shrink: 0;
}

.recon-list-content {
    flex: 1;
    min-width: 0;
}

.recon-list-title {
    font-weight: 500;
    color: #111827;
    margin: 0 0 0.25rem 0;
    word-break: break-word;
}

.recon-list-meta {
    display: flex;
    gap: 1rem;
    font-size: 0.875rem;
    color: #6b7280;
    flex-wrap: wrap;
}

.recon-list-meta span {
    display: flex;
    align-items: center;
    gap: 0.25rem;
}

/* Activity Timeline */
.recon-activity-list {
    display: flex;
    flex-direction: column;
    gap: 0.75rem;
}

.recon-activity-item {
    display: flex;
    gap: 0.75rem;
    padding: 0.75rem 0;
    border-bottom: 1px solid #f3f4f6;
}

.recon-activity-item:last-child {
    border-bottom: none;
}

.recon-activity-icon {
    width: 32px;
    height: 32px;
    border-radius: 50%;
    display: flex;
    align-items: center;
    justify-content: center;
    font-size: 0.875rem;
    flex-shrink: 0;
}

.recon-activity-icon.success { background: #dcfce7; color: #16a34a; }
.recon-activity-icon.info { background: #dbeafe; color: #2563eb; }
.recon-activity-icon.warning { background: #fef3c7; color: #d97706; }
.recon-activity-icon.danger { background: #fee2e2; color: #dc2626; }

.recon-activity-content {
    flex: 1;
    min-width: 0;
}

.recon-activity-desc {
    margin: 0 0 0.25rem 0;
    font-size: 0.875rem;
    color: #111827;
    word-break: break-word;
}

.recon-activity-time {
    font-size: 0.75rem;
    color: #6b7280;
}

/* Buttons */
.recon-btn {
    padding: 0.5rem 1rem;
    border: none;
    border-radius: 6px;
    font-weight: 500;
    font-size: 0.875rem;
    cursor: pointer;
    transition: all 0.2s;
    display: inline-flex;
    align-items: center;
    justify-content: center;
    gap: 0.5rem;
    text-decoration: none;
    background: transparent;
}

.recon-btn:disabled {
    opacity: 0.6;
    cursor: not-allowed;
}

.recon-btn-primary {
    background: #3b82f6;
    color: white;
}

.recon-btn-primary:hover:not(:disabled) {
    background: #2563eb;
}

.recon-btn-success {
    background: #10b981;
    color: white;
}

.recon-btn-success:hover:not(:disabled) {
    background: #059669;
}

.recon-btn-info {
    background: #0891b2;
    color: white;
}

.recon-btn-info:hover:not(:disabled) {
    background: #0e7490;
}

.recon-btn-warning {
    background: #f59e0b;
    color: white;
}

.recon-btn-warning:hover:not(:disabled) {
    background: #d97706;
}

.recon-btn-outline {
    background: transparent;
    border: 1px solid #d1d5db;
    color: #374151;
}

.recon-btn-outline:hover:not(:disabled) {
    background: #f3f4f6;
}

.recon-btn-outline-danger {
    background: transparent;
    border: 1px solid #dc2626;
    color: #dc2626;
}

.recon-btn-outline-danger:hover:not(:disabled) {
    background: #dc2626;
    color: white;
}

.recon-btn-sm {
    padding: 0.375rem 0.75rem;
    font-size: 0.75rem;
}

/* Actions */
.recon-actions {
    display: flex;
    gap: 0.5rem;
    flex-wrap: wrap;
    justify-content: center;
    margin-top: 1rem;
}

/* Empty State */
.recon-empty {
    text-align: center;
    padding: 2rem 1rem;
    color: #6b7280;
}

.recon-empty i {
    font-size: 2.5rem;
    margin-bottom: 1rem;
    opacity: 0.5;
}

.recon-empty h3 {
    font-size: 1.125rem;
    font-weight: 500;
    margin: 0 0 0.5rem 0;
    color: #374151;
}

.recon-empty p {
    margin: 0;
    font-size: 0.875rem;
}

.recon-empty.success i {
    color: #10b981;
    opacity: 1;
}

/* Modal */
.recon-modal-overlay {
    position: fixed;
    top: 0;
    left: 0;
    right: 0;
    bottom: 0;
    background: rgba(0, 0, 0, 0.5);
    display: flex;
    align-items: center;
    justify-content: center;
    z-index: 9999;
    padding: 1rem;
    opacity: 0;
    visibility: hidden;
    transition: all 0.3s;
}

.recon-modal-overlay.active {
    opacity: 1;
    visibility: visible;
}

.recon-modal {
    background: white;
    border-radius: 8px;
    width: 100%;
    max-width: 500px;
    max-height: 90vh;
    overflow-y: auto;
    transform: translateY(-20px);
    transition: transform 0.3s;
}

.recon-modal-overlay.active .recon-modal {
    transform: translateY(0);
}

.recon-modal-header {
    padding: 1.25rem;
    border-bottom: 1px solid #e5e7eb;
    display: flex;
    justify-content: space-between;
    align-items: center;
}

.recon-modal-title {
    margin: 0;
    font-size: 1.125rem;
    font-weight: 600;
    display: flex;
    align-items: center;
    gap: 0.5rem;
}

.recon-modal-close {
    background: none;
    border: none;
    font-size: 1.25rem;
    color: #6b7280;
    cursor: pointer;
    padding: 0.25rem;
    border-radius: 4px;
}

.recon-modal-close:hover {
    background: #f3f4f6;
}

.recon-modal-body {
    padding: 1.25rem;
}

.recon-modal-footer {
    padding: 1.25rem;
    border-top: 1px solid #e5e7eb;
    display: flex;
    gap: 0.75rem;
    justify-content: flex-end;
    flex-wrap: wrap;
}

/* Form */
.recon-form-group {
    margin-bottom: 1rem;
}

.recon-form-row {
    display: grid;
    grid-template-columns: 1fr 1fr;
    gap: 1rem;
    margin-bottom: 1rem;
}

.recon-form-label {
    display: block;
    font-weight: 500;
    color: #374151;
    margin-bottom: 0.5rem;
    font-size: 0.875rem;
}

.recon-form-input {
    width: 100%;
    padding: 0.625rem;
    border: 1px solid #d1d5db;
    border-radius: 6px;
    font-size: 0.875rem;
    transition: border-color 0.2s;
}

.recon-form-input:focus {
    outline: none;
    border-color: #3b82f6;
    box-shadow: 0 0 0 3px rgba(59, 130, 246, 0.1);
}

.recon-form-textarea {
    resize: vertical;
    min-height: 80px;
}

.recon-form-error {
    color: #dc2626;
    font-size: 0.75rem;
    margin-top: 0.25rem;
}

/* Table */
.recon-table-wrapper {
    overflow-x: auto;
    -webkit-overflow-scrolling: touch;
}

.recon-table {
    width: 100%;
    border-collapse: collapse;
    font-size: 0.875rem;
}

.recon-table th,
.recon-table td {
    padding: 0.75rem;
    text-align: left;
    border-bottom: 1px solid #e5e7eb;
    white-space: nowrap;
}

.recon-table th {
    font-weight: 600;
    color: #374151;
    background: #f9fafb;
}

.recon-table tbody tr:hover {
    background: #f9fafb;
}

.recon-file-cell {
    display: flex;
    align-items: center;
    gap: 0.5rem;
}

.recon-status-badge {
    display: inline-flex;
    align-items: center;
    gap: 0.25rem;
    padding: 0.25rem 0.5rem;
    border-radius: 12px;
    font-size: 0.75rem;
    font-weight: 500;
}

.recon-status-completed { background: #dcfce7; color: #16a34a; }
.recon-status-failed { background: #fee2e2; color: #dc2626; }
.recon-status-processing { background: #dbeafe; color: #2563eb; }

/* Filters */
.recon-filters {
    display: flex;
    gap: 1rem;
    flex-wrap: wrap;
    align-items: center;
}

.recon-filter-group {
    display: flex;
    flex-direction: column;
    min-width: 120px;
}

/* Pagination */
.recon-pagination {
    margin-top: 1rem;
    display: flex;
    justify-content: center;
}

/* Notifications */
.recon-notification {
    position: fixed;
    top: 1rem;
    right: 1rem;
    padding: 1rem;
    border-radius: 6px;
    color: white;
    font-weight: 500;
    z-index: 10000;
    display: flex;
    align-items: center;
    gap: 0.5rem;
    max-width: 300px;
    box-shadow: 0 4px 12px rgba(0, 0, 0, 0.3);
    transform: translateX(100%);
    transition: transform 0.3s;
}

.recon-notification.show {
    transform: translateX(0);
}

.recon-notification.success { background: #10b981; }
.recon-notification.error { background: #dc2626; }
.recon-notification.info { background: #3b82f6; }

/* Alert */
.recon-alert {
    padding: 0.75rem;
    border-radius: 6px;
    margin: 1rem 0;
    display: flex;
    align-items: flex-start;
    gap: 0.5rem;
}

.recon-alert-info {
    background: #eff6ff;
    border: 1px solid #bfdbfe;
    color: #1e40af;
}

/* Utilities */
.recon-text-center { text-align: center; }
.recon-text-right { text-align: right; }
.recon-text-success { color: #16a34a; }
.recon-text-danger { color: #dc2626; }
.recon-text-warning { color: #d97706; }
.recon-text-info { color: #2563eb; }
.recon-text-muted { color: #6b7280; }
.recon-font-medium { font-weight: 500; }
.recon-font-semibold { font-weight: 600; }
.recon-mb-4 { margin-bottom: 1rem; }
.recon-mt-4 { margin-top: 1rem; }

/* Show/Hide */
.recon-hidden { display: none; }
.recon-loading { opacity: 0.6; pointer-events: none; }

/* Loading animation */
@keyframes spin {
    to { transform: rotate(360deg); }
}

.recon-spinner {
    animation: spin 1s linear infinite;
}

/* Responsive */
@media (max-width: 768px) {
    .reconciliation-dashboard {
        padding: 0.5rem;
    }

    .recon-header-content {
        flex-direction: column;
        align-items: stretch;
    }

    .recon-header h1 {
        font-size: 1.5rem;
    }

    .recon-stats-grid {
        grid-template-columns: 1fr;
    }

    .recon-main-grid {
        grid-template-columns: 1fr;
    }

    .recon-form-row {
        grid-template-columns: 1fr;
    }

    .recon-filters {
        flex-direction: column;
        align-items: stretch;
    }

    .recon-filter-group {
        min-width: auto;
    }

    .recon-modal {
        margin: 0.5rem;
        max-width: none;
    }

    .recon-modal-footer {
        flex-direction: column;
    }

    .recon-btn {
        width: 100%;
        justify-content: center;
    }

    .recon-header-actions .recon-btn {
        width: auto;
    }

    /* Hide some table columns on mobile */
    .recon-table th:nth-child(n+5),
    .recon-table td:nth-child(n+5) {
        display: none;
    }
}

@media (max-width: 480px) {
    .recon-header {
        padding: 1rem;
    }

    .recon-section-content {
        padding: 1rem;
    }

    .recon-upload-zone {
        padding: 1.5rem 0.75rem;
    }

    .recon-notification {
        left: 1rem;
        right: 1rem;
        max-width: none;
    }

    .recon-list-meta {
        flex-direction: column;
        gap: 0.25rem;
    }
}
</style>

<!-- Chart.js CDN -->
<script src="https://cdn.jsdelivr.net/npm/chart.js@4.4.0/dist/chart.umd.min.js"></script>

<script>
document.addEventListener('DOMContentLoaded', function() {
    // Initialize Charts
    initializeCharts();

    function initializeCharts() {
        // Payments Volume Chart (Last 7 Days)
        const paymentsCtx = document.getElementById('paymentsChart');
        if (paymentsCtx) {
            new Chart(paymentsCtx, {
                type: 'line',
                data: {
                    labels: ['Seg', 'Ter', 'Qua', 'Qui', 'Sex', 'Sáb', 'Dom'],
                    datasets: [{
                        label: 'Valor (MT)',
                        data: [
                            {{ ($stats['week']['total_amount'] ?? 0) * 0.10 }},
                            {{ ($stats['week']['total_amount'] ?? 0) * 0.15 }},
                            {{ ($stats['week']['total_amount'] ?? 0) * 0.12 }},
                            {{ ($stats['week']['total_amount'] ?? 0) * 0.18 }},
                            {{ ($stats['week']['total_amount'] ?? 0) * 0.20 }},
                            {{ ($stats['week']['total_amount'] ?? 0) * 0.14 }},
                            {{ ($stats['week']['total_amount'] ?? 0) * 0.11 }}
                        ],
                        borderColor: '#3b82f6',
                        backgroundColor: 'rgba(59, 130, 246, 0.1)',
                        borderWidth: 2,
                        fill: true,
                        tension: 0.4
                    }, {
                        label: 'Pagamentos',
                        data: [
                            Math.floor({{ $stats['week']['reconciled_payments'] ?? 0 }} * 0.12),
                            Math.floor({{ $stats['week']['reconciled_payments'] ?? 0 }} * 0.15),
                            Math.floor({{ $stats['week']['reconciled_payments'] ?? 0 }} * 0.14),
                            Math.floor({{ $stats['week']['reconciled_payments'] ?? 0 }} * 0.18),
                            Math.floor({{ $stats['week']['reconciled_payments'] ?? 0 }} * 0.19),
                            Math.floor({{ $stats['week']['reconciled_payments'] ?? 0 }} * 0.13),
                            Math.floor({{ $stats['week']['reconciled_payments'] ?? 0 }} * 0.09)
                        ],
                        borderColor: '#10b981',
                        backgroundColor: 'rgba(16, 185, 129, 0.1)',
                        borderWidth: 2,
                        fill: true,
                        tension: 0.4,
                        yAxisID: 'y1'
                    }]
                },
                options: {
                    responsive: true,
                    maintainAspectRatio: true,
                    interaction: {
                        mode: 'index',
                        intersect: false,
                    },
                    scales: {
                        y: {
                            type: 'linear',
                            display: true,
                            position: 'left',
                            ticks: {
                                callback: function(value) {
                                    return 'MT ' + value.toLocaleString('pt-MZ');
                                }
                            }
                        },
                        y1: {
                            type: 'linear',
                            display: true,
                            position: 'right',
                            grid: {
                                drawOnChartArea: false,
                            }
                        }
                    },
                    plugins: {
                        legend: {
                            display: true,
                            position: 'top'
                        },
                        tooltip: {
                            callbacks: {
                                label: function(context) {
                                    let label = context.dataset.label || '';
                                    if (label) {
                                        label += ': ';
                                    }
                                    if (context.parsed.y !== null) {
                                        if (context.dataset.label === 'Valor (MT)') {
                                            label += 'MT ' + context.parsed.y.toLocaleString('pt-MZ', {minimumFractionDigits: 2});
                                        } else {
                                            label += context.parsed.y;
                                        }
                                    }
                                    return label;
                                }
                            }
                        }
                    }
                }
            });
        }

        // Status Distribution Chart (Doughnut)
        const statusCtx = document.getElementById('statusChart');
        if (statusCtx) {
            new Chart(statusCtx, {
                type: 'doughnut',
                data: {
                    labels: ['Reconciliados', 'Pendentes', 'Falhados'],
                    datasets: [{
                        data: [
                            {{ $stats['week']['reconciled_payments'] ?? 0 }},
                            {{ $stats['pending']['unmatched_payments'] ?? 0 }},
                            {{ $stats['today']['failed_transactions'] ?? 0 }}
                        ],
                        backgroundColor: [
                            '#10b981',
                            '#f59e0b',
                            '#ef4444'
                        ],
                        borderWidth: 0,
                        hoverOffset: 4
                    }]
                },
                options: {
                    responsive: true,
                    maintainAspectRatio: true,
                    plugins: {
                        legend: {
                            display: false
                        },
                        tooltip: {
                            callbacks: {
                                label: function(context) {
                                    const total = context.dataset.data.reduce((a, b) => a + b, 0);
                                    const percentage = ((context.parsed / total) * 100).toFixed(1);
                                    return context.label + ': ' + context.parsed + ' (' + percentage + '%)';
                                }
                            }
                        }
                    }
                }
            });
        }

        // Monthly Trend Chart (Bar)
        const monthlyCtx = document.getElementById('monthlyTrendChart');
        if (monthlyCtx) {
            new Chart(monthlyCtx, {
                type: 'bar',
                data: {
                    labels: ['Jan', 'Fev', 'Mar', 'Abr', 'Mai', 'Jun', 'Jul', 'Ago', 'Set', 'Out', 'Nov', 'Dez'],
                    datasets: [{
                        label: 'Valor Total (MT)',
                        data: [
                            0, 0, 0, 0, 0, 0, 0, 0,
                            {{ ($stats['month']['total_amount'] ?? 0) * 0.85 }},
                            {{ ($stats['month']['total_amount'] ?? 0) * 0.92 }},
                            {{ ($stats['month']['total_amount'] ?? 0) * 1.00 }},
                            0
                        ],
                        backgroundColor: '#3b82f6',
                        borderRadius: 6
                    }]
                },
                options: {
                    responsive: true,
                    maintainAspectRatio: true,
                    scales: {
                        y: {
                            beginAtZero: true,
                            ticks: {
                                callback: function(value) {
                                    return 'MT ' + (value / 1000).toFixed(0) + 'k';
                                }
                            }
                        }
                    },
                    plugins: {
                        legend: {
                            display: false
                        },
                        tooltip: {
                            callbacks: {
                                label: function(context) {
                                    return 'Total: MT ' + context.parsed.y.toLocaleString('pt-MZ', {minimumFractionDigits: 2});
                                }
                            }
                        }
                    }
                }
            });
        }

        // Success Rate Chart (Horizontal Bar)
        const successCtx = document.getElementById('successRateChart');
        if (successCtx) {
            const successRate = {{ $stats['week']['success_rate'] ?? 0 }};
            new Chart(successCtx, {
                type: 'bar',
                data: {
                    labels: ['Taxa de Sucesso'],
                    datasets: [{
                        label: 'Sucesso (%)',
                        data: [successRate],
                        backgroundColor: successRate >= 90 ? '#10b981' : successRate >= 70 ? '#f59e0b' : '#ef4444',
                        borderRadius: 8
                    }, {
                        label: 'Falhas (%)',
                        data: [100 - successRate],
                        backgroundColor: '#e5e7eb',
                        borderRadius: 8
                    }]
                },
                options: {
                    indexAxis: 'y',
                    responsive: true,
                    maintainAspectRatio: true,
                    scales: {
                        x: {
                            stacked: true,
                            max: 100,
                            ticks: {
                                callback: function(value) {
                                    return value + '%';
                                }
                            }
                        },
                        y: {
                            stacked: true,
                            display: false
                        }
                    },
                    plugins: {
                        legend: {
                            display: false
                        },
                        tooltip: {
                            callbacks: {
                                label: function(context) {
                                    return context.dataset.label + ': ' + context.parsed.x.toFixed(1) + '%';
                                }
                            }
                        }
                    }
                }
            });
        }
    }

    // Original DOMContentLoaded code continues below

    // Auto-hide notifications
    const notifications = document.querySelectorAll('.recon-notification');
    notifications.forEach(notification => {
        setTimeout(() => {
            notification.classList.remove('show');
            setTimeout(() => {
                if (notification.parentNode) {
                    notification.remove();
                }
            }, 300);
        }, 5000);
    });

    // Modal keyboard navigation
    document.addEventListener('keydown', (e) => {
        if (e.key === 'Escape') {
            const modal = document.querySelector('.recon-modal-overlay.active');
            if (modal) {
                @this.set('showManualModal', false);
            }
        }
    });

    // File input validation
    const fileInput = document.getElementById('fileInput');
    if (fileInput) {
        fileInput.addEventListener('change', (e) => {
            const file = e.target.files[0];
            if (file) {
                const validTypes = ['text/plain'];
                const maxSize = 10 * 1024 * 1024; // 10MB
                
                if (!validTypes.includes(file.type) && !file.name.toLowerCase().endsWith('.txt')) {
                    alert('Por favor, selecione um arquivo .txt válido');
                    e.target.value = '';
                    return;
                }
                
                if (file.size > maxSize) {
                    alert('O arquivo é muito grande. Máximo permitido: 10MB');
                    e.target.value = '';
                    return;
                }
            }
        });
    }

    // Reference number formatting
    const referenceInput = document.getElementById('manualReference');
    if (referenceInput) {
        referenceInput.addEventListener('input', (e) => {
            let value = e.target.value.replace(/\D/g, '');
            if (value.length > 11) {
                value = value.substring(0, 11);
            }
            e.target.value = value;
        });
    }

    // Amount formatting
    const amountInput = document.getElementById('manualAmount');
    if (amountInput) {
        amountInput.addEventListener('blur', (e) => {
            const value = parseFloat(e.target.value);
            if (!isNaN(value)) {
                e.target.value = value.toFixed(2);
            }
        });
    }
});

// Livewire event listeners
window.addEventListener('file-processed', event => {
    const notification = document.createElement('div');
    notification.className = 'recon-notification success';
    notification.innerHTML = `
        <i class="fas fa-check-circle"></i>
        ${event.detail.message}
    `;
    document.body.appendChild(notification);
    
    setTimeout(() => {
        notification.classList.add('show');
    }, 100);
    
    setTimeout(() => {
        notification.classList.remove('show');
        setTimeout(() => {
            if (notification.parentNode) {
                notification.remove();
            }
        }, 300);
    }, 5000);
});

window.addEventListener('show-amount-warning', event => {
    const warning = `
        Aviso: Diferença no valor!
        Pago: MT ${event.detail.paid}
        Esperado: MT ${event.detail.expected}
        Diferença: MT ${event.detail.difference}
        
        Deseja continuar?
    `;
    
    if (!confirm(warning)) {
        return false;
    }
});
</script>
