<div>
    <div class="page-content">
        <div class="main-wrapper">
            <div class="row">
                <div class="col">
                    <div class="card border-0 shadow">
                        <div class="card-header bg-primary text-white py-3">
                            <h2 class="h5 mb-0">
                                <i class="fas fa-bell me-2"></i>Enviar Notificação (Android/iOS)
                            </h2>
                        </div>
                        <div class="card-body p-4">
                            <div class="row justify-content-center">
                                <div class="col-12 col-md-10 col-lg-8 col-xl-7">
                                    <form wire:submit.prevent="submit">
                                        <div class="mb-3">
                                            <label for="type" class="form-label fw-semibold">Enviar Para <span class="text-danger">*</span></label>
                                            <div class="input-group">
                                                <span class="input-group-text bg-light"><i class="fas fa-users"></i></span>
                                                <select class="form-select" wire:model="type" id="type">
                                                    <option value="all">Todos</option>
                                                    <option value="class">Classe ou Turma</option>
                                                    <option value="student">Estudante</option>
                                                </select>
                                            </div>
                                        </div>

                                        @if($type == "class" || $type == "student")
                                            <div class="mb-3">
                                                <label for="class_id" class="form-label fw-semibold">Turma <span class="text-danger">*</span></label>
                                                <div class="input-group">
                                                    <span class="input-group-text bg-light"><i class="fas fa-school"></i></span>
                                                    <select class="form-select @error('class_id') is-invalid @enderror" wire:model="class_id" id="class_id">
                                                        <option value="">Selecione a Turma</option>
                                                        @foreach($classrooms as $class)
                                                            <option value="{{ $class->id }}">{{ $class->class }} - {{ $class->name }}</option>
                                                        @endforeach
                                                    </select>
                                                </div>
                                                @error('class_id')
                                                    <div class="invalid-feedback d-block">{{ $message }}</div>
                                                @enderror
                                            </div>
                                        @endif

                                        @if($type == "student")
                                            <div class="mb-3">
                                                <label for="student_id" class="form-label fw-semibold">Estudante <span class="text-danger">*</span></label>
                                                <div class="input-group">
                                                    <span class="input-group-text bg-light"><i class="fas fa-user-graduate"></i></span>
                                                    <select class="form-select @error('student_id') is-invalid @enderror" wire:model="student_id" id="student_id">
                                                        <option value="">Selecione o Estudante</option>
                                                        @foreach($students as $student)
                                                            <option value="{{ $student->id }}">{{ $student->name }}</option>
                                                        @endforeach
                                                    </select>
                                                </div>
                                                @error('student_id')
                                                    <div class="invalid-feedback d-block">{{ $message }}</div>
                                                @enderror
                                            </div>
                                        @endif

                                        <div class="mb-3">
                                            <label for="title" class="form-label fw-semibold">Título <span class="text-danger">*</span></label>
                                            <div class="input-group">
                                                <span class="input-group-text bg-light"><i class="fas fa-heading"></i></span>
                                                <input type="text"
                                                       class="form-control @error('title') is-invalid @enderror"
                                                       id="title"
                                                       wire:model="title"
                                                       placeholder="Escreva o título da notificação..."
                                                       required>
                                            </div>
                                            @error('title')
                                                <div class="invalid-feedback d-block">{{ $message }}</div>
                                            @enderror
                                        </div>

                                        <div class="mb-3">
                                            <label for="message" class="form-label fw-semibold">Mensagem <span class="text-danger">*</span></label>
                                            <div class="input-group">
                                                <span class="input-group-text bg-light align-items-start pt-2"><i class="fas fa-comment-dots"></i></span>
                                                <textarea class="form-control @error('message') is-invalid @enderror"
                                                          id="message"
                                                          wire:model="message"
                                                          rows="4"
                                                          placeholder="Escreva a mensagem da notificação..."
                                                          required></textarea>
                                            </div>
                                            @error('message')
                                                <div class="invalid-feedback d-block">{{ $message }}</div>
                                            @enderror
                                        </div>

                                        <div class="d-flex justify-content-end border-top pt-4 mt-4">
                                            <button type="submit"
                                                    class="btn btn-primary px-5"
                                                    wire:loading.attr="disabled"
                                                    wire:target="submit">
                                                <span wire:loading wire:target="submit" class="spinner-border spinner-border-sm me-2"></span>
                                                <i wire:loading.remove wire:target="submit" class="fas fa-paper-plane me-2"></i>
                                                Enviar Notificação
                                            </button>
                                        </div>
                                    </form>
                                </div>
                            </div>
                        </div>
                    </div>
                </div>
            </div>
        </div>
    </div>
</div>