<div>
    <div class="page-content">
        <div class="main-wrapper">
            <div class="row">
                <div class="col">
                    <div class="card">
                        <div class="card-body" wire:init="loadData">
                            <h5 class="card-title"> Lista de Confirmações de Pagamento</h5>
                            <div class="row">
                                <div class="col-md-6 mb-3">
                                    <input type="search" wire:model="searchTerm" placeholder="Pesquisar..." class="form-control">
                                </div>

                                 @if(isset($user) && $user->role == 0) <!-- Show Only For Admin -->
                                    <div class="col-md-6 mb-3">
                                        <div class="form-group">
                                            <select id="classFilter" wire:model="selectedClass" class="form-control">
                                                <option value="">Todas classes</option>
                                                @foreach($classes as $class)
                                                    <option value="{{ $class->id }}">{{ $class->class }} - {{ $class->name }}</option>
                                                @endforeach
                                            </select>
                                        </div>
                                    </div>
                                @endif
                            </div>

                            <div class="table-responsive payment-table-container" wire:init="loadData">
                                @if(count($models))
                                    <table class="table table-hover payment-confirmations-table">
                                        <thead>
                                            <tr>
                                                <th scope="col">#</th>
                                                <th scope="col">Para</th>
                                                <th scope="col">Classe</th>
                                                <th scope="col">Estudante</th>
                                                <th scope="col">Descrição</th>
                                                <th scope="col">Ficheiro</th>
                                                @if(isset($user) && $user->role == 0)
                                                    <th scope="col">Acção</th>
                                                @endif
                                            </tr>
                                        </thead>
                                        <tbody>
                                            @php($count = 1)
                                            @foreach ($models as $model)
                                                @if ($model) {{-- Ensure the model is not null --}}
                                                    <tr>
                                                        <th scope="row" data-label="#">{{ $count++ }}</th>
                                                        <td data-label="Para">{{ $model['typeTitle'] }}</td>
                                                        <td data-label="Classe">{{ $model['classDetails'] ?? 'N/A' }}</td>
                                                        <td data-label="Estudante">{{ $model['studentName'] ?? 'N/A' }}</td>
                                                        <td data-label="Descrição">{{ $model['title'] }}</td>
                                                        <td data-label="Ficheiro"><a href="{{ $model['mediaUrl'] }}" class="text-primary"><i class="fa fa-file me-1"></i>{{ $model['mediaName'] }}</a></td>
                                                        @if(isset($user) && $user->role == 0)
                                                            <td data-label="Acção">
                                                                <div class="action-buttons">
                                                                    <a href="" class="btn btn-outline-primary btn-sm mb-1">
                                                                        <span class="fa fa-edit me-1"></span><span class="btn-text">Editar</span>
                                                                    </a>
                                                                    <a type="button" wire:click="submit('')" class="btn btn-outline-danger btn-sm">
                                                                        <span class="fa fa-trash me-1"></span><span class="btn-text">Apagar</span>
                                                                    </a>
                                                                </div>
                                                            </td>
                                                        @endif
                                                    </tr>
                                                @endif
                                            @endforeach
                                        </tbody>
                                    </table>
                                    <div class="d-flex justify-content-center">
                                        {{ $models->links() }}
                                    </div>
                                @else
                                    <br>
                                    <br>
                                    <div  class="d-flex justify-content-center">
                                        <div wire:loading class="spinner-border text-primary" role="status">
                                            <span class="sr-only">Processando...</span>
                                        </div>
                                    </div>
                                    <p class="text-center"><B>Nenhum dado foi encontrado no momento.</B></p>
                                @endif
                            </div>
                        </div>
                    </div>
                </div>
            </div>
        </div>
    </div>
</div>

<style>
/* Mobile Responsive Styles for Payment Confirmations */
@media (max-width: 768px) {
    .payment-table-container {
        overflow-x: visible !important;
    }

    .payment-confirmations-table thead {
        display: none;
    }

    .payment-confirmations-table tbody tr {
        display: block;
        margin-bottom: 1rem;
        border: 1px solid #dee2e6;
        border-radius: 8px;
        padding: 1rem;
        background: #fff;
        box-shadow: 0 2px 4px rgba(0,0,0,0.05);
    }

    .payment-confirmations-table tbody td,
    .payment-confirmations-table tbody th {
        display: flex;
        justify-content: space-between;
        align-items: center;
        padding: 0.5rem 0;
        border: none;
        border-bottom: 1px solid #f1f1f1;
        text-align: left;
    }

    .payment-confirmations-table tbody td:last-child,
    .payment-confirmations-table tbody th:last-child {
        border-bottom: none;
    }

    .payment-confirmations-table tbody td::before,
    .payment-confirmations-table tbody th::before {
        content: attr(data-label);
        font-weight: 600;
        color: #495057;
        flex: 0 0 40%;
        font-size: 0.85rem;
    }

    .payment-confirmations-table tbody td > *,
    .payment-confirmations-table tbody th > * {
        flex: 1;
        text-align: right;
    }

    .action-buttons {
        display: flex;
        flex-direction: column;
        width: 100%;
        gap: 0.5rem;
    }

    .action-buttons .btn {
        width: 100%;
        justify-content: center;
    }

    .row > .col-md-6 {
        margin-bottom: 1rem;
    }
}

@media (max-width: 576px) {
    .card-title {
        font-size: 1.1rem;
    }

    .form-control, .form-select {
        font-size: 0.9rem;
    }

    .btn-sm {
        font-size: 0.8rem;
        padding: 0.4rem 0.8rem;
    }

    .btn-text {
        display: inline;
    }
}
</style>
