<!-- resources/views/livewire/admin/reports/fee-collection-report.blade.php -->
<div>
    <!-- Header com Estatísticas -->
    <div class="row mb-4">
        <div class="col-12">
            <div class="d-flex justify-content-between align-items-center mb-4">
                <div>
                    <h2 class="mb-1">Relatório de Coleta de Taxas</h2>
                    <p class="text-muted mb-0">Gestão e análise detalhada de pagamentos</p>
                </div>
                <div class="d-flex gap-2">
                    <button wire:click="exportPDF" class="btn btn-outline-danger" wire:loading.attr="disabled">
                        <i class="bi bi-file-pdf"></i> Exportar PDF
                    </button>
                    <button wire:click="exportExcel" class="btn btn-outline-success" wire:loading.attr="disabled">
                        <i class="bi bi-file-excel"></i> Exportar Excel
                    </button>
                    <button wire:click="print" class="btn btn-outline-primary" wire:loading.attr="disabled">
                        <i class="bi bi-printer"></i> Imprimir
                    </button>
                </div>
            </div>
        </div>
    </div>

    <!-- Cards de Resumo -->
    <div class="row mb-4">
        <div class="col-xl-3 col-md-6 mb-3">
            <div class="card border-0 shadow-sm">
                <div class="card-body">
                    <div class="d-flex justify-content-between align-items-center">
                        <div>
                            <h6 class="text-muted mb-2">Total Coletado</h6>
                            <h3 class="mb-0 text-primary">MZN {{ number_format($totalCollected, 2) }}</h3>
                            <small class="text-success">
                                <i class="bi bi-arrow-up"></i> {{ $percentageIncrease }}% este mês
                            </small>
                        </div>
                        <div class="bg-primary bg-opacity-10 rounded-circle p-3">
                            <i class="bi bi-cash-stack text-primary fs-4"></i>
                        </div>
                    </div>
                </div>
            </div>
        </div>

        <div class="col-xl-3 col-md-6 mb-3">
            <div class="card border-0 shadow-sm">
                <div class="card-body">
                    <div class="d-flex justify-content-between align-items-center">
                        <div>
                            <h6 class="text-muted mb-2">Pendente</h6>
                            <h3 class="mb-0 text-warning">MZN {{ number_format($totalPending, 2) }}</h3>
                            <small class="text-muted">{{ $pendingCount }} estudantes</small>
                        </div>
                        <div class="bg-warning bg-opacity-10 rounded-circle p-3">
                            <i class="bi bi-clock-history text-warning fs-4"></i>
                        </div>
                    </div>
                </div>
            </div>
        </div>

        <div class="col-xl-3 col-md-6 mb-3">
            <div class="card border-0 shadow-sm">
                <div class="card-body">
                    <div class="d-flex justify-content-between align-items-center">
                        <div>
                            <h6 class="text-muted mb-2">Descontos</h6>
                            <h3 class="mb-0 text-info">MZN {{ number_format($totalDiscounts, 2) }}</h3>
                            <small class="text-muted">{{ $discountCount }} aplicados</small>
                        </div>
                        <div class="bg-info bg-opacity-10 rounded-circle p-3">
                            <i class="bi bi-percent text-info fs-4"></i>
                        </div>
                    </div>
                </div>
            </div>
        </div>

        <div class="col-xl-3 col-md-6 mb-3">
            <div class="card border-0 shadow-sm">
                <div class="card-body">
                    <div class="d-flex justify-content-between align-items-center">
                        <div>
                            <h6 class="text-muted mb-2">Multas</h6>
                            <h3 class="mb-0 text-danger">MZN {{ number_format($totalFines, 2) }}</h3>
                            <small class="text-muted">{{ $fineCount }} cobradas</small>
                        </div>
                        <div class="bg-danger bg-opacity-10 rounded-circle p-3">
                            <i class="bi bi-exclamation-triangle text-danger fs-4"></i>
                        </div>
                    </div>
                </div>
            </div>
        </div>
    </div>

    <!-- Filtros Avançados -->
    <div class="card border-0 shadow-sm mb-4">
        <div class="card-header bg-white py-3">
            <div class="d-flex justify-content-between align-items-center">
                <h5 class="mb-0">
                    <i class="bi bi-funnel text-primary"></i> Filtros de Pesquisa
                </h5>
                <button wire:click="resetFilters" class="btn btn-sm btn-outline-secondary">
                    <i class="bi bi-arrow-clockwise"></i> Limpar Filtros
                </button>
            </div>
        </div>
        <div class="card-body">
            <form wire:submit.prevent="generateReport">
                <div class="row g-3">
                    <!-- Período -->
                    <div class="col-md-3">
                        <label class="form-label small text-muted">Período Rápido</label>
                        <select class="form-select" wire:model.live="quickPeriod">
                            <option value="">Personalizado</option>
                            <option value="today">Hoje</option>
                            <option value="yesterday">Ontem</option>
                            <option value="this_week">Esta Semana</option>
                            <option value="last_week">Semana Passada</option>
                            <option value="this_month">Este Mês</option>
                            <option value="last_month">Mês Passado</option>
                            <option value="this_year">Este Ano</option>
                            <option value="last_year">Ano Passado</option>
                        </select>
                    </div>

                    <!-- Data Inicial -->
                    <div class="col-md-3">
                        <label class="form-label small text-muted">Data Inicial</label>
                        <input type="date" class="form-control @error('start_date') is-invalid @enderror"
                               wire:model="start_date" {{ $quickPeriod ? 'disabled' : '' }}>
                        @error('start_date')
                            <div class="invalid-feedback">{{ $message }}</div>
                        @enderror
                    </div>

                    <!-- Data Final -->
                    <div class="col-md-3">
                        <label class="form-label small text-muted">Data Final</label>
                        <input type="date" class="form-control @error('end_date') is-invalid @enderror"
                               wire:model="end_date" {{ $quickPeriod ? 'disabled' : '' }}>
                        @error('end_date')
                            <div class="invalid-feedback">{{ $message }}</div>
                        @enderror
                    </div>

                    <!-- Ano -->
                    <div class="col-md-3">
                        <label class="form-label small text-muted">Ano Letivo</label>
                        <select class="form-select" wire:model="year">
                            <option value="">Todos os Anos</option>
                            @for($y = date('Y') - 5; $y <= date('Y') + 1; $y++)
                                <option value="{{ $y }}">{{ $y }}</option>
                            @endfor
                        </select>
                    </div>

                    <!-- Classe -->
                    <div class="col-md-3">
                        <label class="form-label small text-muted">Classe</label>
                        <select class="form-select" wire:model="grade">
                            <option value="">Todas as Classes</option>
                            @foreach($grades as $g)
                                <option value="{{ $g }}">{{ $g }}ª Classe</option>
                            @endforeach
                        </select>
                    </div>

                    <!-- Tipo de Taxa -->
                    <div class="col-md-3">
                        <label class="form-label small text-muted">Tipo de Taxa</label>
                        <select class="form-select" wire:model="fee_type">
                            <option value="">Todos os Tipos</option>
                            @foreach($feeTypes as $type)
                                <option value="{{ $type->fee_name }}">{{ $type->fee_name }}</option>
                            @endforeach
                        </select>
                    </div>

                    <!-- Status -->
                    <div class="col-md-3">
                        <label class="form-label small text-muted">Status</label>
                        <select class="form-select" wire:model="status">
                            <option value="">Todos</option>
                            <option value="paid">Pago</option>
                            <option value="unpaid">Pendente</option>
                            <option value="partial">Parcial</option>
                            <option value="overdue">Atrasado</option>
                        </select>
                    </div>

                    <!-- Tipo de Pagamento -->
                    <div class="col-md-3">
                        <label class="form-label small text-muted">Método de Pagamento</label>
                        <select class="form-select" wire:model="pay_type">
                            <option value="">Todos os Métodos</option>
                            <option value="Cash">Dinheiro</option>
                            <option value="Bank">Transferência Bancária</option>
                            <option value="Online">Online</option>
                            <option value="Mobile">Mobile Money</option>
                        </select>
                    </div>

                    <!-- Busca por Estudante -->
                    <div class="col-md-6">
                        <label class="form-label small text-muted">Buscar Estudante</label>
                        <input type="text" class="form-control" placeholder="Nome ou ID do estudante..."
                               wire:model.live.debounce.300ms="searchStudent">
                    </div>

                    <!-- Botões de Ação -->
                    <div class="col-12">
                        <div class="d-flex justify-content-end gap-2">
                            <button type="button" wire:click="resetFilters" class="btn btn-outline-secondary">
                                <i class="bi bi-x-circle"></i> Cancelar
                            </button>
                            <button type="submit" class="btn btn-primary" wire:loading.attr="disabled">
                                <span wire:loading.remove wire:target="generateReport">
                                    <i class="bi bi-search"></i> Gerar Relatório
                                </span>
                                <span wire:loading wire:target="generateReport">
                                    <span class="spinner-border spinner-border-sm me-2"></span>
                                    Processando...
                                </span>
                            </button>
                        </div>
                    </div>
                </div>
            </form>
        </div>
    </div>

    <!-- Tabela de Resultados -->
    @if($feesCollection && count($feesCollection) > 0)
    <div class="card border-0 shadow-sm">
        <div class="card-header bg-white py-3">
            <div class="d-flex justify-content-between align-items-center">
                <h5 class="mb-0">
                    <i class="bi bi-table text-primary"></i>
                    Resultados ({{ $feesCollection->count() }} registros)
                </h5>
                <div class="d-flex gap-2">
                    <input type="text" class="form-control form-control-sm" style="width: 250px;"
                           placeholder="Filtrar resultados..." wire:model.live="tableSearch">
                </div>
            </div>
        </div>
        <div class="card-body p-0">
            <div class="table-responsive">
                <table class="table table-hover mb-0">
                    <thead class="bg-light">
                        <tr>
                            <th class="px-3">
                                <input type="checkbox" class="form-check-input" wire:model="selectAll">
                            </th>
                            <th>ID</th>
                            <th>Data Pagamento</th>
                            <th>Estudante</th>
                            <th>Classe</th>
                            <th>Tipo de Taxa</th>
                            <th>Valor</th>
                            <th>Desconto</th>
                            <th>Multa</th>
                            <th>Total</th>
                            <th>Método</th>
                            <th>Status</th>
                            <th class="text-center">Ações</th>
                        </tr>
                    </thead>
                    <tbody>
                        @foreach($feesCollection as $fee)
                        <tr wire:key="fee-{{ $fee->id }}">
                            <td class="px-3">
                                <input type="checkbox" class="form-check-input"
                                       wire:model="selectedFees" value="{{ $fee->id }}">
                            </td>
                            <td>
                                <span class="badge bg-light text-dark">#{{ $fee->id }}</span>
                            </td>
                            <td>
                                <small class="text-muted">
                                    {{ \Carbon\Carbon::parse($fee->pay_day)->format('d/m/Y') }}
                                </small>
                            </td>
                            <td>
                                <div class="d-flex align-items-center">
                                    <div class="avatar-sm bg-primary bg-opacity-10 rounded-circle me-2">
                                        <span class="text-primary fw-bold">
                                            {{ substr($fee->user->name ?? 'N/A', 0, 1) }}
                                        </span>
                                    </div>
                                    <div>
                                        <div class="fw-semibold">{{ $fee->user->name ?? 'N/A' }}</div>
                                        <small class="text-muted">ID: {{ $fee->student_id }}</small>
                                    </div>
                                </div>
                            </td>
                            <td>
                                <span class="badge bg-info">{{ $fee->grade ?? '-' }}ª Classe</span>
                            </td>
                            <td>{{ $fee->fee_type ?? '-' }}</td>
                            <td class="fw-semibold">MZN {{ number_format($fee->amount ?? 0, 2) }}</td>
                            <td>
                                @if($fee->discount > 0)
                                    <span class="text-success">-MZN {{ number_format($fee->discount, 2) }}</span>
                                @else
                                    <span class="text-muted">-</span>
                                @endif
                            </td>
                            <td>
                                @if($fee->fine > 0)
                                    <span class="text-danger">+MZN {{ number_format($fee->fine, 2) }}</span>
                                @else
                                    <span class="text-muted">-</span>
                                @endif
                            </td>
                            <td class="fw-bold text-primary">
                                MZN {{ number_format(($fee->amount ?? 0) - ($fee->discount ?? 0) + ($fee->fine ?? 0), 2) }}
                            </td>
                            <td>
                                @if($fee->pay_type == 'Cash')
                                    <span class="badge bg-success">Dinheiro</span>
                                @elseif($fee->pay_type == 'Bank')
                                    <span class="badge bg-info">Banco</span>
                                @elseif($fee->pay_type == 'Online')
                                    <span class="badge bg-primary">Online</span>
                                @else
                                    <span class="badge bg-secondary">{{ $fee->pay_type ?? '-' }}</span>
                                @endif
                            </td>
                            <td>
                                @if($fee->status == 'paid')
                                    <span class="badge bg-success">Pago</span>
                                @elseif($fee->status == 'unpaid')
                                    <span class="badge bg-warning">Pendente</span>
                                @elseif($fee->status == 'overdue')
                                    <span class="badge bg-danger">Atrasado</span>
                                @else
                                    <span class="badge bg-secondary">{{ $fee->status ?? '-' }}</span>
                                @endif
                            </td>
                            <td class="text-center">
                                <div class="btn-group btn-group-sm">
                                    <button wire:click="viewDetails({{ $fee->id }})"
                                            class="btn btn-outline-primary" title="Ver Detalhes">
                                        <i class="bi bi-eye"></i>
                                    </button>
                                    <button wire:click="printReceipt({{ $fee->id }})"
                                            class="btn btn-outline-success" title="Imprimir Recibo">
                                        <i class="bi bi-printer"></i>
                                    </button>
                                    <button wire:click="sendReminder({{ $fee->id }})"
                                            class="btn btn-outline-warning" title="Enviar Lembrete"
                                            {{ $fee->status == 'paid' ? 'disabled' : '' }}>
                                        <i class="bi bi-envelope"></i>
                                    </button>
                                </div>
                            </td>
                        </tr>
                        @endforeach
                    </tbody>
                    <tfoot class="bg-light">
                        <tr>
                            <th colspan="6" class="text-end">Totais:</th>
                            <th class="fw-bold">MZN {{ number_format($feesCollection->sum('amount'), 2) }}</th>
                            <th class="fw-bold text-success">MZN {{ number_format($feesCollection->sum('discount'), 2) }}</th>
                            <th class="fw-bold text-danger">MZN {{ number_format($feesCollection->sum('fine'), 2) }}</th>
                            <th class="fw-bold text-primary">
                                MZN {{ number_format(
                                    $feesCollection->sum('amount') -
                                    $feesCollection->sum('discount') +
                                    $feesCollection->sum('fine'), 2
                                ) }}
                            </th>
                            <th colspan="3"></th>
                        </tr>
                    </tfoot>
                </table>
            </div>
        </div>
        
        <!-- Paginação -->
        @if($feesCollection instanceof \Illuminate\Pagination\LengthAwarePaginator)
        <div class="card-footer bg-white">
            {{ $feesCollection->links() }}
        </div>
        @endif
    </div>

    <!-- Ações em Lote -->
    @if(count($selectedFees) > 0)
    <div class="position-fixed bottom-0 start-50 translate-middle-x mb-4">
        <div class="card shadow-lg border-0">
            <div class="card-body py-2 px-3">
                <div class="d-flex align-items-center gap-3">
                    <span class="text-muted">
                        <i class="bi bi-check-square"></i>
                        {{ count($selectedFees) }} selecionado(s)
                    </span>
                    <button wire:click="exportSelected" class="btn btn-sm btn-outline-success">
                        <i class="bi bi-download"></i> Exportar
                    </button>
                    <button wire:click="printSelected" class="btn btn-sm btn-outline-primary">
                        <i class="bi bi-printer"></i> Imprimir
                    </button>
                    <button wire:click="sendBulkReminders" class="btn btn-sm btn-outline-warning">
                        <i class="bi bi-envelope"></i> Enviar Lembretes
                    </button>
                </div>
            </div>
        </div>
    </div>
    @endif

    @elseif($feesCollection !== null)
    <!-- Sem Resultados -->
    <div class="card border-0 shadow-sm">
        <div class="card-body text-center py-5">
            <i class="bi bi-search fs-1 text-muted"></i>
            <h5 class="mt-3">Nenhum resultado encontrado</h5>
            <p class="text-muted">Tente ajustar os filtros de pesquisa</p>
            <button wire:click="resetFilters" class="btn btn-primary mt-2">
                <i class="bi bi-arrow-clockwise"></i> Limpar Filtros
            </button>
        </div>
    </div>
    @endif

    <!-- Modal de Detalhes -->
    <div wire:ignore.self class="modal fade" id="detailsModal" tabindex="-1">
        <div class="modal-dialog modal-lg">
            <div class="modal-content">
                <div class="modal-header">
                    <h5 class="modal-title">Detalhes do Pagamento</h5>
                    <button type="button" class="btn-close" data-bs-dismiss="modal"></button>
                </div>
                <div class="modal-body">
                    @if($selectedFeeDetails)
                    <div class="row">
                        <div class="col-md-6">
                            <h6 class="text-muted mb-3">Informações do Estudante</h6>
                            <dl class="row">
                                <dt class="col-sm-4">Nome:</dt>
                                <dd class="col-sm-8">{{ $selectedFeeDetails->user->name ?? 'N/A' }}</dd>
                                
                                <dt class="col-sm-4">ID:</dt>
                                <dd class="col-sm-8">{{ $selectedFeeDetails->student_id }}</dd>
                                
                                <dt class="col-sm-4">Classe:</dt>
                                <dd class="col-sm-8">{{ $selectedFeeDetails->grade }}ª Classe</dd>
                            </dl>
                        </div>
                        <div class="col-md-6">
                            <h6 class="text-muted mb-3">Informações do Pagamento</h6>
                            <dl class="row">
                                <dt class="col-sm-4">Data:</dt>
                                <dd class="col-sm-8">{{ \Carbon\Carbon::parse($selectedFeeDetails->pay_day)->format('d/m/Y') }}</dd>
                                
                                <dt class="col-sm-4">Tipo:</dt>
                                <dd class="col-sm-8">{{ $selectedFeeDetails->fee_type }}</dd>
                                
                                <dt class="col-sm-4">Método:</dt>
                                <dd class="col-sm-8">{{ $selectedFeeDetails->pay_type }}</dd>
                                
                                <dt class="col-sm-4">Status:</dt>
                                <dd class="col-sm-8">
                                    @if($selectedFeeDetails->status == 'paid')
                                        <span class="badge bg-success">Pago</span>
                                    @else
                                        <span class="badge bg-warning">Pendente</span>
                                    @endif
                                </dd>
                            </dl>
                        </div>
                    </div>
                    
                    <hr>
                    
                    <div class="row">
                        <div class="col-12">
                            <h6 class="text-muted mb-3">Valores</h6>
                            <table class="table table-sm">
                                <tr>
                                    <td>Valor Original:</td>
                                    <td class="text-end">MZN {{ number_format($selectedFeeDetails->amount, 2) }}</td>
                                </tr>
                                <tr>
                                    <td>Desconto:</td>
                                    <td class="text-end text-success">-MZN {{ number_format($selectedFeeDetails->discount, 2) }}</td>
                                </tr>
                                <tr>
                                    <td>Multa:</td>
                                    <td class="text-end text-danger">+MZN {{ number_format($selectedFeeDetails->fine, 2) }}</td>
                                </tr>
                                <tr class="fw-bold">
                                    <td>Total:</td>
                                    <td class="text-end text-primary">
                                        MZN {{ number_format(
                                            $selectedFeeDetails->amount -
                                            $selectedFeeDetails->discount +
                                            $selectedFeeDetails->fine, 2
                                        ) }}
                                    </td>
                                </tr>
                            </table>
                        </div>
                    </div>
                    @endif
                </div>
                <div class="modal-footer">
                    <button type="button" class="btn btn-secondary" data-bs-dismiss="modal">Fechar</button>
                    <button type="button" class="btn btn-primary" wire:click="printReceipt({{ $selectedFeeDetails->id ?? 0 }})">
                        <i class="bi bi-printer"></i> Imprimir Recibo
                    </button>
                </div>
            </div>
        </div>
    </div>

    <!-- Loading Overlay -->
    <div wire:loading.flex wire:target="generateReport,exportPDF,exportExcel"
         class="position-fixed top-0 start-0 w-100 h-100 d-flex align-items-center justify-content-center"
         style="background: rgba(0,0,0,0.5); z-index: 9999;">
        <div class="bg-white rounded-3 p-4 text-center">
            <div class="spinner-border text-primary mb-3" role="status">
                <span class="visually-hidden">Carregando...</span>
            </div>
            <p class="mb-0">Processando relatório...</p>
        </div>
    </div>
</div>

<!-- Adicionar estilos customizados -->
<style>
    .avatar-sm {
        width: 35px;
        height: 35px;
        display: flex;
        align-items: center;
        justify-content: center;
    }
    
    .table th {
        font-weight: 600;
        font-size: 0.875rem;
        text-transform: uppercase;
        letter-spacing: 0.5px;
    }
    
    .badge {
        font-weight: 500;
        padding: 0.35em 0.65em;
    }
    
    .btn-group-sm .btn {
        padding: 0.25rem 0.5rem;
    }
    
    @media print {
        .btn, .form-control, .form-select {
            display: none !important;
        }
    }
</style>

<!-- Scripts para interatividade -->
<script>
    document.addEventListener('livewire:initialized', () => {
        // Inicializar tooltips do Bootstrap
        var tooltipTriggerList = [].slice.call(document.querySelectorAll('[data-bs-toggle="tooltip"]'))
        var tooltipList = tooltipTriggerList.map(function (tooltipTriggerEl) {
            return new bootstrap.Tooltip(tooltipTriggerEl)
        });
        
        // Abrir modal de detalhes
        window.addEventListener('show-details-modal', event => {
            var modal = new bootstrap.Modal(document.getElementById('detailsModal'));
            modal.show();
        });
        
        // Fechar modal
        window.addEventListener('close-details-modal', event => {
            var modal = bootstrap.Modal.getInstance(document.getElementById('detailsModal'));
            modal.hide();
        });
        
        // Mostrar notificações
        window.addEventListener('show-notification', event => {
            const toast = `
                <div class="toast show position-fixed top-0 end-0 m-3" role="alert">
                    <div class="toast-header bg-${event.detail.type}">
                        <strong class="me-auto text-white">${event.detail.title}</strong>
                        <button type="button" class="btn-close btn-close-white" data-bs-dismiss="toast"></button>
                    </div>
                    <div class="toast-body">
                        ${event.detail.message}
                    </div>
                </div>
            `;
            document.body.insertAdjacentHTML('beforeend', toast);
            
            setTimeout(() => {
                document.querySelector('.toast').remove();
            }, 5000);
        });
    });
</script>
