<div>
    <div class="page-content">
        <div class="main-wrapper">
            <div class="card border-0 shadow">
                <div class="card-header bg-primary text-white py-3 d-flex justify-content-between align-items-center">
                    <h2 class="h5 mb-0">
                        <i class="fas fa-user-graduate me-2"></i>
                        Adicionar Estudante
                    </h2>
                    <a href="{{ route('admin.list.students') }}" class="btn btn-sm btn-light">
                        <i class="fas fa-list me-1"></i>Ver Todos os Estudantes
                    </a>
                </div>

                <div class="card-body">
                    <div class="row justify-content-center">
                        <div class="col-12 col-lg-10">
                            <form wire:submit.prevent="submit" class="needs-validation" novalidate>
                                <div class="row g-3">
                                    <!-- Nome Completo -->
                                    <div class="col-md-6">
                                        <label for="name" class="form-label fw-semibold">Nome Completo <span class="text-danger">*</span></label>
                                        <div class="input-group">
                                            <span class="input-group-text bg-light"><i class="fas fa-user"></i></span>
                                            <input type="text"
                                                   id="name"
                                                   wire:model="name"
                                                   class="form-control @error('name') is-invalid @enderror"
                                                   placeholder="Ex: João Silva"
                                                   required>
                                        </div>
                                        @error('name') <span class="text-danger small">{{ $message }}</span> @enderror
                                    </div>

                                    <!-- Número Celular -->
                                    <div class="col-md-6">
                                        <label for="phone_number" class="form-label fw-semibold">Número Celular <span class="text-danger">*</span></label>
                                        <div class="input-group">
                                            <span class="input-group-text bg-light"><i class="fas fa-phone"></i></span>
                                            <input type="text"
                                                   id="phone_number"
                                                   wire:model="phone_number"
                                                   class="form-control @error('phone_number') is-invalid @enderror"
                                                   placeholder="Ex: 849281234"
                                                   required>
                                        </div>
                                        @error('phone_number') <span class="text-danger small">{{ $message }}</span> @enderror
                                    </div>

                                    <!-- Email -->
                                    <div class="col-md-6">
                                        <label for="email" class="form-label fw-semibold">Email <span class="text-danger">*</span></label>
                                        <div class="input-group">
                                            <span class="input-group-text bg-light"><i class="fas fa-envelope"></i></span>
                                            <input type="email"
                                                   id="email"
                                                   wire:model="email"
                                                   class="form-control @error('email') is-invalid @enderror"
                                                   placeholder="Ex: joao@exemplo.com"
                                                   required>
                                        </div>
                                        @error('email') <span class="text-danger small">{{ $message }}</span> @enderror
                                    </div>

                                    <!-- ID do Estudante -->
                                    <div class="col-md-6">
                                        <label for="student_id" class="form-label fw-semibold">ID do Estudante <span class="text-danger">*</span></label>
                                        <div class="input-group">
                                            <span class="input-group-text bg-light"><i class="fas fa-id-card"></i></span>
                                            <input type="text"
                                                   id="student_id"
                                                   wire:model="student_id"
                                                   class="form-control @error('student_id') is-invalid @enderror"
                                                   placeholder="Ex: EST2024001"
                                                   required>
                                        </div>
                                        @error('student_id') <span class="text-danger small">{{ $message }}</span> @enderror
                                    </div>

                                    <!-- Sexo -->
                                    <div class="col-md-6">
                                        <label for="sex" class="form-label fw-semibold">Sexo <span class="text-danger">*</span></label>
                                        <div class="input-group">
                                            <span class="input-group-text bg-light"><i class="fas fa-venus-mars"></i></span>
                                            <select id="sex"
                                                    wire:model="sex"
                                                    class="form-select @error('sex') is-invalid @enderror"
                                                    required>
                                                <option value="">Selecione o sexo...</option>
                                                <option value="Masculino">Masculino</option>
                                                <option value="Feminino">Feminino</option>
                                            </select>
                                        </div>
                                        @error('sex') <span class="text-danger small">{{ $message }}</span> @enderror
                                    </div>

                                    <!-- Data de Nascimento -->
                                    <div class="col-md-6">
                                        <label for="dob" class="form-label fw-semibold">Data de Nascimento <span class="text-danger">*</span></label>
                                        <div class="input-group">
                                            <span class="input-group-text bg-light"><i class="fas fa-calendar"></i></span>
                                            <input type="date"
                                                   id="dob"
                                                   wire:model="dob"
                                                   class="form-control @error('dob') is-invalid @enderror"
                                                   required>
                                        </div>
                                        @error('dob') <span class="text-danger small">{{ $message }}</span> @enderror
                                    </div>

                                    <!-- Classe -->
                                    <div class="col-md-6">
                                        <label for="class" class="form-label fw-semibold">Classe <span class="text-danger">*</span></label>
                                        <div class="input-group">
                                            <span class="input-group-text bg-light"><i class="fas fa-layer-group"></i></span>
                                            <select id="class"
                                                    wire:model="class"
                                                    class="form-select @error('class') is-invalid @enderror"
                                                    required>
                                                <option value="">Selecione a classe...</option>
                                                @for($i = 1; $i <= 12; $i++)
                                                    <option value="{{ $i }}">{{ $i }}ª Classe</option>
                                                @endfor
                                            </select>
                                        </div>
                                        @error('class') <span class="text-danger small">{{ $message }}</span> @enderror
                                    </div>

                                    <!-- Turma -->
                                    <div class="col-md-6">
                                        <label for="classroom_id" class="form-label fw-semibold">Turma <span class="text-danger">*</span></label>
                                        <div class="input-group">
                                            <span class="input-group-text bg-light"><i class="fas fa-door-open"></i></span>
                                            <select id="classroom_id"
                                                    wire:model="classroom_id"
                                                    class="form-select @error('classroom_id') is-invalid @enderror"
                                                    required>
                                                <option value="">Selecione a turma...</option>
                                                @foreach($classes as $class)
                                                    <option value="{{ $class->id }}">{{ $class->name }}</option>
                                                @endforeach
                                            </select>
                                        </div>
                                        @error('classroom_id') <span class="text-danger small">{{ $message }}</span> @enderror
                                    </div>
                                </div>

                                <!-- Botões -->
                                <div class="d-grid gap-2 mt-4">
                                    <button type="submit"
                                            class="btn btn-primary btn-lg"
                                            wire:loading.attr="disabled"
                                            wire:offline.attr="disabled">
                                        <span wire:loading.remove wire:target="submit">
                                            <i class="fas fa-save me-2"></i>Guardar Estudante
                                        </span>
                                        <span wire:loading wire:target="submit">
                                            <span class="spinner-border spinner-border-sm me-2"></span>
                                            Processando...
                                        </span>
                                    </button>
                                </div>
                            </form>
                        </div>
                    </div>
                </div>
            </div>
        </div>
    </div>

    <style>
        .form-label.fw-semibold {
            font-weight: 600;
            color: #495057;
        }

        .input-group-text {
            background-color: #f8f9fa;
            border-right: none;
        }

        .input-group .form-control,
        .input-group .form-select {
            border-left: none;
        }

        .input-group .form-control:focus,
        .input-group .form-select:focus {
            border-color: #ced4da;
            box-shadow: none;
        }

        .input-group:focus-within .input-group-text {
            border-color: #80bdff;
        }
    </style>
</div>
